/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.ActionAbout;
import genj.app.ActionLog;
import genj.app.ActionOptions;
import genj.app.Workbench;
import genj.app.WorkbenchListener;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomListenerAdapter;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import genj.util.swing.MacAdapter;
import genj.util.swing.MenuHelper;
import genj.view.ActionProvider;
import genj.view.SelectionSink;
import genj.view.View;
import genj.view.ViewFactory;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import spin.Spin;

class Menu
extends JMenuBar
implements SelectionSink,
WorkbenchListener {
    private static final Logger LOG = Logger.getLogger("genj.app");
    private static final Resources RES = Resources.get(Menu.class);
    private static final Registry REGISTRY = Registry.get(Menu.class);
    private Workbench workbench;
    private Gedcom gedcom;
    private List<Action> actions = new CopyOnWriteArrayList<Action>();
    private GedcomListener callback = new GedcomListenerAdapter(){

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            Menu.this.setup(gedcom);
        }
    };

    Menu(Workbench workbench) {
        this.workbench = workbench;
        workbench.addWorkbenchListener(this);
        this.setup(null);
    }

    public void fireSelection(Context context, boolean bl) {
        this.workbench.fireSelection(context, bl);
    }

    private void remove(Action action) {
        if (this.gedcom != null && action instanceof GedcomListener) {
            this.gedcom.removeGedcomListener((GedcomListener)Spin.over((Object)action));
        }
        if (action instanceof WorkbenchListener) {
            this.workbench.removeWorkbenchListener((WorkbenchListener)((Object)action));
        }
        this.actions.remove(action);
    }

    private void add(Action action) {
        this.actions.add(action);
        if (this.gedcom != null && action instanceof GedcomListener) {
            this.gedcom.addGedcomListener((GedcomListener)Spin.over((Object)action));
        }
        if (action instanceof WorkbenchListener) {
            this.workbench.addWorkbenchListener((WorkbenchListener)((Object)action));
        }
    }

    private void setup(Gedcom gedcom) {
        Object object2;
        Action action22;
        if (this.gedcom != null) {
            this.gedcom.removeGedcomListener(this.callback);
        }
        for (Action action22 : this.actions) {
            this.remove(action22);
        }
        this.gedcom = gedcom;
        this.removeAll();
        this.revalidate();
        this.repaint();
        if (this.gedcom != null) {
            this.gedcom.addGedcomListener(this.callback);
        }
        Action2.Group group = new Action2.Group("ignore");
        action22 = new ActionProvider.FileActionGroup();
        group.add((Action2)action22);
        ((Action2.Group)action22).add(new Workbench.ActionNew(this.workbench));
        ((Action2.Group)action22).add(new Workbench.ActionOpen(this.workbench));
        Workbench workbench = this.workbench;
        workbench.getClass();
        ((Action2.Group)action22).add(new Workbench.ActionSave(workbench, false));
        Workbench workbench2 = this.workbench;
        workbench2.getClass();
        ((Action2.Group)action22).add(new Workbench.ActionSave(workbench2, true));
        ((Action2.Group)action22).add(new Workbench.ActionClose(this.workbench));
        ((Action2.Group)action22).add(new ActionProvider.SeparatorAction());
        int n = 0;
        for (String object52 : Registry.get(Workbench.class).get("history", new ArrayList<String>())) {
            try {
                if (gedcom != null && object52.equals(gedcom.getOrigin().toString())) continue;
                Workbench workbench3 = this.workbench;
                workbench3.getClass();
                ((Action2.Group)action22).add(new Workbench.ActionOpen(workbench3, n++, new URL(object52)));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        ((Action2.Group)action22).add(new ActionProvider.SeparatorAction());
        if (!MacAdapter.isMac()) {
            ((Action2.Group)action22).add(new Workbench.ActionExit(this.workbench));
        }
        group.add(new ActionProvider.EditActionGroup());
        ActionProvider.ViewActionGroup viewActionGroup = new ActionProvider.ViewActionGroup();
        group.add(viewActionGroup);
        for (ViewFactory viewFactory : this.workbench.getViewFactories()) {
            Workbench workbench4 = this.workbench;
            workbench4.getClass();
            viewActionGroup.add(new Workbench.ActionOpenView(workbench4, viewFactory));
        }
        viewActionGroup.add(new ActionProvider.SeparatorAction());
        ActionProvider.ToolsActionGroup toolsActionGroup = new ActionProvider.ToolsActionGroup();
        group.add(toolsActionGroup);
        Action2.Group group2 = new Action2.Group("ignore");
        for (ActionProvider actionProvider : this.workbench.getProviders(ActionProvider.class)) {
            actionProvider.createActions(this.workbench.getContext(), ActionProvider.Purpose.MENU, group2);
            for (Object object2 : group2) {
                if (object2 instanceof Action2.Group) {
                    group.add((Action2)object2);
                    continue;
                }
                toolsActionGroup.add((Action2)object2);
            }
            group2.clear();
        }
        ActionProvider.EditActionGroup editActionGroup = new ActionProvider.EditActionGroup();
        editActionGroup.add(new ActionProvider.SeparatorAction());
        if (!MacAdapter.isMac()) {
            editActionGroup.add(new ActionOptions());
        }
        group.add(editActionGroup);
        ActionProvider.HelpActionGroup helpActionGroup = new ActionProvider.HelpActionGroup();
        helpActionGroup.add(new ActionSupport());
        helpActionGroup.add(new ActionProvider.SeparatorAction());
        helpActionGroup.add(new ActionLog());
        if (!MacAdapter.isMac()) {
            helpActionGroup.add(new ActionAbout());
        }
        group.add(helpActionGroup);
        MenuHelper menuHelper = new MenuHelper(){

            protected void set(Action action, JMenuItem jMenuItem) {
                Menu.this.add(action);
                super.set(new ActionProxy(action), jMenuItem);
            }
        };
        menuHelper.pushMenu(this);
        object2 = group.iterator();
        while (object2.hasNext()) {
            Action2 action23 = (Action2)object2.next();
            Action2.Group group3 = (Action2.Group)action23;
            if (group3.size() <= 0) continue;
            menuHelper.createMenu(group3);
            menuHelper.popMenu();
        }
    }

    public void commitRequested(Workbench workbench) {
    }

    public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
        this.setup(null);
    }

    public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
        this.setup(gedcom);
    }

    public void processStarted(Workbench workbench, Trackable trackable) {
    }

    public void processStopped(Workbench workbench, Trackable trackable) {
    }

    public void selectionChanged(Workbench workbench, Context context, boolean bl) {
        this.setup(context.getGedcom());
    }

    public void viewClosed(Workbench workbench, View view) {
    }

    public void viewOpened(Workbench workbench, View view) {
    }

    public void workbenchClosing(Workbench workbench) {
    }

    static class ActionSupport
    extends Action2 {
        private static final ImageIcon IMG = new ImageIcon(ActionAbout.class, "images/About.png");

        protected ActionSupport() {
            this.setText("Support");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Desktop.getDesktop().browse(new URI("http://genj.sourceforge.net/wiki/en/support"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private class ActionProxy
    implements Action {
        private Action delegate;

        public ActionProxy(Action action) {
            this.delegate = action;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.addPropertyChangeListener(propertyChangeListener);
        }

        public Object getValue(String string) {
            return this.delegate.getValue(string);
        }

        public boolean isEnabled() {
            return this.delegate.isEnabled();
        }

        public void putValue(String string, Object object) {
            this.delegate.putValue(string, object);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.removePropertyChangeListener(propertyChangeListener);
        }

        public void setEnabled(boolean bl) {
            this.delegate.setEnabled(bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.delegate.actionPerformed(actionEvent);
            Menu.this.setup(Menu.this.gedcom);
        }
    }
}

