/*
 * Decompiled with CFR 0.152.
 */
package genj.app;

import genj.app.Workbench;
import genj.app.WorkbenchListener;
import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.util.Resources;
import genj.util.Trackable;
import genj.util.swing.Action2;
import genj.util.swing.MenuHelper;
import genj.util.swing.ToolbarWidget;
import genj.view.ActionProvider;
import genj.view.ContextProvider;
import genj.view.Images;
import genj.view.SelectionSink;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import genj.view.ViewFactory;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import swingx.docking.DefaultDockable;
import swingx.docking.Docked;

class ViewDockable
extends DefaultDockable
implements WorkbenchListener {
    private static final Logger LOG = Logger.getLogger("genj.app");
    private static final ContextHook HOOK = new ContextHook();
    private ViewFactory factory;
    private View view;
    private Workbench workbench;
    private boolean ignoreSelectionChanged = false;
    private Tools toolbar = new Tools();

    ViewDockable(Workbench workbench, ViewFactory viewFactory) {
        this.workbench = workbench;
        this.factory = viewFactory;
        String string = viewFactory.getTitle();
        this.view = viewFactory.createView();
        this.view.putClientProperty(ViewDockable.class, this);
        this.setContent(this.view);
        this.setTitle(string);
        this.setIcon(viewFactory.getImage());
        workbench.addWorkbenchListener(this);
        this.view.setContext(workbench.getContext(), true);
    }

    void dispose() {
        this.workbench.removeWorkbenchListener(this);
        this.view.setContext(new Context(), true);
    }

    public static ViewDockable getDockable(View view) {
        return (ViewDockable)view.getClientProperty(ViewDockable.class);
    }

    public Workbench getWorkbench() {
        return this.workbench;
    }

    public void close() {
        this.workbench.closeView(this.factory.getClass());
    }

    public View getView() {
        return (View)this.getContent();
    }

    public ViewFactory getViewFactory() {
        return this.factory;
    }

    public void docked(Docked docked) {
        super.docked(docked);
        this.toolbar.beginUpdate();
        this.view.populate(this.toolbar);
        this.toolbar.endUpdate();
    }

    public void selectionChanged(Workbench workbench, Context context, boolean bl) {
        if (!this.ignoreSelectionChanged || bl) {
            this.view.setContext(context, bl);
        }
    }

    public void commitRequested(Workbench workbench) {
        this.view.commit();
    }

    public void workbenchClosing(Workbench workbench) {
        this.view.closing();
    }

    public void gedcomClosed(Workbench workbench, Gedcom gedcom) {
    }

    public void gedcomOpened(Workbench workbench, Gedcom gedcom) {
    }

    public void viewClosed(Workbench workbench, View view) {
    }

    public void viewOpened(Workbench workbench, View view) {
    }

    public void processStarted(Workbench workbench, Trackable trackable) {
    }

    public void processStopped(Workbench workbench, Trackable trackable) {
    }

    private class Tools
    implements ToolBar {
        boolean isEmpty = true;
        boolean hasDefaults = false;

        private Tools() {
        }

        public void add(Action action) {
            ToolbarWidget.patch(ViewDockable.this.getDocked().addTool(action));
            this.isEmpty = false;
        }

        public void add(JComponent jComponent) {
            if (ViewDockable.this.getDocked() == null) {
                return;
            }
            ViewDockable.this.getDocked().addTool(jComponent);
            jComponent.setFocusable(false);
            this.isEmpty = false;
        }

        public void addSeparator() {
            if (ViewDockable.this.getDocked() == null) {
                return;
            }
            if (!this.isEmpty) {
                ViewDockable.this.getDocked().addToolSeparator();
            }
        }

        public void beginUpdate() {
            if (ViewDockable.this.getDocked() == null) {
                return;
            }
            this.hasDefaults = false;
            this.isEmpty = true;
            ViewDockable.this.getDocked().clearTools();
        }

        public void endUpdate() {
            if (ViewDockable.this.getDocked() == null) {
                return;
            }
            if (this.hasDefaults) {
                return;
            }
            this.hasDefaults = true;
            try {
                if (this.isEmpty && Toolkit.getDefaultToolkit().getScreenSize().height < 1024) {
                    return;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.addSeparator();
            this.add(new ActionCloseView());
        }
    }

    private class ActionCloseView
    extends Action2 {
        protected ActionCloseView() {
            this.setImage(Images.imgClose);
            this.setTip(Resources.get(this).getString("cc.tip.close_view", ViewDockable.this.factory.getTitle()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ViewDockable.this.workbench.closeView(ViewDockable.this.factory.getClass());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextHook
    extends Action2
    implements AWTEventListener {
        private ContextHook() {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        Toolkit.getDefaultToolkit().addAWTEventListener(ContextHook.this, 16L);
                        return null;
                    }
                });
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "Cannot install ContextHook", throwable);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JPopupMenu jPopupMenu;
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (!(component instanceof JComponent)) {
                return;
            }
            ViewContext viewContext = new ContextProvider.Lookup(component).getContext();
            if (viewContext != null && (jPopupMenu = this.getContextMenu(viewContext, Workbench.getWorkbench((Component)actionEvent.getSource()))) != null) {
                jPopupMenu.show(component, 0, 0);
            }
        }

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            if (!(aWTEvent instanceof MouseEvent)) {
                return;
            }
            final MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            if (!mouseEvent.isPopupTrigger() && mouseEvent.getID() != 500) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Workbench workbench = Workbench.getWorkbench((Component)mouseEvent.getSource());
                    if (workbench == null) {
                        return;
                    }
                    Component component = SwingUtilities.getDeepestComponentAt(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    ContextProvider.Lookup lookup = new ContextProvider.Lookup(component);
                    if (lookup.getContext() == null) {
                        return;
                    }
                    Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), component);
                    if (lookup.getProvider() == component && mouseEvent.getButton() == 1 && mouseEvent.getID() == 500 && mouseEvent.getClickCount() == 2) {
                        SelectionSink.Dispatcher.fireSelection(mouseEvent.getComponent(), lookup.getContext(), true);
                        return;
                    }
                    if (mouseEvent.isPopupTrigger() && component.isDisplayable()) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                        JPopupMenu jPopupMenu = ContextHook.this.getContextMenu(lookup.getContext(), workbench);
                        if (jPopupMenu != null) {
                            jPopupMenu.show(component, point.x, point.y);
                        }
                    }
                }
            });
        }

        private JPopupMenu getContextMenu(ViewContext viewContext, Workbench workbench) {
            if (viewContext == null || workbench == null) {
                return null;
            }
            MenuSelectionManager.defaultManager().clearSelectedPath();
            MenuHelper menuHelper = new MenuHelper();
            JPopupMenu jPopupMenu = menuHelper.createPopup();
            menuHelper.createItems(viewContext.getActions());
            ArrayList<Action2> arrayList = new ArrayList<Action2>(8);
            ArrayList<Action2> arrayList2 = new ArrayList<Action2>(8);
            HashMap<Action2.Group, Action2.Group> hashMap = new HashMap<Action2.Group, Action2.Group>();
            for (Action2 action2 : this.getProvidedActions(workbench.getProviders(ActionProvider.class), viewContext)) {
                if (action2 instanceof Action2.Group) {
                    Action2.Group group = (Action2.Group)hashMap.get(action2);
                    if (group != null) {
                        group.add(new ActionProvider.SeparatorAction());
                        group.addAll((Action2.Group)action2);
                        continue;
                    }
                    hashMap.put((Action2.Group)action2, (Action2.Group)action2);
                    arrayList.add((Action2.Group)action2);
                    continue;
                }
                arrayList2.add(action2);
            }
            menuHelper.createItems(arrayList);
            menuHelper.createItems(arrayList2);
            return jPopupMenu;
        }

        private Action2.Group getProvidedActions(List<ActionProvider> list, Context context) {
            Action2.Group group = new Action2.Group("");
            for (ActionProvider actionProvider : list) {
                actionProvider.createActions(context, ActionProvider.Purpose.CONTEXT, group);
            }
            return group;
        }
    }
}

