/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChild;
import genj.gedcom.PropertyXRef;
import genj.util.swing.ImageIcon;

public class CreateParent
extends CreateRelationship {
    private static final ImageIcon IMG = new ImageIcon(CreateParent.class, "Parents.png");
    private Indi child;
    private Fam family;

    public CreateParent(Fam fam) {
        super(resources.getString("create.parent"), fam.getGedcom(), "INDI");
        if (fam.getNoOfSpouses() >= 2) {
            throw new IllegalArgumentException("can't create additional parent in family with husband and wife");
        }
        this.family = fam;
        this.child = null;
        this.setImage(IMG);
    }

    public CreateParent(Indi indi) {
        super(resources.getString("create.parent"), indi.getGedcom(), "INDI");
        this.child = indi;
        this.setImage(IMG);
        Fam[] famArray = indi.getFamiliesWhereChild();
        for (int i = 0; i < famArray.length; ++i) {
            if (famArray[i].getNoOfSpouses() >= 2) continue;
            this.family = famArray[i];
            break;
        }
    }

    public String getDescription() {
        if (this.child != null) {
            return resources.getString("create.parent.of", this.child);
        }
        return resources.getString("create.parent.in", this.family);
    }

    public String getWarning(Entity entity) {
        Fam fam;
        if (this.child != null && this.family == null && (fam = this.child.getFamilyWhereBiologicalChild()) != null) {
            return PropertyChild.getLabelChildAlreadyinFamily(this.child, fam);
        }
        return null;
    }

    protected Property change(Entity entity, boolean bl) throws GedcomException {
        String string;
        PropertyXRef propertyXRef;
        Gedcom gedcom = entity.getGedcom();
        if (this.family != null) {
            propertyXRef = this.family.setSpouse((Indi)entity).getTarget();
            Indi indi = this.family.getOtherSpouse((Indi)entity);
            string = indi != null ? indi.getLastName() : "";
        } else {
            string = this.child.getLastName();
            this.family = (Fam)gedcom.createEntity("FAM");
            this.family.addChild(this.child);
            this.family.addDefaultProperties();
            propertyXRef = this.family.setSpouse((Indi)entity).getTarget();
            if (this.family.getNoOfSpouses() < 2) {
                Indi indi = (Indi)gedcom.createEntity("INDI");
                indi.addDefaultProperties();
                this.family.setSpouse(indi);
                if (Options.getInstance().setWifeLastname || indi.getSex() == 1) {
                    indi.setName("", string);
                }
            }
        }
        if (bl && (((Indi)entity).getSex() == 1 || Options.getInstance().setWifeLastname)) {
            ((Indi)entity).setName("", string);
        }
        return propertyXRef;
    }
}

