/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateParent;
import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertySex;
import genj.gedcom.PropertyXRef;
import genj.util.swing.ImageIcon;

public class CreateSibling
extends CreateRelationship {
    private static final ImageIcon IMG_BROTHER = new ImageIcon(CreateParent.class, "Brother.png");
    private static final ImageIcon IMG_SISTER = new ImageIcon(CreateParent.class, "Sister.png");
    private Indi sibling;
    private boolean isBrotherNotSister;

    public CreateSibling(Indi indi, boolean bl) {
        super(CreateSibling.calcName(bl), indi.getGedcom(), "INDI");
        this.sibling = indi;
        this.isBrotherNotSister = bl;
        this.setImage(bl ? IMG_BROTHER : IMG_SISTER);
    }

    private static String calcName(boolean bl) {
        String string = resources.getString("create.sibling", false);
        if (string == null) {
            return resources.getString(bl ? "create.brother" : "create.sister");
        }
        return string + " (" + (bl ? PropertySex.TXT_MALE : PropertySex.TXT_FEMALE) + ")";
    }

    public String getDescription() {
        return resources.getString("create.sibling.of", this.sibling);
    }

    protected Property change(Entity entity, boolean bl) throws GedcomException {
        Object object;
        PropertyXRef propertyXRef;
        Fam[] famArray = this.sibling.getFamiliesWhereChild();
        if (famArray.length > 0) {
            propertyXRef = famArray[0].addChild((Indi)entity);
        } else {
            famArray = ((Indi)entity).getFamiliesWhereChild();
            if (famArray.length > 0) {
                propertyXRef = famArray[0].addChild(this.sibling);
            } else {
                object = this.sibling.getGedcom();
                Fam fam = (Fam)((Gedcom)object).createEntity("FAM");
                try {
                    propertyXRef = fam.addChild((Indi)entity);
                }
                catch (GedcomException gedcomException) {
                    ((Gedcom)object).deleteEntity(fam);
                    throw gedcomException;
                }
                Indi indi = (Indi)((Gedcom)object).createEntity("INDI").addDefaultProperties();
                Indi indi2 = (Indi)((Gedcom)object).createEntity("INDI").addDefaultProperties();
                indi.setName("", this.sibling.getLastName());
                if (Options.getInstance().setWifeLastname) {
                    indi2.setName("", this.sibling.getLastName());
                }
                fam.setHusband(indi);
                fam.setWife(indi2);
                fam.addChild(this.sibling);
            }
        }
        if (bl) {
            object = (Indi)entity;
            ((Indi)object).setName("", this.sibling.getLastName());
            ((Indi)object).setSex(this.isBrotherNotSister ? 1 : 2);
        }
        return propertyXRef.getTarget();
    }
}

