/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import genj.edit.actions.CreateRelationship;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;

public class CreateSpouse
extends CreateRelationship {
    private Indi spouse;

    public CreateSpouse(Indi indi) {
        super(resources.getString("create.spouse"), indi.getGedcom(), "INDI");
        this.spouse = indi;
        this.setImage(Indi.IMG_UNKNOWN);
    }

    public String getWarning(Entity entity) {
        int n = this.spouse.getNoOfFams();
        if (n > 0) {
            return resources.getString("create.spouse.warning", this.spouse.toString(), "" + n);
        }
        return null;
    }

    public String getDescription() {
        return resources.getString("create.spouse.of", this.spouse);
    }

    protected Property change(Entity entity, boolean bl) throws GedcomException {
        Fam[] famArray = this.spouse.getFamiliesWhereSpouse();
        Fam fam = null;
        if (famArray.length > 0) {
            fam = famArray[0];
        }
        if (fam == null || fam.getNoOfSpouses() >= 2) {
            fam = (Fam)this.spouse.getGedcom().createEntity("FAM").addDefaultProperties();
            fam.setSpouse(this.spouse);
        }
        return fam.setSpouse((Indi)entity).getTarget();
    }
}

