/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.beans.PropertyBean;
import genj.gedcom.Property;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.PointInTime;
import genj.util.swing.Action2;
import genj.util.swing.DateWidget;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.PopupWidget;
import genj.util.swing.TextFieldWidget;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.JLabel;

public class DateBean
extends PropertyBean {
    private static final ImageIcon PIT = new ImageIcon(PropertyBean.class, "/genj/gedcom/images/Time");
    private static final NestedBlockLayout H = new NestedBlockLayout("<row><choose/><date1/><label2/><date2/><phrase/></row>");
    private static final NestedBlockLayout V = new NestedBlockLayout("<table><row><choose/><date1/></row><row><label2/><date2/></row><row><phrase cols=\"2\"/></row></table>");
    private PropertyDate.Format format;
    private DateWidget date1;
    private DateWidget date2;
    private PopupWidget choose;
    private JLabel label2;
    private TextFieldWidget phrase;

    public DateBean() {
        this.setLayout(V.copy());
        this.setAlignmentX(0.0f);
        ArrayList<ChangeFormat> arrayList = new ArrayList<ChangeFormat>(10);
        for (int i = 0; i < PropertyDate.FORMATS.length; ++i) {
            arrayList.add(new ChangeFormat(PropertyDate.FORMATS[i]));
        }
        this.choose = new PopupWidget();
        this.choose.addItems(arrayList);
        this.add(this.choose);
        this.date1 = new DateWidget();
        this.date1.addChangeListener(this.changeSupport);
        this.add(this.date1);
        this.label2 = new JLabel();
        this.add(this.label2);
        this.date2 = new DateWidget();
        this.date2.addChangeListener(this.changeSupport);
        this.add(this.date2);
        this.phrase = new TextFieldWidget("", 10);
        this.phrase.addChangeListener(this.changeSupport);
        this.phrase.setToolTipText(RESOURCES.getString("date.interpreted"));
        this.add(this.phrase);
        this.setPreferHorizontal(false);
        this.setFormat(PropertyDate.FORMATS[0]);
        this.defaultFocus = this.date1;
    }

    public void setPreferHorizontal(boolean bl) {
        this.setLayout(bl ? H.copy() : V.copy());
        PropertyDate.Format format = this.format;
        this.format = null;
        this.setFormat(format);
        this.revalidate();
        this.repaint();
    }

    protected void commitImpl(Property property) {
        PropertyDate propertyDate = (PropertyDate)property;
        propertyDate.setValue(this.format, this.date1.getValue(), this.date2.getValue(), this.phrase.getText());
    }

    private void setFormat(PropertyDate.Format format) {
        if (this.format == format) {
            return;
        }
        this.changeSupport.fireChangeEvent();
        this.format = format;
        this.choose.setToolTipText(this.format.getName());
        String string = this.format.getPrefix1Name();
        this.choose.setIcon(string == null ? PIT : null);
        this.choose.setText(string == null ? "" : string);
        if (this.format.isRange()) {
            this.date2.setVisible(true);
            this.label2.setVisible(true);
            this.label2.setText(this.format.getPrefix2Name());
        } else {
            this.date2.setVisible(false);
            this.label2.setVisible(false);
        }
        this.phrase.setVisible(this.format.usesPhrase());
        this.revalidate();
        this.repaint();
    }

    public void setPropertyImpl(Property property) {
        if (property == null) {
            PointInTime pointInTime = new PointInTime();
            this.date1.setValue(pointInTime);
            this.date2.setValue(pointInTime);
            this.phrase.setText("");
            this.setFormat(PropertyDate.FORMATS[0]);
        } else {
            PropertyDate propertyDate = (PropertyDate)property;
            this.date1.setValue(propertyDate.getStart());
            this.date2.setValue(propertyDate.getEnd());
            this.phrase.setText(propertyDate.getPhrase());
            this.setFormat(propertyDate.getFormat());
        }
    }

    public boolean isCommittable() {
        return this.date1.getValue() != null && this.date2.getValue() != null;
    }

    private class ChangeFormat
    extends Action2 {
        private PropertyDate.Format formatToSet;

        private ChangeFormat(PropertyDate.Format format) {
            this.formatToSet = format;
            super.setText(format.getName());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DateBean.this.setFormat(this.formatToSet);
            DateBean.this.date1.requestFocusInWindow();
        }
    }
}

