/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.beans;

import genj.edit.Images;
import genj.edit.actions.RunExternal;
import genj.edit.beans.PropertyBean;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyBlob;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyFile;
import genj.gedcom.PropertyXRef;
import genj.gedcom.TagPath;
import genj.io.InputSource;
import genj.util.DefaultValueMap;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.FileChooserWidget;
import genj.util.swing.NestedBlockLayout;
import genj.util.swing.TextFieldWidget;
import genj.util.swing.ThumbnailWidget;
import genj.util.swing.ToolbarWidget;
import genj.view.ContextProvider;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaBean
extends PropertyBean
implements ContextProvider {
    private static final Resources RES = Resources.get(MediaBean.class);
    private Set<Property> OBJEsToRemove = new HashSet<Property>();
    private Map<InputSource.FileInput, Set<Property>> propsNeedingOBJEs = new DefaultValueMap(new HashMap(), new HashSet());
    private Map<InputSource, Set<Property>> currentOBJEs = new DefaultValueMap(new HashMap(), new HashSet());
    private ThumbnailWidget thumbs = new ThumbnailWidget(){

        @Override
        public String getToolTipText(InputSource inputSource) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<html><body>");
            stringBuffer.append("<b>");
            stringBuffer.append(inputSource.getName());
            stringBuffer.append("</b><br/>");
            int n = 0;
            for (Property property : (Set)MediaBean.this.currentOBJEs.get(inputSource)) {
                if (n++ > 0) {
                    stringBuffer.append("<br/>");
                }
                stringBuffer.append(property.getParent().toString());
            }
            for (Property property : (Set)MediaBean.this.propsNeedingOBJEs.get(inputSource)) {
                if (n++ > 0) {
                    stringBuffer.append("<br/>");
                }
                stringBuffer.append(property.toString());
            }
            stringBuffer.append("</body></html>");
            return stringBuffer.toString();
        }

        @Override
        protected void handleDrop(List<File> list) {
            if (list.size() == 1) {
                new Add(list.get(0)).actionPerformed(null);
            }
        }
    };
    private ToolbarWidget actions = new ToolbarWidget();
    private Action2 add = new Add();
    private Action2 del = new Del();

    public MediaBean() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.add("North", this.actions);
        this.add("Center", this.thumbs);
        this.setPreferredSize(new Dimension(128, 128));
        this.actions.setFloatable(false);
        this.actions.add(this.add);
        this.actions.add(this.del);
        this.actions.addSeparator();
        this.actions.add(this.thumbs.getFitAction());
        this.actions.add(this.thumbs.getOneAction());
        this.actions.add(this.thumbs.getAllAction());
    }

    @Override
    public ViewContext getContext() {
        Property property = this.getProperty();
        if (property == null) {
            return null;
        }
        InputSource inputSource = this.thumbs.getSelection();
        if (!(inputSource instanceof InputSource.FileInput)) {
            return null;
        }
        ViewContext viewContext = new ViewContext(property);
        viewContext.addAction(new RunExternal(((InputSource.FileInput)inputSource).getFile()));
        return viewContext;
    }

    @Override
    protected void commitImpl(Property property) {
        for (Property property2 : this.OBJEsToRemove) {
            property2.getParent().delProperty(property2);
        }
        this.OBJEsToRemove.clear();
        Gedcom gedcom = property.getGedcom();
        boolean bl = Options.getInstance().isUseInline || !property.getGedcom().getGrammar().getMeta(new TagPath("OBJE")).allows("FILE");
        for (InputSource.FileInput fileInput : this.propsNeedingOBJEs.keySet()) {
            Media media = null;
            for (Property property3 : this.propsNeedingOBJEs.get(fileInput)) {
                if (bl) {
                    property3.addFile(fileInput.getFile(), fileInput.getName());
                    continue;
                }
                property3.addMedia(media == null ? this.createMedia(gedcom, fileInput) : media);
            }
        }
        this.propsNeedingOBJEs.clear();
    }

    private Media createMedia(Gedcom gedcom, InputSource.FileInput fileInput) {
        Media media;
        for (Entity entity : gedcom.getEntities("OBJE")) {
            Media media2 = (Media)entity;
            if (fileInput.getName().length() > 0 && !fileInput.getName().equals(media2.getTitle()) || !fileInput.getFile().equals(media2.getFile())) continue;
            return media2;
        }
        try {
            media = (Media)gedcom.createEntity("OBJE");
        }
        catch (GedcomException gedcomException) {
            throw new Error("unexpected problem creating OBJE record", gedcomException);
        }
        media.addFile(fileInput.getFile());
        media.setTitle(fileInput.getName());
        return media;
    }

    @Override
    protected void setPropertyImpl(Property property) {
        this.OBJEsToRemove.clear();
        this.propsNeedingOBJEs.clear();
        this.currentOBJEs.clear();
        if (property == null) {
            this.thumbs.clear();
            this.add.setEnabled(false);
            this.del.setEnabled(false);
        } else {
            this.scan(property);
            this.thumbs.setSources(new ArrayList<InputSource>(this.currentOBJEs.keySet()));
            this.add.setEnabled(true);
            this.del.setEnabled(true);
        }
    }

    private void scan(Property property) {
        for (int i = 0; i < property.getNoOfProperties(); ++i) {
            Property property2 = property.getProperty(i);
            if (!"OBJE".equals(property2.getTag())) {
                this.scan(property2);
                continue;
            }
            this.scan(property, property2);
        }
    }

    private void scan(Property property, Property property2) {
        if (property2 instanceof PropertyXRef && ((PropertyXRef)property2).getTargetEntity() instanceof Media) {
            Media media = (Media)((PropertyXRef)property2).getTargetEntity();
            File file = media.getFile();
            if (file != null) {
                this.currentOBJEs.get(InputSource.get(media.getTitle(), file)).add(property2);
                return;
            }
            PropertyBlob propertyBlob = media.getBlob();
            if (propertyBlob != null) {
                this.currentOBJEs.get(InputSource.get(media.getTitle(), propertyBlob.getBlobData())).add(property2);
            }
            return;
        }
        Property property3 = property2.getProperty("FILE");
        if (property3 instanceof PropertyFile) {
            File file = ((PropertyFile)property3).getFile();
            if (file != null) {
                this.currentOBJEs.get(InputSource.get(property2.getPropertyValue("TITL"), file)).add(property2);
            }
            return;
        }
    }

    private Property[] list(Collection<Property> collection) {
        Property[] propertyArray = collection.toArray(new Property[0]);
        Arrays.sort(propertyArray, new PropertyComparator(".:DATE"));
        return propertyArray;
    }

    private class Del
    extends Action2
    implements PropertyChangeListener,
    ListSelectionListener {
        private JList from;
        private Action2 ok;

        public Del() {
            this.setImage(ThumbnailWidget.IMG_THUMBNAIL.getGrayedOut().getOverLayed(Images.imgDel));
            MediaBean.this.thumbs.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.setEnabled(MediaBean.this.getProperty() != null);
        }

        public void setEnabled(boolean bl) {
            if (MediaBean.this.thumbs.getSelection() == null) {
                bl = false;
            }
            super.setEnabled(bl);
            if (bl) {
                this.setTip(RES.getString("file.del"));
            } else {
                this.setTip("");
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object2;
            InputSource inputSource = MediaBean.this.thumbs.getSelection();
            if (inputSource == null) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll((Collection)MediaBean.this.currentOBJEs.get(inputSource));
            arrayList.addAll((Collection)MediaBean.this.propsNeedingOBJEs.get(inputSource));
            Collections.sort(arrayList, new PropertyComparator(".:DATE"){

                public int compare(Property property, Property property2) {
                    if ("OBJE".equals(property.getTag())) {
                        property = property.getParent();
                    }
                    if ("OBJE".equals(property2.getTag())) {
                        property2 = property2.getParent();
                    }
                    return super.compare(property, property2);
                }
            });
            ArrayList<Property> arrayList2 = new ArrayList<Property>();
            for (Object object2 : arrayList) {
                if ("OBJE".equals(((Property)object2).getTag())) {
                    arrayList2.add(((Property)object2).getParent());
                    continue;
                }
                arrayList2.add((Property)object2);
            }
            this.from = new JList<Object>(arrayList2.toArray());
            this.from.setVisibleRowCount(5);
            if (!arrayList2.isEmpty()) {
                this.from.setSelectionInterval(0, arrayList2.size() - 1);
            }
            JPanel jPanel = new JPanel(new NestedBlockLayout("<col><l1 gx=\"1\"/><targets gx=\"1\" gy=\"1\"/></col>"));
            jPanel.add(new JLabel(RES.getString("file.del")));
            jPanel.add(new JScrollPane(this.from));
            this.ok = Action2.ok();
            this.from.addListSelectionListener(this);
            if (0 != DialogHelper.openDialog(this.getTip(), 3, jPanel, (Action[])Action2.andCancel(this.ok), (Object)actionEvent)) {
                return;
            }
            object2 = (Set)MediaBean.this.currentOBJEs.get(inputSource);
            Set set = (Set)MediaBean.this.propsNeedingOBJEs.get(inputSource);
            int[] nArray = this.from.getSelectedIndices();
            for (int i = 0; i < nArray.length; ++i) {
                Property property = (Property)arrayList.get(nArray[i]);
                if (object2.remove(property)) {
                    MediaBean.this.OBJEsToRemove.add(property);
                }
                set.remove(property);
            }
            if (object2.isEmpty() && set.isEmpty()) {
                MediaBean.this.thumbs.removeSource(inputSource);
            }
            MediaBean.this.changeSupport.fireChangeEvent();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.ok.setEnabled(this.from.getSelectedIndices().length > 0);
        }
    }

    private class Add
    extends Action2
    implements ListSelectionListener,
    ChangeListener {
        private JList to;
        private Action2 ok;
        private FileChooserWidget chooser = new FileChooserWidget();

        Add(File file) {
            this.chooser.setFile(file);
        }

        Add() {
            this.setImage(ThumbnailWidget.IMG_THUMBNAIL.getOverLayed(Images.imgNew));
        }

        public void setEnabled(boolean bl) {
            if (bl && this.candidates().length == 0) {
                bl = false;
            }
            super.setEnabled(bl);
            if (bl) {
                this.setTip(RES.getString("file.add"));
            } else {
                this.setTip("");
            }
        }

        private Property[] candidates() {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            Property property = MediaBean.this.getProperty();
            if (property != null) {
                if (property.getMetaProperty().allows("OBJE")) {
                    arrayList.add(property);
                }
                for (Property property2 : property.getProperties()) {
                    if (!property2.getMetaProperty().allows("OBJE")) continue;
                    arrayList.add(property2);
                }
            }
            return MediaBean.this.list(arrayList);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object[] objectArray;
            ThumbnailWidget thumbnailWidget = new ThumbnailWidget();
            thumbnailWidget.setPreferredSize(new Dimension(128, 128));
            Origin origin = MediaBean.this.getRoot().getGedcom().getOrigin();
            this.chooser.setDirectory(PropertyBean.REGISTRY.get(origin.getName() + ".media", origin.getFile() == null ? EnvironmentChecker.getProperty("user.home", ".", "looking for media home") : origin.getFile().getParent()));
            this.chooser.setAccessory(thumbnailWidget);
            this.to = new JList<Property>(this.candidates());
            this.to.setVisibleRowCount(5);
            TextFieldWidget textFieldWidget = new TextFieldWidget();
            JPanel jPanel = new JPanel(new NestedBlockLayout("<col><l1/><file gx=\"1\"/><l2/><title gx=\"1\"/><l3/><targets gx=\"1\" gy=\"1\"/></col>"));
            jPanel.add(new JLabel(RES.getString("file.choose")));
            jPanel.add(this.chooser);
            jPanel.add(new JLabel(RES.getString("file.title")));
            jPanel.add(textFieldWidget);
            jPanel.add(new JLabel(RES.getString("file.add", "...")));
            jPanel.add(new JScrollPane(this.to));
            this.ok = Action2.ok();
            this.to.addListSelectionListener(this);
            this.chooser.addChangeListener(this);
            if (this.to.getModel().getSize() > 0) {
                this.to.setSelectedIndex(0);
            }
            this.validate();
            if (0 != DialogHelper.openDialog(this.getTip(), 3, jPanel, (Action[])Action2.andCancel(this.ok), (Object)MediaBean.this)) {
                return;
            }
            PropertyBean.REGISTRY.put(origin.getName() + ".media", this.chooser.getDirectory());
            InputSource.FileInput fileInput = new InputSource.FileInput(textFieldWidget.getText(), this.getFile());
            if (!MediaBean.this.currentOBJEs.containsKey(fileInput) && !MediaBean.this.propsNeedingOBJEs.containsKey(fileInput)) {
                MediaBean.this.thumbs.addSource(fileInput);
            }
            Set set = (Set)MediaBean.this.propsNeedingOBJEs.get(fileInput);
            for (Object object : objectArray = this.to.getSelectedValues()) {
                set.add((Property)object);
            }
            MediaBean.this.changeSupport.fireChangeEvent();
        }

        private File getFile() {
            Origin origin = MediaBean.this.getProperty().getGedcom().getOrigin();
            return origin.getFile(this.chooser.getFile().toString());
        }

        private void validate() {
            File file = this.getFile();
            this.ok.setEnabled(this.to.getSelectedIndices().length > 0 && file != null && file.exists());
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.validate();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.validate();
        }
    }
}

