/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomListener;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Grammar;
import genj.gedcom.Indi;
import genj.gedcom.Media;
import genj.gedcom.Note;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.gedcom.TagPath;
import genj.gedcom.UnitOfWork;
import genj.util.Origin;
import genj.util.ReferenceSet;
import genj.util.Resources;
import genj.util.SafeProxy;
import genj.util.swing.ImageIcon;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gedcom {
    static final Logger LOG = Logger.getLogger("genj.gedcom");
    private static final Random seed = new Random();
    static final Resources resources = Resources.get(Gedcom.class);
    public static final String PASSWORD_UNKNOWN = "unknown";
    public static final String UNICODE = "UNICODE";
    public static final String ASCII = "ASCII";
    public static final String ANSEL = "ANSEL";
    public static final String UTF8 = "UTF-8";
    public static final String LATIN1 = "LATIN1";
    public static final String ANSI = "ANSI";
    public static final String[] ENCODINGS = new String[]{"ANSEL", "UNICODE", "ASCII", "LATIN1", "ANSI", "UTF-8"};
    public static final String[] LANGUAGES = new String[]{"Afrikaans", "Albanian", "Amharic", "Anglo-Saxon", "Arabic", "Armenian", "Assamese", "Belorusian", "Bengali", "Braj", "Bulgarian", "Burmese", "Cantonese", "Catalan", "Catalan_Spn", "Church-Slavic", "Czech", "Danish", "Dogri", "Dutch", "English", "Esperanto", "Estonian", "Faroese", "Finnish", "French", "Georgian", "German", "Greek", "Gujarati", "Hawaiian", "Hebrew", "Hindi", "Hungarian", "Icelandic", "Indonesian", "Italian", "Japanese", "Kannada", "Khmer", "Konkani", "Korean", "Lahnda", "Lao", "Latvian", "Lithuanian", "Macedonian", "Maithili", "Malayalam", "Mandrin", "Manipuri", "Marathi", "Mewari", "Navaho", "Nepali", "Norwegian", "Oriya", "Pahari", "Pali", "Panjabi", "Persian", "Polish", "Prakrit", "Pusto", "Portuguese", "Rajasthani", "Romanian", "Russian", "Sanskrit", "Serb", "Serbo_Croa", "Slovak", "Slovene", "Spanish", "Swedish", "Tagalog", "Tamil", "Telugu", "Thai", "Tibetan", "Turkish", "Ukrainian", "Urdu", "Vietnamese", "Wendic", "Yiddish"};
    public static final String INDI = "INDI";
    public static final String FAM = "FAM";
    public static final String OBJE = "OBJE";
    public static final String NOTE = "NOTE";
    public static final String SOUR = "SOUR";
    public static final String SUBM = "SUBM";
    public static final String REPO = "REPO";
    public static final String[] ENTITIES = new String[]{"INDI", "FAM", "OBJE", "NOTE", "SOUR", "SUBM", "REPO"};
    private static final Map<String, String> E2PREFIX = new HashMap<String, String>();
    private static final Map<String, Class<? extends Entity>> E2TYPE;
    private static final Map<String, ImageIcon> E2IMAGE;
    private static final ImageIcon image;
    private Submitter submitter;
    private Grammar grammar = Grammar.V551;
    private Origin origin;
    private PropertyChange lastChange = null;
    private int maxIDLength = 0;
    private LinkedList<Entity> allEntities = new LinkedList();
    private Map<String, Map<String, Entity>> tag2id2entity = new HashMap<String, Map<String, Entity>>();
    private boolean isDirty = false;
    private List<List<Undo>> undoHistory = new ArrayList<List<Undo>>();
    private List<List<Undo>> redoHistory = new ArrayList<List<Undo>>();
    private Object writeSemaphore = new Object();
    private Lock lock = null;
    private List<GedcomListener> listeners = new CopyOnWriteArrayList<GedcomListener>();
    private Map<String, ReferenceSet<String, Property>> tags2refsets = new HashMap<String, ReferenceSet<String, Property>>();
    private Map<String, Integer> propertyTag2valueCount = new HashMap<String, Integer>();
    private String encoding = "UTF-8";
    private String language = null;
    private Locale cachedLocale = null;
    private Collator cachedCollator = null;
    private String placeFormat = "";

    public Gedcom() {
        this(null);
    }

    public Gedcom(Origin origin) {
        this.origin = origin;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public void setGrammar(Grammar grammar) {
        this.grammar = grammar;
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public Submitter getSubmitter() {
        if (this.submitter == null) {
            return (Submitter)this.getFirstEntity(SUBM);
        }
        return this.submitter;
    }

    public void setSubmitter(Submitter submitter) {
        if (submitter != null && !this.getEntityMap(SUBM).containsValue(submitter)) {
            throw new IllegalArgumentException("Submitter is not part of this gedcom");
        }
        final Submitter submitter2 = this.submitter;
        this.submitter = submitter;
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                Gedcom.this.setSubmitter(submitter2);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomHeaderChanged(this);
        }
    }

    public String toString() {
        return this.getName();
    }

    public void addGedcomListener(GedcomListener gedcomListener) {
        if (gedcomListener == null) {
            throw new IllegalArgumentException("listener can't be null");
        }
        if (!this.listeners.add(SafeProxy.harden(gedcomListener))) {
            throw new IllegalArgumentException("can't add gedcom listener " + gedcomListener + "twice");
        }
        LOG.log(Level.FINER, "addGedcomListener() from " + new Throwable().getStackTrace()[1] + " (now " + this.listeners.size() + ")");
    }

    public void removeGedcomListener(GedcomListener gedcomListener) {
        this.listeners.remove(SafeProxy.harden(gedcomListener));
        LOG.log(Level.FINER, "removeGedcomListener() from " + new Throwable().getStackTrace()[1] + " (now " + this.listeners.size() + ")");
    }

    private List<Undo> getCurrentUndoSet() {
        return this.undoHistory.get(this.undoHistory.size() - 1);
    }

    protected void propagateXRefLinked(final PropertyXRef propertyXRef, PropertyXRef propertyXRef2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + propertyXRef.getTag() + " and " + propertyXRef2.getTag() + " linked");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                propertyXRef.unlink();
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyChanged(this, propertyXRef);
            gedcomListener.gedcomPropertyChanged(this, propertyXRef2);
        }
    }

    protected void propagateXRefUnlinked(final PropertyXRef propertyXRef, final PropertyXRef propertyXRef2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + propertyXRef.getTag() + " and " + propertyXRef2.getTag() + " unlinked");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                propertyXRef.link(propertyXRef2);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyChanged(this, propertyXRef);
            gedcomListener.gedcomPropertyChanged(this, propertyXRef2);
        }
    }

    protected void propagateEntityAdded(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity " + entity.getId() + " added");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                Gedcom.this.deleteEntity(entity);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomEntityAdded(this, entity);
        }
    }

    protected void propagateEntityDeleted(final Entity entity) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity " + entity.getId() + " deleted");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() throws GedcomException {
                Gedcom.this.addEntity(entity);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomEntityDeleted(this, entity);
        }
    }

    protected void propagatePropertyAdded(Entity entity, final Property property, final int n, Property property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property2.getTag() + " added to " + property.getTag() + " at position " + n + " (entity " + entity.getId() + ")");
        }
        if (!(property2 instanceof PropertyXRef)) {
            Integer n2 = this.propertyTag2valueCount.get(property2.getTag());
            this.propertyTag2valueCount.put(property2.getTag(), n2 == null ? 1 : n2 + 1);
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.delProperty(n);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyAdded(this, property, n, property2);
        }
    }

    protected void propagatePropertyDeleted(Entity entity, final Property property, final int n, final Property property2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property2.getTag() + " deleted from " + property.getTag() + " at position " + n + " (entity " + entity.getId() + ")");
        }
        if (!(property2 instanceof PropertyXRef)) {
            this.propertyTag2valueCount.put(property2.getTag(), this.propertyTag2valueCount.get(property2.getTag()) - 1);
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.addProperty(property2, n);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyDeleted(this, property, n, property2);
        }
    }

    protected void propagatePropertyChanged(Entity entity, final Property property, final String string) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property.getTag() + " changed in (entity " + entity.getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.setValue(string);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyChanged(this, property);
        }
    }

    protected void propagatePropertyMoved(final Property property, final Property property2, final int n, final int n2) {
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Property " + property.getTag() + " moved from " + n + " to " + n2 + " (entity " + property.getEntity().getId() + ")");
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() {
                property.moveProperty(property2, n < n2 ? n : n + 1);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyDeleted(this, property, n, property2);
            gedcomListener.gedcomPropertyAdded(this, property, n2, property2);
        }
    }

    protected void propagateWriteLockAqcuired() {
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomWriteLockAcquired(this);
        }
    }

    protected void propagateBeforeUnitOfWork() {
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomBeforeUnitOfWork(this);
        }
    }

    protected void propagateAfterUnitOfWork() {
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomAfterUnitOfWork(this);
        }
    }

    protected void propagateWriteLockReleased() {
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomWriteLockReleased(this);
        }
    }

    protected void propagateEntityIDChanged(final Entity entity, final String string) throws GedcomException {
        Map<String, Entity> map = this.getEntityMap(entity.getTag());
        if (!map.containsValue(entity)) {
            throw new GedcomException("Can't change ID of entity not part of this Gedcom instance");
        }
        String string2 = entity.getId();
        if (string2 == null || string2.length() == 0) {
            throw new GedcomException("Need valid ID length");
        }
        if (this.getEntity(string2) != null) {
            throw new GedcomException("Duplicate ID is not allowed");
        }
        map.remove(string);
        map.put(entity.getId(), entity);
        this.maxIDLength = Math.max(string2.length(), this.maxIDLength);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("Entity's ID changed from  " + string + " to " + entity.getId());
        }
        if (this.lock == null) {
            return;
        }
        this.lock.addChange(new Undo(){

            void undo() throws GedcomException {
                entity.setId(string);
            }
        });
        for (GedcomListener gedcomListener : this.listeners) {
            gedcomListener.gedcomPropertyChanged(this, entity);
        }
    }

    private void addEntity(Entity entity) throws GedcomException {
        String string = entity.getId();
        if (string.length() > 0) {
            Map<String, Entity> map = this.getEntityMap(entity.getTag());
            if (map.containsKey(string)) {
                throw new GedcomException(resources.getString("error.entity.dupe", string));
            }
            map.put(string, entity);
        }
        this.allEntities.add(entity);
        entity.addNotify(this);
    }

    public PropertyChange getLastChange() {
        return this.lastChange;
    }

    protected void updateLastChange(PropertyChange propertyChange) {
        if (this.lastChange == null || this.lastChange.compareTo(propertyChange) < 0) {
            this.lastChange = propertyChange;
        }
    }

    public Entity createEntity(String string) throws GedcomException {
        return this.createEntity(string, null);
    }

    public Entity createEntity(String string, String string2) throws GedcomException {
        Entity entity;
        if (string2 == null) {
            string2 = this.getNextAvailableID(string);
        }
        this.maxIDLength = Math.max(string2.length(), this.maxIDLength);
        Class<? extends Entity> clazz = E2TYPE.get(string);
        if (clazz != null) {
            if (string2.length() == 0) {
                throw new GedcomException(resources.getString("entity.error.noid", string));
            }
        } else {
            clazz = Entity.class;
        }
        try {
            entity = clazz.getDeclaredConstructor(String.class, String.class).newInstance(string, string2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Can't instantiate " + clazz, throwable);
        }
        this.addEntity(entity);
        return entity;
    }

    public void deleteEntity(Entity entity) {
        String string = entity.getId();
        if (string.length() > 0) {
            Map<String, Entity> map = this.getEntityMap(entity.getTag());
            if (!map.containsKey(string)) {
                throw new IllegalArgumentException("Unknown entity with id " + entity.getId());
            }
            map.remove(string);
        }
        entity.beforeDelNotify();
        this.allEntities.remove(entity);
        if (this.submitter == entity) {
            this.submitter = null;
        }
    }

    private Map<String, Entity> getEntityMap(String string) {
        Map<String, Entity> map = this.tag2id2entity.get(string);
        if (map == null) {
            map = new HashMap<String, Entity>();
            this.tag2id2entity.put(string, map);
        }
        return map;
    }

    public Property[] getProperties(TagPath tagPath) {
        ArrayList<Property> arrayList = new ArrayList<Property>(100);
        for (Entity entity : this.getEntities(tagPath.getFirst())) {
            Property[] propertyArray = entity.getProperties(tagPath);
            for (int i = 0; i < propertyArray.length; ++i) {
                arrayList.add(propertyArray[i]);
            }
        }
        return Property.toArray(arrayList);
    }

    public int getPropertyCount(String string) {
        Integer n = this.propertyTag2valueCount.get(string);
        return n == null ? 0 : n;
    }

    public List<Entity> getEntities() {
        return Collections.unmodifiableList(this.allEntities);
    }

    public Collection<? extends Entity> getEntities(String string) {
        return Collections.unmodifiableCollection(this.getEntityMap(string).values());
    }

    public Collection<Fam> getFamilies() {
        return this.getEntities(FAM);
    }

    public Collection<Indi> getIndis() {
        return this.getEntities(INDI);
    }

    public Entity[] getEntities(String string, String string2) {
        return this.getEntities(string, string2 != null && string2.length() > 0 ? new PropertyComparator(string2) : null);
    }

    public Entity[] getEntities(String string, Comparator<Property> comparator) {
        Collection<Entity> collection = this.getEntityMap(string).values();
        Object[] objectArray = collection.toArray(new Entity[collection.size()]);
        if (comparator != null) {
            Arrays.sort(objectArray, comparator);
        } else {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public Entity getEntity(String string) {
        for (Map<String, Entity> map : this.tag2id2entity.values()) {
            Entity entity = map.get(string);
            if (entity == null) continue;
            return entity;
        }
        return null;
    }

    public Entity getEntity(String string, String string2) {
        return this.getEntityMap(string).get(string2);
    }

    public static Class<? extends Entity> getEntityType(String string) {
        Class<? extends Entity> clazz = E2TYPE.get(string);
        if (clazz == null) {
            throw new IllegalArgumentException("no such type");
        }
        return clazz;
    }

    public Entity getFirstEntity(String string) {
        for (Entity entity : this.allEntities) {
            if (!entity.getTag().equals(string)) continue;
            return entity;
        }
        return null;
    }

    public String getNextAvailableID(String string) {
        Map<String, Entity> map = this.getEntityMap(string);
        int n = Options.getInstance().isFillGapsInIDs ? 1 : (map.isEmpty() ? 1 : map.size());
        StringBuffer stringBuffer = new StringBuffer(this.maxIDLength);
        block0: while (true) {
            stringBuffer.setLength(0);
            stringBuffer.append(Gedcom.getEntityPrefix(string));
            stringBuffer.append(n);
            while (!map.containsKey(stringBuffer.toString())) {
                if (stringBuffer.length() >= this.maxIDLength) break block0;
                stringBuffer.insert(1, '0');
            }
            ++n;
        }
        return Gedcom.getEntityPrefix(string) + n;
    }

    public boolean hasChanged() {
        return this.isDirty || !this.undoHistory.isEmpty();
    }

    public void setUnchanged() {
        if (!this.hasChanged()) {
            return;
        }
        this.undoHistory.clear();
        this.isDirty = false;
        if (this.lock == null) {
            return;
        }
        for (GedcomListener gedcomListener : this.listeners) {
            if (!(gedcomListener instanceof GedcomMetaListener)) continue;
            ((GedcomMetaListener)gedcomListener).gedcomHeaderChanged(this);
        }
    }

    public boolean isWriteLocked() {
        return this.lock != null;
    }

    public void doMuteUnitOfWork(UnitOfWork unitOfWork) {
        try {
            this.doUnitOfWork(unitOfWork);
        }
        catch (GedcomException gedcomException) {
            LOG.log(Level.WARNING, "Unexpected gedcom exception", gedcomException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUnitOfWork(UnitOfWork unitOfWork) throws GedcomException {
        PropertyChange.Monitor monitor;
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (this.lock != null) {
                throw new GedcomException("Cannot obtain write lock");
            }
            this.lock = new Lock();
            monitor = new PropertyChange.Monitor();
            this.addGedcomListener(monitor);
            this.redoHistory.clear();
        }
        this.propagateWriteLockAqcuired();
        object = null;
        try {
            unitOfWork.perform(this);
        }
        catch (Throwable throwable) {
            object = throwable;
        }
        Object object2 = this.writeSemaphore;
        synchronized (object2) {
            if (!this.lock.undos.isEmpty()) {
                this.undoHistory.add(this.lock.undos);
                while (this.undoHistory.size() > Options.getInstance().getNumberOfUndos()) {
                    this.undoHistory.remove(0);
                    this.isDirty = true;
                }
            }
            this.propagateWriteLockReleased();
            this.lock = null;
            this.removeGedcomListener(monitor);
        }
        LOG.log(Level.FINE, "End of UOW, property counts " + this.propertyTag2valueCount);
        if (object != null) {
            if (object instanceof GedcomException) {
                throw (GedcomException)object;
            }
            throw new RuntimeException((Throwable)object);
        }
    }

    public boolean canUndo() {
        return !this.undoHistory.isEmpty();
    }

    public void undoUnitOfWork() {
        this.undoUnitOfWork(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoUnitOfWork(boolean bl) {
        if (this.undoHistory.isEmpty()) {
            throw new IllegalArgumentException("undo n/a");
        }
        List<Undo> list = this.writeSemaphore;
        synchronized (list) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        list = this.undoHistory.remove(this.undoHistory.size() - 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            Undo undo = list.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", throwable);
            }
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            if (bl) {
                this.redoHistory.add(this.lock.undos);
            }
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    public boolean canRedo() {
        return !this.redoHistory.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redoUnitOfWork() {
        if (this.redoHistory.isEmpty()) {
            throw new IllegalArgumentException("redo n/a");
        }
        List<Undo> list = this.writeSemaphore;
        synchronized (list) {
            if (this.lock != null) {
                throw new IllegalStateException("Cannot obtain write lock");
            }
            this.lock = new Lock();
        }
        this.propagateWriteLockAqcuired();
        list = this.redoHistory.remove(this.redoHistory.size() - 1);
        for (int i = list.size() - 1; i >= 0; --i) {
            Undo undo = list.remove(i);
            try {
                undo.undo();
                continue;
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Unexpected throwable during undo()", throwable);
            }
        }
        Object object = this.writeSemaphore;
        synchronized (object) {
            this.undoHistory.add(this.lock.undos);
            this.propagateWriteLockReleased();
            this.lock = null;
        }
    }

    ReferenceSet<String, Property> getReferenceSet(String string) {
        ReferenceSet<String, Property> referenceSet = this.tags2refsets.get(string);
        if (referenceSet == null) {
            referenceSet = new ReferenceSet();
            this.tags2refsets.put(string, referenceSet);
        }
        return referenceSet;
    }

    public String getName() {
        return this.origin == null ? null : this.origin.getName();
    }

    public static String getName(String string) {
        return Gedcom.getName(string, false);
    }

    public static String getName(String string, boolean bl) {
        String string2;
        if (bl && (string2 = resources.getString(string + ".s.name", false)) != null) {
            return string2;
        }
        string2 = resources.getString(string + ".name", false);
        return string2 != null ? string2 : string;
    }

    public static String getEntityPrefix(String string) {
        String string2 = E2PREFIX.get(string);
        if (string2 == null) {
            string2 = "X";
        }
        return string2;
    }

    public static ImageIcon getImage() {
        return image;
    }

    public static ImageIcon getEntityImage(String string) {
        ImageIcon imageIcon = E2IMAGE.get(string);
        if (imageIcon == null) {
            imageIcon = Grammar.V55.getMeta(new TagPath(string)).getImage();
            E2IMAGE.put(string, imageIcon);
        }
        return imageIcon;
    }

    public static Resources getResources() {
        return resources;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getPlaceFormat() {
        return this.placeFormat;
    }

    public void setPlaceFormat(String string) {
        this.placeFormat = string.trim();
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String string) {
        this.language = string;
    }

    public boolean contains(Entity entity) {
        return this.getEntityMap(entity.getTag()).containsValue(entity);
    }

    public Locale getLocale() {
        if (this.cachedLocale == null) {
            if (this.language != null) {
                Locale[] localeArray = Locale.getAvailableLocales();
                for (int i = 0; i < localeArray.length; ++i) {
                    if (!localeArray[i].getDisplayLanguage(Locale.ENGLISH).equalsIgnoreCase(this.language)) continue;
                    this.cachedLocale = new Locale(localeArray[i].getLanguage(), Locale.getDefault().getCountry());
                    break;
                }
            }
            if (this.cachedLocale == null) {
                this.cachedLocale = Locale.getDefault();
            }
        }
        return this.cachedLocale;
    }

    public Collator getCollator() {
        if (this.cachedCollator == null) {
            this.cachedCollator = Collator.getInstance(this.getLocale());
            this.cachedCollator.setStrength(0);
        }
        return this.cachedCollator;
    }

    static {
        E2PREFIX.put(INDI, "I");
        E2PREFIX.put(FAM, "F");
        E2PREFIX.put(OBJE, "M");
        E2PREFIX.put(NOTE, "N");
        E2PREFIX.put(SOUR, "S");
        E2PREFIX.put(SUBM, "B");
        E2PREFIX.put(REPO, "R");
        E2TYPE = new HashMap<String, Class<? extends Entity>>();
        E2TYPE.put(INDI, Indi.class);
        E2TYPE.put(FAM, Fam.class);
        E2TYPE.put(OBJE, Media.class);
        E2TYPE.put(NOTE, Note.class);
        E2TYPE.put(SOUR, Source.class);
        E2TYPE.put(SUBM, Submitter.class);
        E2TYPE.put(REPO, Repository.class);
        E2IMAGE = new HashMap<String, ImageIcon>();
        image = new ImageIcon(Gedcom.class, "images/Gedcom");
    }

    private class Lock {
        List<Undo> undos = new ArrayList<Undo>();

        private Lock() {
        }

        void addChange(Undo undo) {
            this.undos.add(undo);
        }
    }

    private abstract class Undo {
        private Undo() {
        }

        abstract void undo() throws GedcomException;
    }
}

