/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.PropertyDate;
import genj.gedcom.PropertyEvent;
import genj.gedcom.PropertyFamilyChild;
import genj.gedcom.PropertyFamilySpouse;
import genj.gedcom.PropertyMultilineValue;
import genj.gedcom.PropertyName;
import genj.gedcom.PropertySex;
import genj.gedcom.TagPath;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Indi
extends Entity {
    private static final TagPath PATH_INDI = new TagPath("INDI");
    private static final TagPath PATH_INDIFAMS = new TagPath("INDI:FAMS");
    private static final TagPath PATH_INDIFAMC = new TagPath("INDI:FAMC");
    private static final TagPath PATH_INDIBIRTDATE = new TagPath("INDI:BIRT:DATE");
    private static final TagPath PATH_INDIDEATDATE = new TagPath("INDI:DEAT:DATE");
    private static final TagPath PATH_INDIDEAT = new TagPath("INDI:DEAT");
    public static final ImageIcon IMG_MALE = Grammar.V55.getMeta(PATH_INDI).getImage("male");
    public static final ImageIcon IMG_FEMALE = Grammar.V55.getMeta(PATH_INDI).getImage("female");
    public static final ImageIcon IMG_UNKNOWN = Grammar.V55.getMeta(PATH_INDI).getImage();

    public Indi() {
        super("INDI", "?");
    }

    public Indi(String string, String string2) {
        super(string, string2);
        this.assertTag("INDI");
    }

    public PropertyDate getBirthDate() {
        return this.getBirthDate(false);
    }

    public PropertyDate getBirthDate(boolean bl) {
        PropertyDate propertyDate = (PropertyDate)this.getProperty(PATH_INDIBIRTDATE);
        if (null != propertyDate || !bl) {
            return propertyDate;
        }
        return (PropertyDate)this.setValue(PATH_INDIBIRTDATE, "");
    }

    public PropertyDate getDeathDate() {
        return this.getDeathDate(false);
    }

    public PropertyDate getDeathDate(boolean bl) {
        PropertyDate propertyDate = (PropertyDate)this.getProperty(PATH_INDIDEATDATE);
        if (null != propertyDate || !bl) {
            return propertyDate;
        }
        return (PropertyDate)this.setValue(PATH_INDIDEATDATE, "");
    }

    public Indi[] getSiblings(boolean bl) {
        Fam fam = this.getFamilyWhereBiologicalChild();
        if (fam == null) {
            return new Indi[0];
        }
        ArrayList<Indi> arrayList = new ArrayList<Indi>(fam.getNoOfChildren());
        Indi[] indiArray = fam.getChildren();
        for (int i = 0; i < indiArray.length; ++i) {
            if (!bl && indiArray[i] == this) continue;
            arrayList.add(indiArray[i]);
        }
        return Indi.toIndiArray(arrayList);
    }

    public Indi[] getYoungerSiblings() {
        Indi[] indiArray = this.getSiblings(true);
        Arrays.sort(indiArray, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> arrayList = new ArrayList<Indi>(indiArray.length);
        for (int i = indiArray.length - 1; i >= 0 && indiArray[i] != this; --i) {
            arrayList.add(0, indiArray[i]);
        }
        return Indi.toIndiArray(arrayList);
    }

    public PropertyMultilineValue getAddress() {
        Property[] propertyArray = this.getProperties("RESI");
        for (int i = 0; i < propertyArray.length; ++i) {
            PropertyDate propertyDate;
            PropertyMultilineValue propertyMultilineValue = (PropertyMultilineValue)propertyArray[i].getProperty("ADDR");
            if (propertyMultilineValue == null || (propertyDate = (PropertyDate)propertyArray[i].getProperty("DATE")) != null && propertyDate.isRange()) continue;
            return propertyMultilineValue;
        }
        return null;
    }

    public Indi[] getOlderSiblings() {
        Indi[] indiArray = this.getSiblings(true);
        Arrays.sort(indiArray, new PropertyComparator("INDI:BIRT:DATE"));
        ArrayList<Indi> arrayList = new ArrayList<Indi>(indiArray.length);
        int n = indiArray.length;
        for (int i = 0; i < n && indiArray[i] != this; ++i) {
            arrayList.add(indiArray[i]);
        }
        return Indi.toIndiArray(arrayList);
    }

    public Indi[] getPartners() {
        Fam[] famArray = this.getFamiliesWhereSpouse();
        ArrayList<Indi> arrayList = new ArrayList<Indi>(famArray.length);
        for (int i = 0; i < famArray.length; ++i) {
            Indi indi = famArray[i].getOtherSpouse(this);
            if (indi == null) continue;
            arrayList.add(indi);
        }
        Indi[] indiArray = new Indi[arrayList.size()];
        arrayList.toArray(indiArray);
        return indiArray;
    }

    public List<Indi> getParents() {
        ArrayList<Indi> arrayList = new ArrayList<Indi>(2);
        for (Fam fam : this.getFamiliesWhereChild()) {
            Indi indi;
            Indi indi2 = fam.getHusband();
            if (indi2 != null) {
                arrayList.add(indi2);
            }
            if ((indi = fam.getWife()) == null) continue;
            arrayList.add(indi);
        }
        return arrayList;
    }

    public Indi[] getChildren() {
        Fam[] famArray = this.getFamiliesWhereSpouse();
        ArrayList<Indi> arrayList = new ArrayList<Indi>(famArray.length);
        for (int i = 0; i < famArray.length; ++i) {
            Indi[] indiArray = famArray[i].getChildren();
            for (int j = 0; j < indiArray.length; ++j) {
                if (arrayList.contains(indiArray[j])) continue;
                arrayList.add(indiArray[j]);
            }
        }
        Indi[] indiArray = new Indi[arrayList.size()];
        arrayList.toArray(indiArray);
        return indiArray;
    }

    public String getBirthAsString() {
        PropertyDate propertyDate = this.getBirthDate();
        if (propertyDate == null) {
            return "";
        }
        return propertyDate.getDisplayValue();
    }

    public String getDeathAsString() {
        PropertyDate propertyDate = this.getDeathDate();
        if (propertyDate == null) {
            return "";
        }
        return propertyDate.getDisplayValue();
    }

    public Fam[] getFamiliesWhereSpouse() {
        ArrayList<Fam> arrayList = new ArrayList<Fam>(this.getNoOfProperties());
        int n = this.getNoOfProperties();
        for (int i = 0; i < n; ++i) {
            Property property = this.getProperty(i);
            if (!"FAMS".equals(property.getTag()) || !property.isValid()) continue;
            arrayList.add(((PropertyFamilySpouse)property).getFamily());
        }
        return Fam.toFamArray(arrayList);
    }

    public Fam[] getFamiliesWhereChild() {
        List<PropertyFamilyChild> list = this.getProperties(PropertyFamilyChild.class);
        ArrayList<Fam> arrayList = new ArrayList<Fam>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            PropertyFamilyChild propertyFamilyChild = list.get(i);
            if (!propertyFamilyChild.isValid() || arrayList.contains(propertyFamilyChild)) continue;
            arrayList.add((Fam)propertyFamilyChild.getTargetEntity());
        }
        return Fam.toFamArray(arrayList);
    }

    public Fam getFamilyWhereBiologicalChild() {
        Fam fam = null;
        List<PropertyFamilyChild> list = this.getProperties(PropertyFamilyChild.class);
        for (int i = 0; i < list.size(); ++i) {
            PropertyFamilyChild propertyFamilyChild = list.get(i);
            if (!propertyFamilyChild.isValid()) continue;
            Boolean bl = propertyFamilyChild.isBiological();
            if (Boolean.TRUE.equals(bl)) {
                return (Fam)propertyFamilyChild.getTargetEntity();
            }
            if (bl != null || fam != null) continue;
            fam = (Fam)propertyFamilyChild.getTargetEntity();
        }
        return fam;
    }

    public String getFirstName() {
        PropertyName propertyName = (PropertyName)this.getProperty("NAME", true);
        return propertyName != null ? propertyName.getFirstName() : "";
    }

    public String getLastName() {
        PropertyName propertyName = (PropertyName)this.getProperty("NAME", true);
        return propertyName != null ? propertyName.getLastName() : "";
    }

    public String getNameSuffix() {
        PropertyName propertyName = (PropertyName)this.getProperty("NAME", true);
        return propertyName != null ? propertyName.getSuffix() : "";
    }

    public void setName(String string, String string2) {
        PropertyName propertyName = (PropertyName)this.getProperty("NAME", true);
        if (propertyName == null) {
            propertyName = (PropertyName)this.addProperty(new PropertyName());
        }
        propertyName.setName(string, string2);
    }

    public String getName() {
        PropertyName propertyName = (PropertyName)this.getProperty("NAME", true);
        if (propertyName == null) {
            return "";
        }
        return propertyName.getDisplayValue();
    }

    public int getNoOfFams() {
        int n = 0;
        int n2 = this.getNoOfProperties();
        for (int i = 0; i < n2; ++i) {
            Property property = this.getProperty(i);
            if (!"FAMS".equals(property.getTag()) || !property.isValid()) continue;
            ++n;
        }
        return n;
    }

    public int getSex() {
        PropertySex propertySex = (PropertySex)this.getProperty("SEX", true);
        return propertySex != null ? propertySex.getSex() : 0;
    }

    public void setSex(int n) {
        PropertySex propertySex = (PropertySex)this.getProperty("SEX", false);
        if (propertySex != null && !propertySex.isValid()) {
            return;
        }
        if (propertySex == null) {
            propertySex = (PropertySex)this.addProperty(new PropertySex());
        }
        propertySex.setSex(n);
    }

    public boolean isSiblingOf(Indi indi) {
        Fam fam = this.getFamilyWhereBiologicalChild();
        if (fam != null) {
            for (Indi indi2 : fam.getChildren(false)) {
                if (indi2 != indi) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isDescendantOf(Indi indi) {
        return indi.isAncestorOf(this);
    }

    public boolean isAncestorOf(Indi indi) {
        return this.recursiveIsAncestorOf(indi, new HashSet<Indi>());
    }

    private boolean recursiveIsAncestorOf(Indi indi, Set<Indi> set) {
        if (set.contains(indi)) {
            return false;
        }
        set.add(indi);
        List<PropertyFamilyChild> list = indi.getProperties(PropertyFamilyChild.class);
        for (int i = 0; i < list.size(); ++i) {
            Indi indi2;
            PropertyFamilyChild propertyFamilyChild = list.get(i);
            if (!propertyFamilyChild.isValid() || Boolean.FALSE.equals(propertyFamilyChild.isBiological())) continue;
            Fam fam = propertyFamilyChild.getFamily();
            Indi indi3 = fam.getHusband();
            if (indi3 != null) {
                if (indi3 == this) {
                    return true;
                }
                if (this.recursiveIsAncestorOf(indi3, set)) {
                    return true;
                }
            }
            if ((indi2 = fam.getWife()) == null) continue;
            if (indi2 == this) {
                return true;
            }
            if (!this.recursiveIsAncestorOf(indi2, set)) continue;
            return true;
        }
        return false;
    }

    public boolean isDescendantOf(Fam fam) {
        Indi[] indiArray = fam.getChildren(false);
        for (int i = 0; i < indiArray.length; ++i) {
            Indi indi = indiArray[i];
            if (indi == this) {
                return true;
            }
            if (!indi.isAncestorOf(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isAncestorOf(Fam fam) {
        Indi indi;
        Indi indi2 = fam.getHusband();
        if (indi2 != null) {
            if (indi2 == this) {
                return true;
            }
            if (this.isAncestorOf(indi2)) {
                return true;
            }
        }
        if ((indi = fam.getWife()) != null) {
            if (indi == this) {
                return true;
            }
            if (this.isAncestorOf(indi)) {
                return true;
            }
        }
        return false;
    }

    @Override
    protected String getToStringPrefix(boolean bl) {
        return this.getName();
    }

    static Indi[] toIndiArray(Collection<Indi> collection) {
        return collection.toArray(new Indi[collection.size()]);
    }

    @Override
    public ImageIcon getImage(boolean bl) {
        switch (this.getSex()) {
            case 1: {
                return IMG_MALE;
            }
            case 2: {
                return IMG_FEMALE;
            }
        }
        return IMG_UNKNOWN;
    }

    public String getAgeString(PointInTime pointInTime) {
        Delta delta = this.getAge(pointInTime);
        return delta != null ? delta.toString() : "";
    }

    public Delta getAge(PointInTime pointInTime) {
        PropertyDate propertyDate = this.getBirthDate();
        if (propertyDate == null) {
            return null;
        }
        PointInTime pointInTime2 = propertyDate.getStart();
        if (pointInTime2.compareTo(pointInTime) > 0) {
            return null;
        }
        Delta delta = Delta.get(propertyDate.getStart(), pointInTime);
        if (delta == null) {
            return null;
        }
        return delta;
    }

    public Indi getBiologicalFather() {
        Fam fam = this.getFamilyWhereBiologicalChild();
        return fam != null ? fam.getHusband() : null;
    }

    public Indi getBiologicalMother() {
        Fam fam = this.getFamilyWhereBiologicalChild();
        return fam != null ? fam.getWife() : null;
    }

    public boolean isDeceased() {
        Delta delta;
        Property property;
        PropertyEvent propertyEvent = (PropertyEvent)this.getProperty("DEAT");
        if (propertyEvent != null) {
            if (propertyEvent.isKnownToHaveHappened().booleanValue()) {
                return true;
            }
            property = propertyEvent.getProperty("DATE");
            if (property != null && property.isValid()) {
                return true;
            }
        }
        return (property = this.getBirthDate()) != null && (delta = ((PropertyDate)property).getAnniversary()) != null && delta.getYears() > 100;
    }
}

