/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyForeignXRef;
import genj.gedcom.PropertyRelationship;
import genj.gedcom.PropertySimpleValue;
import genj.gedcom.PropertyXRef;
import genj.util.WordBuffer;

public class PropertyAssociation
extends PropertyXRef {
    PropertyAssociation(String string) {
        super(string);
        this.assertTag("ASSO");
    }

    public String getDisplayValue() {
        Property property;
        PropertyXRef propertyXRef = this.getTarget();
        if (propertyXRef == null) {
            return super.getDisplayValue();
        }
        Property property2 = propertyXRef.getParent();
        if (property2 == null) {
            return super.getDisplayValue();
        }
        WordBuffer wordBuffer = new WordBuffer(" - ");
        wordBuffer.append(property2.getEntity());
        wordBuffer.append(Gedcom.getName(property2.getTag()));
        Property property3 = property2.getProperty("DATE");
        if (property3 != null) {
            wordBuffer.append(property3);
        }
        if ((property = property2.getProperty("PLAC")) != null) {
            wordBuffer.append(property);
        }
        return wordBuffer.toString();
    }

    protected String getForeignDisplayValue() {
        Property property = this.getProperty("RELA");
        if (property != null && property.getDisplayValue().length() > 0) {
            return property.getDisplayValue() + ": " + this.getEntity().toString();
        }
        return super.getForeignDisplayValue();
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.asso.veto");
    }

    public void link() throws GedcomException {
        Property property;
        Entity entity = this.getCandidate();
        PropertyForeignXRef propertyForeignXRef = new PropertyForeignXRef();
        try {
            property = (PropertyRelationship)this.getProperty("RELA");
            entity.getProperty(((PropertyRelationship)property).getAnchor()).addProperty(propertyForeignXRef);
        }
        catch (Throwable throwable) {
            entity.addProperty(propertyForeignXRef);
        }
        this.link(propertyForeignXRef);
        property = this.getProperty("TYPE");
        if (property == null) {
            property = this.addProperty(new PropertySimpleValue("TYPE"));
        }
        property.setValue(entity.getTag());
    }

    public String getTargetType() {
        if (!this.getMetaProperty().allows("TYPE")) {
            return "INDI";
        }
        Property property = this.getProperty("TYPE");
        if (property != null) {
            return property.getValue();
        }
        String string = this.getValue().substring(1, 2);
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            if (!Gedcom.getEntityPrefix(Gedcom.ENTITIES[i]).startsWith(string)) continue;
            return Gedcom.ENTITIES[i];
        }
        return "INDI";
    }
}

