/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertySimpleValue;
import genj.util.ReferenceSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyChoiceValue
extends PropertySimpleValue {
    public PropertyChoiceValue(String string) {
        super(string);
    }

    protected boolean remember(String string, String string2) {
        Gedcom gedcom = this.getGedcom();
        if (this.isTransient || gedcom == null) {
            return false;
        }
        ReferenceSet<String, Property> referenceSet = gedcom.getReferenceSet(this.getTag());
        string2 = string2.intern();
        if (string.length() > 0) {
            referenceSet.remove(string, this);
        }
        if (string2.length() > 0) {
            referenceSet.add(string2, this);
        }
        return true;
    }

    public List<String> getChoices(boolean bl) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return Collections.EMPTY_LIST;
        }
        return PropertyChoiceValue.getChoices(gedcom, this.getTag(), bl);
    }

    public List<String> getDefaults() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string = Gedcom.resources.getString(this.getTag() + ".vals", false);
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextToken().trim());
            }
        }
        return arrayList;
    }

    public static List<String> getChoices(Gedcom gedcom, String string, boolean bl) {
        return new ArrayList<String>(gedcom.getReferenceSet(string).getKeys(bl ? gedcom.getCollator() : null));
    }

    public static Property[] getSameChoices(Gedcom gedcom, String string, boolean bl) {
        ReferenceSet<String, Property> referenceSet = gedcom.getReferenceSet(string);
        List<String> list = referenceSet.getKeys(bl ? gedcom.getCollator() : null);
        ArrayList<Property> arrayList = new ArrayList<Property>(list.size());
        for (String string2 : list) {
            arrayList.addAll(referenceSet.getReferences(string2));
        }
        return Property.toArray(arrayList);
    }

    public Property[] getSameChoices() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new Property[0];
        }
        ReferenceSet<String, Property> referenceSet = gedcom.getReferenceSet(this.getTag());
        return PropertyChoiceValue.toArray(referenceSet.getReferences(super.getValue()));
    }

    @Override
    public void setValue(String string) {
        this.setValueInternal(string.intern());
    }

    public void setValue(String string, boolean bl) {
        if (bl) {
            Property[] propertyArray = this.getSameChoices();
            for (int i = 0; i < propertyArray.length; ++i) {
                Property property = propertyArray[i];
                if (!(property instanceof PropertyChoiceValue) || property == this) continue;
                ((PropertyChoiceValue)property).setValue(string);
            }
        }
        this.setValue(string);
    }

    private void setValueInternal(String string) {
        this.remember(super.getValue(), string);
        super.setValue(string);
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.remember("", super.getValue());
    }

    @Override
    void beforeDelNotify() {
        this.remember(super.getValue(), "");
        super.beforeDelNotify();
    }
}

