/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.Delta;
import genj.gedcom.time.PointInTime;
import genj.util.DirectAccessTokenizer;
import genj.util.WordBuffer;

public class PropertyDate
extends Property {
    private PIT start = new PIT();
    private PIT end = new PIT();
    private boolean isAdjusting = false;
    private String valueAsString = null;
    private Format format = DATE;
    private String phrase = "";
    public static final Format DATE = new Format("", "");
    public static final Format FROM_TO = new Format("FROM", "TO");
    public static final Format FROM = new Format("FROM", "");
    public static final Format TO = new Format("TO", "");
    public static final Format BETWEEN_AND = new Format("BET", "AND");
    public static final Format BEFORE = new Format("BEF", "");
    public static final Format AFTER = new Format("AFT", "");
    public static final Format ABOUT = new Format("ABT", "");
    public static final Format CALCULATED = new Format("CAL", "");
    public static final Format ESTIMATED = new Format("EST", "");
    public static final Format INTERPRETED = new Interpreted();
    public static final Format[] FORMATS = new Format[]{DATE, FROM_TO, FROM, TO, BETWEEN_AND, BEFORE, AFTER, ABOUT, CALCULATED, ESTIMATED, INTERPRETED};

    public PropertyDate(String string) {
        super(string);
    }

    public PropertyDate() {
        super("DATE");
    }

    public PropertyDate(int n) {
        super("DATE");
        this.getStart().set(Integer.MAX_VALUE, Integer.MAX_VALUE, n);
    }

    public int compareTo(Property property) {
        return this.start.compareTo(((PropertyDate)property).start);
    }

    public String getPhrase() {
        return this.phrase;
    }

    public PointInTime getStart() {
        return this.start;
    }

    public PointInTime getEnd() {
        return this.end;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getValue() {
        return this.valueAsString != null ? this.valueAsString : this.format.getValue(this);
    }

    public boolean isRange() {
        return this.format.isRange();
    }

    public boolean isValid() {
        return this.valueAsString == null && this.format.isValid(this);
    }

    public boolean isComparable() {
        return this.start.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Format format, PointInTime pointInTime, PointInTime pointInTime2, String string) {
        String string2 = this.getValue();
        this.isAdjusting = true;
        try {
            if (pointInTime == null) {
                this.start.reset();
            } else {
                this.start.set(pointInTime);
            }
            if (pointInTime2 == null) {
                this.end.reset();
            } else {
                this.end.set(pointInTime2);
            }
            this.phrase = string;
            this.valueAsString = null;
            this.format = format.needsValidStart() && !this.start.isValid() || format.needsValidEnd() && !this.end.isValid() ? DATE : format;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFormat(Format format) {
        String string = this.getValue();
        this.isAdjusting = true;
        try {
            if (!this.isRange() && format.isRange()) {
                this.end.set(this.start);
            }
            this.format = format;
        }
        finally {
            this.isAdjusting = false;
        }
        this.propagatePropertyChanged(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(String string) {
        String string2;
        block5: {
            string2 = this.getParent() == null ? null : this.getValue();
            this.isAdjusting = true;
            try {
                this.start.reset();
                this.end.reset();
                this.format = DATE;
                this.phrase = "";
                this.valueAsString = string.trim();
                if (this.valueAsString.length() <= 0) break block5;
                for (int i = 0; i < FORMATS.length; ++i) {
                    if (!FORMATS[i].setValue(string, this)) continue;
                    this.format = FORMATS[i];
                    this.valueAsString = null;
                    break;
                }
            }
            finally {
                this.isAdjusting = false;
            }
        }
        if (string2 != null) {
            this.propagatePropertyChanged(this, string2);
        }
    }

    public String getDisplayValue() {
        return this.getDisplayValue(null);
    }

    public String getDisplayValue(Calendar calendar) {
        if (this.valueAsString != null) {
            return this.valueAsString;
        }
        return this.format.getDisplayValue(this, calendar);
    }

    public String getPropertyInfo() {
        WordBuffer wordBuffer = new WordBuffer();
        wordBuffer.append(super.getPropertyInfo());
        wordBuffer.append("<br>");
        wordBuffer.append(this.getDisplayValue());
        if (!this.getStart().isGregorian() || !this.getEnd().isGregorian()) {
            wordBuffer.append("<br>");
            wordBuffer.append(this.getDisplayValue(PointInTime.GREGORIAN));
            wordBuffer.append("(" + PointInTime.GREGORIAN.getName() + ")");
        }
        return wordBuffer.toString();
    }

    public Delta getAnniversary() {
        return this.getAnniversary(PointInTime.getNow());
    }

    public Delta getAnniversary(PointInTime pointInTime) {
        PointInTime pointInTime2;
        if (!this.isValid()) {
            return null;
        }
        PointInTime pointInTime3 = pointInTime2 = this.isRange() ? this.getEnd() : this.getStart();
        if (pointInTime.compareTo(pointInTime2) < 0) {
            return null;
        }
        return Delta.get(pointInTime2, pointInTime);
    }

    private static class Interpreted
    extends Format {
        private Interpreted() {
            super("INT", "");
        }

        public boolean usesPhrase() {
            return true;
        }

        public boolean isRange() {
            return false;
        }

        protected boolean needsValidStart() {
            return false;
        }

        protected boolean needsValidEnd() {
            return false;
        }

        protected boolean isValid(PropertyDate propertyDate) {
            return true;
        }

        protected boolean setValue(String string, PropertyDate propertyDate) {
            if (string.length() > this.start.length() && string.substring(0, this.start.length()).equalsIgnoreCase(this.start)) {
                int n = string.indexOf(40);
                if (n > 0 && propertyDate.start.set(string.substring(this.start.length(), n))) {
                    propertyDate.phrase = string.substring(n + 1, string.endsWith(")") ? string.length() - 1 : string.length());
                    return true;
                }
                if (propertyDate.start.set(string.substring(this.start.length()))) {
                    propertyDate.phrase = "";
                    return true;
                }
            }
            if (!string.startsWith("(") || !string.endsWith(")")) {
                return false;
            }
            propertyDate.phrase = string.substring(1, string.length() - 1).trim();
            return true;
        }

        protected String getDisplayValue(PropertyDate propertyDate, Calendar calendar) {
            try {
                WordBuffer wordBuffer = new WordBuffer();
                if (propertyDate.start.isValid()) {
                    if (calendar == null || propertyDate.start.getCalendar() == calendar) {
                        propertyDate.start.toString(wordBuffer);
                    } else {
                        propertyDate.start.getPointInTime(calendar).toString(wordBuffer);
                    }
                }
                wordBuffer.append("(" + propertyDate.phrase + ")");
                return wordBuffer.toString();
            }
            catch (GedcomException gedcomException) {
                return "";
            }
        }

        protected String getValue(PropertyDate propertyDate) {
            WordBuffer wordBuffer = new WordBuffer();
            if (propertyDate.start.isValid()) {
                wordBuffer.append(this.start);
                propertyDate.start.getValue(wordBuffer);
            }
            wordBuffer.append("(" + propertyDate.phrase + ")");
            return wordBuffer.toString();
        }
    }

    public static class Format {
        protected String start;
        protected String end;

        private Format(String string, String string2) {
            this.start = string;
            this.end = string2;
        }

        public String toString() {
            return this.start + this.end;
        }

        public boolean usesPhrase() {
            return false;
        }

        public boolean isRange() {
            return this.end.length() > 0;
        }

        protected boolean needsValidStart() {
            return true;
        }

        protected boolean needsValidEnd() {
            return this.isRange();
        }

        public String getName() {
            String string = (this.start + this.end).toLowerCase();
            if (string.length() == 0) {
                string = "date";
            }
            return Property.resources.getString("prop.date." + string);
        }

        public String getPrefix1Name() {
            return Property.resources.getString("prop.date.mod." + this.start, false);
        }

        public String getPrefix2Name() {
            return Property.resources.getString("prop.date.mod." + this.end, false);
        }

        protected boolean isValid(PropertyDate propertyDate) {
            return propertyDate.start.isValid() && (!this.isRange() || propertyDate.end.isValid());
        }

        protected String getValue(PropertyDate propertyDate) {
            WordBuffer wordBuffer = new WordBuffer();
            wordBuffer.append(this.start);
            propertyDate.start.getValue(wordBuffer);
            if (this.isRange()) {
                wordBuffer.append(this.end);
                propertyDate.end.getValue(wordBuffer);
            }
            return wordBuffer.toString();
        }

        protected String getDisplayValue(PropertyDate propertyDate, Calendar calendar) {
            try {
                WordBuffer wordBuffer = new WordBuffer();
                if (this.start.length() > 0) {
                    wordBuffer.append(Gedcom.getResources().getString("prop.date.mod." + this.start));
                }
                if (calendar == null || propertyDate.start.getCalendar() == calendar) {
                    propertyDate.start.toString(wordBuffer);
                } else {
                    propertyDate.start.getPointInTime(calendar).toString(wordBuffer);
                }
                if (this.isRange()) {
                    wordBuffer.append(Gedcom.getResources().getString("prop.date.mod." + this.end));
                    if (calendar == null || propertyDate.end.getCalendar() == calendar) {
                        propertyDate.end.toString(wordBuffer);
                    } else {
                        propertyDate.end.getPointInTime(calendar).toString(wordBuffer);
                    }
                }
                return wordBuffer.toString();
            }
            catch (GedcomException gedcomException) {
                return "";
            }
        }

        protected boolean setValue(String string, PropertyDate propertyDate) {
            String string2;
            DirectAccessTokenizer directAccessTokenizer = new DirectAccessTokenizer(string, " ", true);
            int n = 0;
            if (this.start.length() > 0) {
                String string3 = directAccessTokenizer.get(0);
                n = directAccessTokenizer.getEnd();
                if (!string3.equalsIgnoreCase(this.start)) {
                    return false;
                }
            }
            if (!this.isRange()) {
                return propertyDate.start.set(string.substring(n));
            }
            int n2 = 1;
            while ((string2 = directAccessTokenizer.get(n2)) != null) {
                if (string2.equalsIgnoreCase(this.end)) {
                    return propertyDate.start.set(string.substring(n, directAccessTokenizer.getStart())) && propertyDate.end.set(string.substring(directAccessTokenizer.getEnd()));
                }
                ++n2;
            }
            return false;
        }
    }

    private final class PIT
    extends PointInTime {
        private PIT() {
        }

        public void set(int n, int n2, int n3) {
            if (PropertyDate.this.isAdjusting) {
                super.set(n, n2, n3);
            } else {
                String string = super.getValue();
                super.set(n, n2, n3);
                PropertyDate.this.propagatePropertyChanged(PropertyDate.this, string);
            }
        }
    }
}

