/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Fam;
import genj.gedcom.GedcomException;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyHusband;
import genj.gedcom.PropertyWife;
import genj.gedcom.PropertyXRef;

public class PropertyFamilySpouse
extends PropertyXRef {
    PropertyFamilySpouse() {
        super("FAMS");
    }

    PropertyFamilySpouse(String string) {
        super(string);
        this.assertTag("FAMS");
    }

    public String getDeleteVeto() {
        if (this.getTargetEntity() == null) {
            return null;
        }
        return resources.getString("prop.fams.veto");
    }

    public Fam getFamily() {
        return (Fam)this.getTargetEntity();
    }

    public void link() throws GedcomException {
        Indi indi;
        try {
            indi = (Indi)this.getEntity();
        }
        catch (ClassCastException classCastException) {
            throw new GedcomException(resources.getString("error.noenclosingindi"));
        }
        Fam fam = (Fam)this.getCandidate();
        Indi indi2 = fam.getHusband();
        Indi indi3 = fam.getWife();
        if (indi2 != null && indi3 != null) {
            throw new GedcomException(resources.getString("error.already.spouses", fam));
        }
        if (indi2 == indi || indi3 == indi) {
            throw new GedcomException(resources.getString("error.already.spouse", indi.toString(), fam.toString()));
        }
        Fam[] famArray = indi.getFamiliesWhereChild();
        for (int i = 0; i < famArray.length; ++i) {
            if (famArray[i] != fam) continue;
            throw new GedcomException(resources.getString("error.already.child", indi.toString(), fam.toString()));
        }
        if (indi.isDescendantOf(fam)) {
            throw new GedcomException(resources.getString("error.already.descendant", indi.toString(), fam.toString()));
        }
        if (indi.getSex() == 0) {
            indi.setSex(indi2 == null ? 1 : 2);
        }
        Property[] propertyArray = fam.getProperties("HUSB", false);
        for (int i = 0; i < propertyArray.length; ++i) {
            PropertyHusband propertyHusband = (PropertyHusband)propertyArray[i];
            if (!propertyHusband.isCandidate(indi)) continue;
            this.link(propertyHusband);
            return;
        }
        Property[] propertyArray2 = fam.getProperties("WIFE", false);
        for (int i = 0; i < propertyArray2.length; ++i) {
            PropertyWife propertyWife = (PropertyWife)propertyArray2[i];
            if (!propertyWife.isCandidate(indi)) continue;
            this.link(propertyWife);
            return;
        }
        if (indi.getSex() == 1) {
            if (indi2 != null && indi2.getSex() != 1) {
                fam.swapSpouses();
            }
            PropertyHusband propertyHusband = new PropertyHusband();
            fam.addProperty(propertyHusband);
            this.link(propertyHusband);
        } else {
            if (indi3 != null) {
                fam.swapSpouses();
            }
            PropertyWife propertyWife = new PropertyWife();
            fam.addProperty(propertyWife);
            this.link(propertyWife);
        }
    }

    public String getTargetType() {
        return "FAM";
    }
}

