/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.util.swing.ImageIcon;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class PropertyFile
extends Property {
    public static final ImageIcon DEFAULT_IMAGE = Grammar.V55.getMeta(new TagPath("INDI:OBJE:FILE")).getImage();
    private String file;
    private boolean isRelativeChecked = false;

    public PropertyFile(String string) {
        super(string);
    }

    public boolean addFile(File file) {
        this.setValue(file.getAbsolutePath(), true);
        return true;
    }

    public String getValue() {
        Gedcom gedcom;
        if (this.file == null) {
            return "";
        }
        if (!this.isRelativeChecked && (gedcom = this.getGedcom()) != null) {
            String string = gedcom.getOrigin().calcRelativeLocation(this.file);
            if (string != null) {
                this.file = string;
            }
            this.isRelativeChecked = true;
        }
        return this.file;
    }

    public synchronized void setValue(String string) {
        String string2 = this.getValue();
        this.file = string.replace('\\', '/');
        this.isRelativeChecked = false;
        this.propagatePropertyChanged(this, string2);
    }

    public void setValue(String string, boolean bl) {
        Property property;
        this.setValue(string);
        Property property2 = this.getParent();
        if (!bl || !property2.getTag().equals("OBJE")) {
            return;
        }
        Property property3 = this;
        if (!this.getMetaProperty().allows("FORM")) {
            if (!property2.getMetaProperty().allows("FORM")) {
                return;
            }
            property3 = property2;
        }
        if ((property = property3.getProperty("FORM")) == null) {
            property3.addProperty("FORM", PropertyFile.getSuffix(this.file));
        } else {
            property.setValue(PropertyFile.getSuffix(this.file));
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.getGedcom().getOrigin().open(this.file);
    }

    public File getFile() {
        Gedcom gedcom = this.getGedcom();
        return gedcom != null ? gedcom.getOrigin().getFile(this.file) : null;
    }

    public static int getMaxValueAsIconSize(boolean bl) {
        return (bl ? 1 : 1024) * Options.getInstance().getMaxImageFileSizeKB();
    }

    public String getSuffix() {
        return PropertyFile.getSuffix(this.file);
    }

    public static String getSuffix(String string) {
        int n;
        String string2 = "";
        if (string != null && (n = string.lastIndexOf(46)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }
}

