/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.Submitter;
import genj.util.ReferenceSet;
import genj.util.WordBuffer;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyName
extends Property {
    public static final int PREFIX_AS_IS = 0;
    public static final int PREFIX_LAST = 1;
    public static final int IGNORE_PREFIX = 2;
    private static final String KEY_LASTNAME = "NAME.last";
    private static final String KEY_FIRSTNAME = "NAME.first";
    private String lastName = "";
    private String firstName = "";
    private String suffix = "";
    private String nameAsString;

    PropertyName(String string) {
        super(string);
    }

    public PropertyName() {
        super("NAME");
    }

    public PropertyName(String string, String string2) {
        this();
        this.setName(string, string2);
    }

    @Override
    public int compareTo(Property property) {
        int n = this.compare(this.getLastName(), ((PropertyName)property).getLastName());
        if (n != 0) {
            return n;
        }
        return this.compare(this.getFirstName(), ((PropertyName)property).getFirstName());
    }

    public String getFirstName() {
        return this.firstName;
    }

    @Override
    public boolean isValid() {
        if (!(this.getEntity() instanceof Indi) && !(this.getEntity() instanceof Submitter)) {
            return true;
        }
        return this.nameAsString == null;
    }

    public static String getLabelForFirstName() {
        return Gedcom.getResources().getString("prop.name.firstname");
    }

    public static String getLabelForLastName() {
        return Gedcom.getResources().getString("prop.name.lastname");
    }

    public static String getLabelForSuffix() {
        return Gedcom.getResources().getString("prop.name.suffix");
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastName(int n) {
        if (n == 0) {
            return this.lastName;
        }
        String string = this.lastName.replaceFirst("^[a-z ]*", "");
        string = string.replaceFirst("-", "");
        if (n == 2) {
            string = string.replaceFirst("Hengevel[dt]", "Hengeveld/t");
            return string;
        }
        int n2 = this.lastName.length() - string.length();
        if (n2 > 0) {
            string = string + ", " + this.lastName.subSequence(0, n2);
        }
        return string;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public String getNick() {
        return this.getPropertyValue("NICK");
    }

    public void setNick(String string) {
        Property property = this.getProperty("NICK");
        if (property == null) {
            if (string.length() == 0) {
                return;
            }
            property = this.addProperty("NICK", string);
        } else {
            property.setValue(string);
        }
    }

    public String getName() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        if (this.firstName.length() == 0) {
            return this.lastName;
        }
        return this.lastName + ", " + this.firstName;
    }

    @Override
    public String getValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        WordBuffer wordBuffer = new WordBuffer();
        wordBuffer.append(this.firstName);
        if (this.lastName.length() > 0 || this.suffix.length() > 0) {
            wordBuffer.append("/" + this.lastName + "/");
        }
        if (this.suffix.length() > 0) {
            wordBuffer.append(this.suffix);
        }
        return wordBuffer.toString();
    }

    @Override
    public String getDisplayValue() {
        if (this.nameAsString != null) {
            return this.nameAsString;
        }
        WordBuffer wordBuffer = new WordBuffer();
        if (Options.getInstance().nameFormat == 1) {
            String string = this.getLastName();
            if (string.length() == 0) {
                string = "?";
            }
            wordBuffer.append(string);
            wordBuffer.append(this.getSuffix());
            wordBuffer.setFiller(", ");
            wordBuffer.append(this.getFirstName());
        } else {
            wordBuffer.append(this.getFirstName());
            wordBuffer.append(this.getLastName());
        }
        return wordBuffer.toString();
    }

    public PropertyName setName(String string) {
        return this.setName(this.firstName, string, this.suffix);
    }

    public PropertyName setName(String string, String string2) {
        return this.setName(string, string2, this.suffix);
    }

    public PropertyName setName(String string, String string2, String string3) {
        return this.setName(string, string2, string3, false);
    }

    public PropertyName setName(String string, String string2, String string3, boolean bl) {
        Property property;
        String string4;
        boolean bl2 = this.getParent() != null;
        String string5 = string4 = bl2 ? this.getValue() : null;
        if (Options.getInstance().isUpperCaseNames) {
            string2 = string2.toUpperCase();
        }
        string = string.trim().intern();
        string2 = string2.trim().intern();
        string3 = string3.trim();
        if (bl) {
            Property[] propertyArray = this.getSameLastNames();
            for (int i = 0; i < propertyArray.length; ++i) {
                property = propertyArray[i];
                if (!(property instanceof PropertyName) || property == this) continue;
                ((PropertyName)property).setName(string2);
            }
        }
        this.remember(string, string2);
        if (bl2) {
            boolean bl3 = Options.getInstance().isAddGivenSurname;
            Property property2 = this.getProperty("GIVN");
            if (bl3 || property2 != null) {
                if (property2 == null) {
                    property2 = this.addProperty("GIVN", string);
                } else {
                    property2.setValue(string);
                }
            }
            property = this.getProperty("SURN");
            if (bl3 || property != null) {
                if (property == null) {
                    property = this.addProperty("SURN", string2);
                } else {
                    property.setValue(string2);
                }
            }
        }
        this.nameAsString = null;
        this.lastName = string2;
        this.firstName = string;
        this.suffix = string3;
        if (string4 != null) {
            this.propagatePropertyChanged(this, string4);
        }
        return this;
    }

    @Override
    void afterAddNotify() {
        super.afterAddNotify();
        this.remember(this.firstName, this.lastName);
    }

    @Override
    void beforeDelNotify() {
        this.remember("", "");
        super.beforeDelNotify();
    }

    @Override
    public void setValue(String string) {
        if (string.indexOf(47) < 0) {
            this.setName(string, "", "");
            return;
        }
        String string2 = string.substring(0, string.indexOf(47)).trim();
        String string3 = string.substring(string.indexOf(47) + 1);
        if (string3.indexOf(47) == -1) {
            this.setName("", "", "");
            this.nameAsString = string;
            return;
        }
        this.suffix = string3.substring(string3.indexOf(47) + 1);
        string3 = string3.substring(0, string3.indexOf(47));
        this.setName(string2, string3, this.suffix);
    }

    public List<String> getLastNames(boolean bl) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getLastNames(gedcom, bl);
    }

    public List<String> getFirstNames(boolean bl) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new ArrayList<String>(0);
        }
        return PropertyName.getFirstNames(gedcom, bl);
    }

    public static List<String> getLastNames(Gedcom gedcom, boolean bl) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getKeys(bl ? gedcom.getCollator() : null);
    }

    public static List<String> getFirstNames(Gedcom gedcom, boolean bl) {
        return gedcom.getReferenceSet(KEY_FIRSTNAME).getKeys(bl ? gedcom.getCollator() : null);
    }

    public int getLastNameCount() {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return 0;
        }
        return PropertyName.getLastNameCount(gedcom, this.getLastName());
    }

    public static int getLastNameCount(Gedcom gedcom, String string) {
        return gedcom.getReferenceSet(KEY_LASTNAME).getReferences(string).size();
    }

    public Property[] getSameLastNames() {
        return PropertyName.toArray(this.getGedcom().getReferenceSet(KEY_LASTNAME).getReferences(this.getLastName()));
    }

    private void remember(String string, String string2) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return;
        }
        ReferenceSet<String, Property> referenceSet = gedcom.getReferenceSet(KEY_LASTNAME);
        if (this.lastName.length() > 0) {
            referenceSet.remove(this.lastName, this);
        }
        if (string2.length() > 0) {
            referenceSet.add(string2, this);
        }
        referenceSet = gedcom.getReferenceSet(KEY_FIRSTNAME);
        if (this.firstName.length() > 0) {
            referenceSet.remove(this.firstName, this);
        }
        if (string.length() > 0) {
            referenceSet.add(string, this);
        }
    }
}

