/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import genj.gedcom.Gedcom;
import genj.gedcom.Grammar;
import genj.gedcom.Options;
import genj.gedcom.Property;
import genj.gedcom.PropertyChoiceValue;
import genj.gedcom.TagPath;
import genj.util.DirectAccessTokenizer;
import genj.util.EnvironmentChecker;
import genj.util.ReferenceSet;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class PropertyPlace
extends PropertyChoiceValue {
    private static final boolean USE_SPACES = "true".equals(EnvironmentChecker.getProperty("genj.gedcom.plac.usespaces", "false", "spaces in jurisdiction separation?"));
    public static final ImageIcon IMAGE = Grammar.V55.getMeta(new TagPath("INDI:BIRT:PLAC")).getImage();
    public static final String JURISDICTION_SEPARATOR = ",";
    private static final String JURISDICTION_RESOURCE_PREFIX = "prop.plac.jurisdiction.";
    public static final String TAG = "PLAC";
    public static final String FORM = "FORM";

    public PropertyPlace(String string) {
        super(string);
    }

    protected String trim(String string) {
        String string2;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        DirectAccessTokenizer directAccessTokenizer = new DirectAccessTokenizer(string, JURISDICTION_SEPARATOR);
        int n = 0;
        while ((string2 = directAccessTokenizer.get(n, true)) != null) {
            if (n > 0) {
                stringBuffer.append(JURISDICTION_SEPARATOR);
                if (USE_SPACES) {
                    stringBuffer.append(' ');
                }
            }
            stringBuffer.append(string2);
            ++n;
        }
        return stringBuffer.toString().intern();
    }

    protected boolean remember(String string, String string2) {
        String string3;
        if (!super.remember(string, string2)) {
            return false;
        }
        Gedcom gedcom = this.getGedcom();
        DirectAccessTokenizer directAccessTokenizer = new DirectAccessTokenizer(string, JURISDICTION_SEPARATOR);
        int n = 0;
        while ((string3 = directAccessTokenizer.get(n, true)) != null) {
            if (string3.length() > 0) {
                gedcom.getReferenceSet("PLAC." + n).remove(string3, this);
            }
            ++n;
        }
        directAccessTokenizer = new DirectAccessTokenizer(string2, JURISDICTION_SEPARATOR);
        n = 0;
        while ((string3 = directAccessTokenizer.get(n, true)) != null) {
            if (string3.length() > 0) {
                gedcom.getReferenceSet("PLAC." + n).add(string3.intern(), this);
            }
            ++n;
        }
        return true;
    }

    public String[] getFormat() {
        return PropertyPlace.toJurisdictions(this.getFormatAsString());
    }

    public static String[] getFormat(Gedcom gedcom) {
        return PropertyPlace.toJurisdictions(gedcom.getPlaceFormat());
    }

    private static String[] toJurisdictions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        String string2 = JURISDICTION_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, JURISDICTION_SEPARATOR, true);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (!JURISDICTION_SEPARATOR.equals(string3)) {
                arrayList.add(string3);
            } else if (JURISDICTION_SEPARATOR.equals(string2)) {
                arrayList.add("");
            }
            string2 = string3;
        }
        if (JURISDICTION_SEPARATOR.equals(string2)) {
            arrayList.add("");
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public String getFormatAsString() {
        String string = "";
        Property property = this.getProperty(FORM);
        if (property != null) {
            string = property.getValue();
        } else {
            Gedcom gedcom = this.getGedcom();
            if (gedcom != null) {
                string = gedcom.getPlaceFormat();
            }
        }
        return string;
    }

    public void setFormatAsString(boolean bl, String string) {
        if (!bl) {
            throw new IllegalArgumentException("non-global n/a");
        }
        this.getGedcom().setPlaceFormat(string);
        this.propagatePropertyChanged(this, this.getValue());
    }

    public PropertyPlace[] getSameChoices(int n) {
        String string = this.getJurisdiction(n);
        if (string == null) {
            return null;
        }
        Set<Property> set = this.getGedcom().getReferenceSet("PLAC." + n).getReferences(string);
        return set.toArray(new PropertyPlace[set.size()]);
    }

    public String[] getAllJurisdictions(int n, boolean bl) {
        Gedcom gedcom = this.getGedcom();
        if (gedcom == null) {
            return new String[0];
        }
        return PropertyPlace.getAllJurisdictions(gedcom, n, bl);
    }

    public static String[] getAllJurisdictions(Gedcom gedcom, int n, boolean bl) {
        ReferenceSet<String, Property> referenceSet = gedcom.getReferenceSet(n < 0 ? TAG : "PLAC." + n);
        List<String> list = referenceSet.getKeys(bl ? gedcom.getCollator() : null);
        return list.toArray(new String[list.size()]);
    }

    public String getFirstAvailableJurisdiction() {
        DirectAccessTokenizer directAccessTokenizer = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR);
        String string = "";
        int n = 0;
        while (string.length() == 0) {
            string = directAccessTokenizer.get(n, true);
            if (string == null) {
                return "";
            }
            ++n;
        }
        return string;
    }

    public String getJurisdiction(int n) {
        return new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(n, true);
    }

    public String[] getJurisdictions() {
        return PropertyPlace.toJurisdictions(this.getValue());
    }

    public String getCity() {
        int n = this.getCityIndex();
        if (n < 0) {
            return this.getFirstAvailableJurisdiction();
        }
        String string = new DirectAccessTokenizer(this.getValue(), JURISDICTION_SEPARATOR).get(n, true);
        return string != null ? string : "";
    }

    public String getValueStartingWithCity() {
        String string = this.getValue();
        int n = this.getCityIndex();
        if (n <= 0) {
            return string;
        }
        return new DirectAccessTokenizer(string, JURISDICTION_SEPARATOR).getSubstring(n);
    }

    private int getCityIndex() {
        if (this.getFormatAsString().length() == 0) {
            return -1;
        }
        Set<String> set = Options.getInstance().placeHierarchyCityKeys;
        String[] stringArray = this.getFormat();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!set.contains(stringArray[i].toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public String format(String string) {
        if (string == null) {
            return this.getFirstAvailableJurisdiction();
        }
        String string2 = string.trim();
        if (string2.equals("")) {
            return this.getFirstAvailableJurisdiction();
        }
        if (string2.equals("all")) {
            return this.getDisplayValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = this.getJurisdictions();
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (Character.isDigit(c)) {
                int n = Character.digit(c, 10);
                if (n >= stringArray.length) continue;
                stringBuffer.append(stringArray[n].trim());
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

