/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom.time;

import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import genj.util.WordBuffer;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Delta
implements Comparable<Delta> {
    public static final String TXT_DAY = PointInTime.resources.getString("time.day");
    public static final String TXT_DAYS = PointInTime.resources.getString("time.days");
    public static final String TXT_DAYSS;
    public static final String TXT_MONTH;
    public static final String TXT_MONTHS;
    public static final String TXT_MONTHSS;
    public static final String TXT_YEAR;
    public static final String TXT_YEARS;
    public static final String TXT_YEARSS;
    private int years;
    private int months;
    private int days;
    private Calendar calendar;

    public Delta(int n, int n2, int n3) {
        this(n, n2, n3, PointInTime.GREGORIAN);
    }

    public Delta(int n, int n2, int n3, Calendar calendar) {
        this.years = n3;
        this.months = n2;
        this.days = n;
        this.calendar = calendar;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public static Delta get(PointInTime pointInTime, PointInTime pointInTime2, Calendar calendar) {
        try {
            pointInTime = pointInTime.getPointInTime(calendar);
            pointInTime2 = pointInTime2.getPointInTime(calendar);
        }
        catch (Throwable throwable) {
            return null;
        }
        if (pointInTime.compareTo(pointInTime2) > 0) {
            PointInTime pointInTime3 = pointInTime;
            pointInTime = pointInTime2;
            pointInTime2 = pointInTime3;
        }
        int n = pointInTime.getYear();
        int n2 = pointInTime.getMonth();
        int n3 = pointInTime.getDay();
        if (pointInTime.getCalendar() == PointInTime.GREGORIAN && n < 0) {
            ++n;
        }
        int n4 = pointInTime2.getYear();
        int n5 = pointInTime2.getMonth();
        int n6 = pointInTime2.getDay();
        if (pointInTime2.getCalendar() == PointInTime.GREGORIAN && n4 < 0) {
            ++n4;
        }
        if (n == Integer.MAX_VALUE || n4 == Integer.MAX_VALUE) {
            return null;
        }
        int n7 = n4 - n;
        int n8 = 0;
        int n9 = 0;
        if (n2 != Integer.MAX_VALUE && n5 != Integer.MAX_VALUE) {
            n8 = n5 - n2;
            if (n3 != Integer.MAX_VALUE && n6 != Integer.MAX_VALUE && (n9 = n6 - n3) < 0) {
                --n8;
                n9 = n6 + (calendar.getDays(n2, n) - n3);
            }
            if (n8 < 0) {
                --n7;
                n8 += calendar.getMonths();
            }
        }
        return new Delta(n9, n8, n7, calendar);
    }

    public static Delta get(PointInTime pointInTime, PointInTime pointInTime2) {
        return Delta.get(pointInTime, pointInTime2, PointInTime.GREGORIAN);
    }

    @Override
    public int compareTo(Delta delta) {
        int n = this.years - delta.years;
        if (n != 0) {
            return n;
        }
        n = this.months - delta.months;
        if (n != 0) {
            return n;
        }
        n = this.days - delta.days;
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Delta)) {
            return false;
        }
        Delta delta = (Delta)object;
        return delta.calendar == this.calendar && delta.days == this.days && delta.months == this.months && delta.years == this.years;
    }

    public int hashCode() {
        return this.calendar.hashCode() + this.days + this.months + this.years;
    }

    public String toString() {
        int n;
        if (this.years == 0 && this.months == 0 && this.days == 0) {
            return "<1 " + TXT_DAY;
        }
        WordBuffer wordBuffer = new WordBuffer();
        if (this.years > 0) {
            wordBuffer.append(this.years);
            n = this.getPluralForm(this.years);
            if (n == 1) {
                wordBuffer.append(TXT_YEAR);
            } else if (n == 2) {
                wordBuffer.append(TXT_YEARS);
            } else {
                wordBuffer.append(TXT_YEARSS);
            }
        }
        if (this.months > 0) {
            wordBuffer.append(this.months);
            n = this.getPluralForm(this.months);
            if (n == 1) {
                wordBuffer.append(TXT_MONTH);
            } else if (n == 2) {
                wordBuffer.append(TXT_MONTHS);
            } else {
                wordBuffer.append(TXT_MONTHSS);
            }
        }
        if (this.days > 0) {
            wordBuffer.append(this.days);
            n = this.getPluralForm(this.days);
            if (n == 1) {
                wordBuffer.append(TXT_DAY);
            } else if (n == 2) {
                wordBuffer.append(TXT_DAYS);
            } else {
                wordBuffer.append(TXT_DAYSS);
            }
        }
        return wordBuffer.toString();
    }

    private int getPluralForm(int n) {
        if ((n = Math.abs(n)) == 1) {
            return 1;
        }
        if (n % 100 / 10 != 1 && n % 10 >= 2 && n % 10 <= 4) {
            return 2;
        }
        return 3;
    }

    public String getValue() {
        WordBuffer wordBuffer = new WordBuffer();
        if (this.years > 0) {
            wordBuffer.append(this.years + "y");
        }
        if (this.months > 0) {
            wordBuffer.append(this.months + "m");
        }
        if (this.years == 0 && this.months == 0 || this.years > 0 && this.months > 0 || this.days > 0) {
            wordBuffer.append(this.days + "d");
        }
        return wordBuffer.toString();
    }

    public void setValue(Delta delta) {
        this.years = delta.years;
        this.months = delta.months;
        this.days = delta.days;
        this.calendar = delta.calendar;
    }

    public boolean setValue(String string) {
        this.years = 0;
        this.months = 0;
        this.days = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        block7: while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.length();
            if (n2 < 2) {
                return false;
            }
            for (n = 0; n < n2 - 1; ++n) {
                if (Character.isDigit(string2.charAt(n))) continue;
                return false;
            }
            try {
                n = Integer.parseInt(string2.substring(0, string2.length() - 1));
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            switch (string2.charAt(n2 - 1)) {
                case 'y': {
                    this.years = n;
                    continue block7;
                }
                case 'm': {
                    this.months = n;
                    continue block7;
                }
                case 'd': {
                    this.days = n;
                    continue block7;
                }
            }
            return false;
        }
        return true;
    }

    static {
        TXT_MONTH = PointInTime.resources.getString("time.month");
        TXT_MONTHS = PointInTime.resources.getString("time.months");
        TXT_YEAR = PointInTime.resources.getString("time.year");
        TXT_YEARS = PointInTime.resources.getString("time.years");
        String string = PointInTime.resources.getString("time.dayss");
        TXT_DAYSS = string.equals("time.dayss") ? PointInTime.resources.getString("time.days") : string;
        string = PointInTime.resources.getString("time.monthss");
        TXT_MONTHSS = string.equals("time.monthss") ? PointInTime.resources.getString("time.months") : string;
        string = PointInTime.resources.getString("time.yearss");
        TXT_YEARSS = string.equals("time.yearss") ? PointInTime.resources.getString("time.years") : string;
    }
}

