/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.Property;
import genj.io.PropertyWriter;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;

public class PropertyTransferable
implements Transferable {
    public static final DataFlavor VMLOCAL_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=java.util.List", "GENJ");
    public static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    public static final DataFlavor TEXT_FLAVOR = DataFlavor.getTextPlainUnicodeFlavor();
    private static final DataFlavor[] FLAVORS = new DataFlavor[]{VMLOCAL_FLAVOR, STRING_FLAVOR, TEXT_FLAVOR};
    private List props;
    private String string;

    public PropertyTransferable(List list) {
        this.props = list;
    }

    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (int i = 0; i < FLAVORS.length; ++i) {
            if (!dataFlavor.equals(FLAVORS[i])) continue;
            return true;
        }
        return false;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(TEXT_FLAVOR)) {
            return new StringReader(this.getStringData());
        }
        if (dataFlavor.equals(STRING_FLAVOR)) {
            return this.getStringData();
        }
        if (dataFlavor.equals(VMLOCAL_FLAVOR)) {
            return this.props;
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }

    public StringSelection getStringTransferable() throws IOException {
        return new StringSelection(this.getStringData());
    }

    private String getStringData() throws IOException {
        StringWriter stringWriter = new StringWriter();
        PropertyWriter propertyWriter = new PropertyWriter(stringWriter, true);
        for (int i = 0; i < this.props.size(); ++i) {
            propertyWriter.write(0, (Property)this.props.get(i));
        }
        return stringWriter.toString();
    }
}

