/*
 * Decompiled with CFR 0.152.
 */
package genj.lnf;

import genj.util.EnvironmentChecker;
import genj.util.Registry;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LnF {
    private static Logger LOG = Logger.getLogger("genj.lnf");
    private static final String LNF_PROPERTIES = "lnf.properties";
    private static final String LNF_DIR = "./lnf";
    private static LnF[] instances;
    private String name;
    private String type;
    private String archive;
    private String url;
    private String version;
    private String theme;
    private ClassLoader cl;
    private LookAndFeel instance;

    public static LnF[] getLnFs() {
        if (instances != null) {
            return instances;
        }
        ArrayList<LnF> arrayList = new ArrayList<LnF>();
        arrayList.add(new LnF("System Default", UIManager.getSystemLookAndFeelClassName(), "", "", null, null));
        try {
            Registry registry = new Registry(new FileInputStream(new File(LnF.getLnFDir(), LNF_PROPERTIES)));
            int n = registry.get("lnf.count", 0);
            for (int i = 0; i < n; ++i) {
                String[] stringArray;
                String string = "lnf." + (i + 1);
                String string2 = registry.get(string + ".name", "");
                String string3 = registry.get(string + ".type", "");
                String string4 = registry.get(string + ".url", "");
                String string5 = registry.get(string + ".version", "");
                String string6 = registry.get(string + ".jar", (String)null);
                if (string2.length() == 0) continue;
                int n2 = string2.indexOf(40);
                if (n2 > 0) {
                    string2 = string2.substring(0, n2);
                }
                if ((stringArray = registry.get(string + ".themes", new String[0])).length > 0) {
                    for (int j = 0; j < stringArray.length; ++j) {
                        arrayList.add(new LnF(string2, string3, string4, string5, string6, stringArray[j]));
                    }
                    continue;
                }
                arrayList.add(new LnF(string2, string3, string4, string5, string6, null));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        arrayList.add(new LnF("Java Default", UIManager.getLookAndFeel().getClass().getName(), "", "", null, null));
        instances = arrayList.toArray(new LnF[arrayList.size()]);
        return instances;
    }

    private static String getLnFDir() {
        return EnvironmentChecker.getProperty("genj.lnf.dir", LNF_DIR, "read lnf.properties");
    }

    private LnF(String string, String string2, String string3, String string4, String string5, String string6) {
        this.name = string;
        this.type = string2;
        this.url = string3;
        this.version = string4;
        this.archive = string5;
        this.theme = string6;
        LOG.info("Found Look&Feel " + string + " type=" + string2 + " version=" + string4 + " url=" + string3 + " archive=" + string5 + " theme=" + string6);
    }

    private LookAndFeel getInstance() throws Exception {
        if (this.instance == null) {
            this.instance = (LookAndFeel)this.cl.loadClass(this.type).newInstance();
        }
        if (this.instance.getClass() == MetalLookAndFeel.class) {
            MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
        }
        if (this.theme != null) {
            String string = new File(LnF.getLnFDir(), this.getTheme()).getAbsolutePath();
            System.setProperty("skinlf.themepack", string);
        }
        return this.instance;
    }

    private ClassLoader getCL() throws MalformedURLException {
        if (this.cl != null) {
            return this.cl;
        }
        if (this.archive == null) {
            this.cl = this.getClass().getClassLoader();
        } else {
            URL uRL = new URL("file", "", new File(LnF.getLnFDir(), this.archive).getAbsolutePath());
            this.cl = new URLClassLoader(new URL[]{uRL}, this.getClass().getClassLoader());
        }
        return this.cl;
    }

    public String toString() {
        if (this.theme == null) {
            return this.name;
        }
        String string = this.theme;
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return this.name + '(' + string + ')';
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getArchive() {
        return this.archive;
    }

    public String getTheme() {
        return this.theme;
    }

    public boolean apply(final List list) {
        String string = "Look and feel #" + this + " of type " + this.type;
        try {
            UIManager.getLookAndFeelDefaults().put("ClassLoader", this.getCL());
            UIManager.getDefaults().put("ClassLoader", this.getCL());
            UIManager.setLookAndFeel(this.getInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOG.warning(string + " is not accessible (ClassNotFoundException)");
            return false;
        }
        catch (ClassCastException classCastException) {
            LOG.warning(string + " is not a valid LookAndFeel (ClassCastException)");
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            LOG.warning(string + " doesn't point to a valid archive (MalformedURLException)");
            return false;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            LOG.warning(string + " is not supported on this platform (UnsupportedLookAndFeelException)");
            return false;
        }
        catch (Throwable throwable) {
            LOG.warning(string + " couldn't be set (" + throwable.getClass() + ")");
            return false;
        }
        if (list != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        try {
                            SwingUtilities.updateComponentTreeUI((Component)iterator.next());
                        }
                        catch (Throwable throwable) {}
                    }
                }
            });
        }
        return true;
    }
}

