/*
 * Decompiled with CFR 0.152.
 */
package genj.print;

import genj.print.PrintRenderer;
import genj.print.PrintTask;
import genj.print.PrintWidget;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import java.awt.event.ActionEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.PrintException;
import javax.swing.Action;

public abstract class PrintAction
extends Action2 {
    private static final Resources RES = Resources.get(PrintAction.class);
    private static final ImageIcon IMG = new ImageIcon(PrintAction.class, "images/Print.png");
    private static final Logger LOG = Logger.getLogger("genj.print");
    private String title;

    public PrintAction(String string) {
        this.setText(RES.getString("print"));
        this.setTip(this.getText());
        this.setImage(IMG);
        this.title = RES.getString("title", string);
    }

    protected abstract PrintRenderer getRenderer();

    public void actionPerformed(ActionEvent actionEvent) {
        PrintTask printTask;
        try {
            printTask = new PrintTask(this.title, this.getRenderer());
        }
        catch (PrintException printException) {
            LOG.log(Level.INFO, "can't setup print task", printException);
            DialogHelper.openDialog(this.title, 0, printException.getMessage(), (Action[])Action2.okOnly(), (Object)actionEvent);
            return;
        }
        PrintWidget printWidget = new PrintWidget(printTask);
        Action[] actionArray = new Action[]{new Action2(RES.getString("print")), Action2.cancel()};
        int n = DialogHelper.openDialog(this.title, 3, printWidget, actionArray, (Object)actionEvent);
        if (n != 0 || printTask.getPages().width == 0 || printTask.getPages().height == 0) {
            return;
        }
        printWidget.commit();
        printTask.print();
    }
}

