/*
 * Decompiled with CFR 0.152.
 */
package genj.timeline;

import genj.gedcom.Context;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.DPI;
import genj.renderer.Options;
import genj.renderer.RenderSelectionHintKey;
import genj.timeline.ContentRenderer;
import genj.timeline.Model;
import genj.timeline.RulerRenderer;
import genj.timeline.TimelineViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.ScrollPaneWidget;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.view.ContextProvider;
import genj.view.ScreenshotAction;
import genj.view.SelectionSink;
import genj.view.SettingsAction;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TimelineView
extends View {
    private final DPI DPI;
    private final Point2D DPC;
    private Resources resources = Resources.get(this);
    Map<String, Color> colors = new HashMap<String, Color>();
    private Model model;
    private Content content;
    private Set<Model.Event> selection = new HashSet<Model.Event>();
    private Ruler ruler;
    private SliderWidget sliderCmPerYear;
    private JScrollPane scrollContent;
    private RulerRenderer rulerRenderer = new RulerRenderer();
    private ContentRenderer contentRenderer = new ContentRenderer();
    static final double MIN_CM_PER_YEAR = 0.1;
    static final double DEF_CM_PER_YEAR = 1.0;
    static final double MAX_CM_PER_YEAR = 10.0;
    static final double MIN_CM_BEF_EVENT = 0.1;
    static final double DEF_CM_BEF_EVENT = 0.5;
    static final double MAX_CM_BEF_EVENT = 2.0;
    static final double MIN_CM_AFT_EVENT = 2.0;
    static final double DEF_CM_AFT_EVENT = 2.0;
    static final double MAX_CM_AFT_EVENT = 9.0;
    private double cmPerYear = 1.0;
    private double cmBefEvent = 0.5;
    private double cmAftEvent = 2.0;
    private double centeredYear = 0.0;
    private boolean isPaintDates = true;
    private boolean isPaintGrid = false;
    private boolean isPaintTags = true;
    private static final Registry REGISTRY = Registry.get(TimelineView.class);
    private ModelListener callback = new ModelListener();

    public TimelineView() {
        this.DPI = Options.getInstance().getDPI();
        this.DPC = new Point2D.Float((float)this.DPI.horizontal() / 2.54f, (float)this.DPI.vertical() / 2.54f);
        this.cmPerYear = Math.max(0.1, Math.min(10.0, (double)REGISTRY.get("cmperyear", 1.0f)));
        this.cmBefEvent = Math.max(0.1, Math.min(2.0, (double)REGISTRY.get("cmbefevent", 0.5f)));
        this.cmAftEvent = Math.max(2.0, Math.min(9.0, (double)REGISTRY.get("cmaftevent", 2.0f)));
        this.isPaintDates = REGISTRY.get("paintdates", true);
        this.isPaintGrid = REGISTRY.get("paintgrid", false);
        this.isPaintTags = REGISTRY.get("painttags", false);
        this.colors.put("background", Color.WHITE);
        this.colors.put("text", Color.BLACK);
        this.colors.put("tag", Color.GREEN);
        this.colors.put("date", Color.GRAY);
        this.colors.put("timespan", Color.BLUE);
        this.colors.put("grid", Color.LIGHT_GRAY);
        this.colors.put("selected", Color.RED);
        this.colors = REGISTRY.get("color", this.colors);
        this.model = new Model();
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear);
        String[] stringArray = REGISTRY.get("paths", (String[])null);
        if (stringArray != null) {
            ArrayList<TagPath> arrayList = new ArrayList<TagPath>(stringArray.length);
            for (String string : stringArray) {
                try {
                    arrayList.add(new TagPath(string));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.model.setPaths(arrayList);
        }
        this.content = new Content();
        this.ruler = new Ruler();
        this.scrollContent = new ScrollPaneWidget(new ViewPortAdapter(this.content));
        this.scrollContent.setColumnHeaderView(new ViewPortAdapter(this.ruler));
        this.scrollContent.getViewport().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ((TimelineView)TimelineView.this).scrollContent.getViewport().getViewPosition().x + ((TimelineView)TimelineView.this).scrollContent.getViewport().getSize().width / 2;
                TimelineView.this.centeredYear = TimelineView.this.pixel2year(n);
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollContent, "Center");
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TimelineView.this.centeredYear = REGISTRY.get("centeryear", 0.0f);
                TimelineView.this.scroll2year(TimelineView.this.centeredYear);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        this.model.addListener(this.callback);
    }

    public void removeNotify() {
        this.model.removeListener(this.callback);
        REGISTRY.put("cmperyear", (float)Math.rint(this.cmPerYear * 10.0) / 10.0f);
        REGISTRY.put("cmbefevent", (float)this.cmBefEvent);
        REGISTRY.put("cmaftevent", (float)this.cmAftEvent);
        REGISTRY.put("paintdates", this.isPaintDates);
        REGISTRY.put("paintgrid", this.isPaintGrid);
        REGISTRY.put("painttags", this.isPaintTags);
        REGISTRY.put("filter", this.model.getPaths());
        REGISTRY.put("centeryear", (float)this.centeredYear);
        REGISTRY.put("color", this.colors);
        REGISTRY.put("paths", this.model.getPaths());
        super.removeNotify();
    }

    public Dimension getPreferredSize() {
        return new Dimension(480, 256);
    }

    public Model getModel() {
        return this.model;
    }

    public boolean isPaintTags() {
        return this.isPaintTags;
    }

    public void setPaintTags(boolean bl) {
        this.isPaintTags = bl;
        this.repaint();
    }

    public boolean isPaintDates() {
        return this.isPaintDates;
    }

    public void setPaintDates(boolean bl) {
        this.isPaintDates = bl;
        this.repaint();
    }

    public boolean isPaintGrid() {
        return this.isPaintGrid;
    }

    public void setPaintGrid(boolean bl) {
        this.isPaintGrid = bl;
        this.repaint();
    }

    public void setCMPerEvents(double d, double d2) {
        this.cmBefEvent = d;
        this.cmAftEvent = d2;
        this.model.setTimePerEvent(this.cmBefEvent / this.cmPerYear, this.cmAftEvent / this.cmPerYear);
    }

    public double getCmBeforeEvents() {
        return this.cmBefEvent;
    }

    public double getCmAfterEvents() {
        return this.cmAftEvent;
    }

    public void populate(ToolBar toolBar) {
        int n = (int)(Math.log((this.cmPerYear - 0.1) / 9.9 * Math.exp(10.0)) * 10.0);
        this.sliderCmPerYear = new SliderWidget(1, 100, Math.min(100, Math.max(1, n)));
        this.sliderCmPerYear.setToolTipText(this.resources.getString("view.peryear.tip"));
        this.sliderCmPerYear.addChangeListener(new ChangeCmPerYear());
        this.sliderCmPerYear.setOpaque(false);
        toolBar.add(this.sliderCmPerYear);
        toolBar.add(new Settings());
        toolBar.add(new ScreenshotAction(this.content));
    }

    public void setContext(Context context, boolean bl) {
        if (context == null) {
            this.model.setGedcom(null);
            this.selection.clear();
        } else {
            this.model.setGedcom(context.getGedcom());
            this.selection = this.model.getEvents(context);
        }
        this.content.repaint();
    }

    protected Model.Event getEventAt(Point point) {
        double d = this.pixel2year(point.x);
        int n = point.y / (this.getFontMetrics(this.getFont()).getHeight() + 1);
        return this.model.getEvent(d, n);
    }

    protected double pixel2year(int n) {
        return this.model.min + (double)n / (this.DPC.getX() * this.cmPerYear);
    }

    protected void scroll2year(double d) {
        this.centeredYear = d;
        int n = (int)((d - this.model.min) * this.DPC.getX() * this.cmPerYear) - this.scrollContent.getViewport().getWidth() / 2;
        this.scrollContent.getHorizontalScrollBar().setValue(n);
        this.scrollContent.getHorizontalScrollBar().setUnitIncrement((int)(this.DPC.getX() * this.cmPerYear));
    }

    protected void makeVisible(Model.Event event) {
        double d = this.model.min + (double)this.scrollContent.getHorizontalScrollBar().getValue() / this.DPC.getX() / this.cmPerYear;
        double d2 = d + (double)this.scrollContent.getViewport().getWidth() / this.DPC.getX() / this.cmPerYear;
        if (event.to > d2 || event.from < d) {
            this.scroll2year(event.from);
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TimelineViewSettings getEditor() {
            return new TimelineViewSettings(TimelineView.this);
        }
    }

    private class ModelListener
    implements Model.Listener {
        private ModelListener() {
        }

        public void dataChanged() {
            TimelineView.this.repaint();
        }

        public void structureChanged() {
            TimelineView.this.ruler.revalidate();
            TimelineView.this.content.revalidate();
            TimelineView.this.repaint();
        }
    }

    private class ChangeCmPerYear
    implements ChangeListener {
        private ChangeCmPerYear() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            double d = TimelineView.this.centeredYear;
            TimelineView.this.cmPerYear = 0.1 + Math.exp((double)TimelineView.this.sliderCmPerYear.getValue() * 0.1) / Math.exp(10.0) * 9.9;
            TimelineView.this.model.setTimePerEvent(TimelineView.this.cmBefEvent / TimelineView.this.cmPerYear, TimelineView.this.cmAftEvent / TimelineView.this.cmPerYear);
            TimelineView.this.scroll2year(d);
        }
    }

    private class Content
    extends JComponent
    implements MouseListener,
    ContextProvider {
        private Content() {
            this.addMouseListener(this);
        }

        public ViewContext getContext() {
            Gedcom gedcom = TimelineView.this.model.getGedcom();
            if (gedcom == null) {
                return null;
            }
            ArrayList<Property> arrayList = new ArrayList<Property>();
            for (Model.Event event : TimelineView.this.selection) {
                arrayList.add(event.pe);
            }
            return new ViewContext(gedcom, null, (List<Property>)arrayList);
        }

        public Dimension getPreferredSize() {
            return new Dimension((int)((((TimelineView)TimelineView.this).model.max - ((TimelineView)TimelineView.this).model.min) * TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear), ((TimelineView)TimelineView.this).model.layers.size() * (this.getFontMetrics(this.getFont()).getHeight() + 1));
        }

        protected void paintComponent(Graphics graphics) {
            Boolean bl = (Boolean)((Graphics2D)graphics).getRenderingHint(RenderSelectionHintKey.KEY);
            if (bl == null) {
                bl = true;
            }
            ((TimelineView)TimelineView.this).contentRenderer.selection = bl != false ? TimelineView.this.selection : Collections.emptySet();
            ((TimelineView)TimelineView.this).contentRenderer.cBackground = TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).contentRenderer.cText = TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).contentRenderer.cDate = TimelineView.this.colors.get("date");
            ((TimelineView)TimelineView.this).contentRenderer.cTag = TimelineView.this.colors.get("tag");
            ((TimelineView)TimelineView.this).contentRenderer.cTimespan = TimelineView.this.colors.get("timespan");
            ((TimelineView)TimelineView.this).contentRenderer.cGrid = TimelineView.this.colors.get("grid");
            ((TimelineView)TimelineView.this).contentRenderer.cSelected = TimelineView.this.colors.get("selected");
            ((TimelineView)TimelineView.this).contentRenderer.paintDates = TimelineView.this.isPaintDates;
            ((TimelineView)TimelineView.this).contentRenderer.paintGrid = TimelineView.this.isPaintGrid;
            ((TimelineView)TimelineView.this).contentRenderer.paintTags = TimelineView.this.isPaintTags;
            UnitGraphics unitGraphics = new UnitGraphics(graphics, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, graphics.getFontMetrics().getHeight() + 1);
            unitGraphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            TimelineView.this.contentRenderer.render(unitGraphics, TimelineView.this.model);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Model.Event event;
            if (mouseEvent.getButton() != 1) {
                return;
            }
            if (!mouseEvent.isShiftDown()) {
                TimelineView.this.selection.clear();
            }
            if ((event = TimelineView.this.getEventAt(mouseEvent.getPoint())) != null) {
                TimelineView.this.selection.add(event);
                SelectionSink.Dispatcher.fireSelection(mouseEvent, this.getContext());
            }
            this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }
    }

    private class Ruler
    extends JComponent
    implements ChangeListener {
        private Ruler() {
        }

        public void addNotify() {
            super.addNotify();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.repaint();
        }

        protected void paintComponent(Graphics graphics) {
            ((TimelineView)TimelineView.this).rulerRenderer.cBackground = TimelineView.this.colors.get("background");
            ((TimelineView)TimelineView.this).rulerRenderer.cTick = ((TimelineView)TimelineView.this).rulerRenderer.cText = TimelineView.this.colors.get("text");
            ((TimelineView)TimelineView.this).rulerRenderer.cTimespan = TimelineView.this.colors.get("timespan");
            UnitGraphics unitGraphics = new UnitGraphics(graphics, TimelineView.this.DPC.getX() * TimelineView.this.cmPerYear, this.getFontMetrics(this.getFont()).getHeight() + 1);
            unitGraphics.translate(-((TimelineView)TimelineView.this).model.min, 0.0);
            TimelineView.this.rulerRenderer.render(unitGraphics, TimelineView.this.model);
        }

        public Dimension getPreferredSize() {
            return new Dimension(((TimelineView)TimelineView.this).content.getPreferredSize().width, this.getFontMetrics(this.getFont()).getHeight() + 1);
        }
    }
}

