/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomListenerAdapter;
import genj.gedcom.GedcomMetaListener;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.tree.Bookmark;
import genj.tree.GridCache;
import genj.tree.ModelListener;
import genj.tree.Parser;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import gj.layout.LayoutException;
import gj.layout.tree.TreeLayout;
import gj.model.Node;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Model {
    private Callback callback = new Callback();
    private List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private Collection<TreeArc> arcs = new ArrayList<TreeArc>(100);
    private Map<Entity, TreeNode> entities2nodes = new HashMap<Entity, TreeNode>(100);
    private Collection<TreeNode> nodes = new ArrayList<TreeNode>(100);
    private Rectangle bounds = new Rectangle();
    private GridCache cache = null;
    private boolean isVertical = true;
    private boolean isFamilies = true;
    private boolean isBendArcs = true;
    private boolean isMarrSymbols = true;
    private boolean isFoldSymbols = true;
    private Set<String> hideAncestors = new HashSet<String>();
    private Set<String> hideDescendants = new HashSet<String>();
    private Map<Indi, Fam> indi2fam = new HashMap<Indi, Fam>();
    private Entity root;
    private TreeMetrics metrics = new TreeMetrics(60, 30, 30, 15, 10);
    private LinkedList<Bookmark> bookmarks = new LinkedList();

    public void setRoot(Entity entity) {
        if (this.root == entity) {
            return;
        }
        if (this.root != null) {
            this.root.getGedcom().removeGedcomListener(this.callback);
            this.root = null;
        }
        if (entity instanceof Indi || entity instanceof Fam) {
            this.root = entity;
            this.root.getGedcom().addGedcomListener(this.callback);
        }
        this.bookmarks.clear();
        this.update();
    }

    public Entity getRoot() {
        return this.root;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean bl) {
        if (this.isVertical == bl) {
            return;
        }
        this.isVertical = bl;
        this.update();
    }

    public boolean isBendArcs() {
        return this.isBendArcs;
    }

    public void setBendArcs(boolean bl) {
        if (this.isBendArcs == bl) {
            return;
        }
        this.isBendArcs = bl;
        this.update();
    }

    public boolean isFamilies() {
        return this.isFamilies;
    }

    public void setFamilies(boolean bl) {
        if (this.isFamilies == bl) {
            return;
        }
        this.isFamilies = bl;
        this.update();
    }

    public boolean isMarrSymbols() {
        return this.isMarrSymbols;
    }

    public void setMarrSymbols(boolean bl) {
        if (this.isMarrSymbols == bl) {
            return;
        }
        this.isMarrSymbols = bl;
        this.update();
    }

    public void setFoldSymbols(boolean bl) {
        if (this.isFoldSymbols == bl) {
            return;
        }
        this.isFoldSymbols = bl;
        this.update();
    }

    public boolean isFoldSymbols() {
        return this.isFoldSymbols;
    }

    public TreeMetrics getMetrics() {
        return this.metrics;
    }

    public void setMetrics(TreeMetrics treeMetrics) {
        if (this.metrics.equals(treeMetrics)) {
            return;
        }
        this.metrics = treeMetrics;
        this.update();
    }

    public void addListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    public Collection<? extends TreeNode> getNodesIn(Rectangle rectangle) {
        if (this.cache == null) {
            return new HashSet();
        }
        return this.cache.get(rectangle);
    }

    public Collection<TreeArc> getArcsIn(Rectangle rectangle) {
        ArrayList<TreeArc> arrayList = new ArrayList<TreeArc>(this.arcs.size());
        for (TreeArc treeArc : this.arcs) {
            if (treeArc.getPath() == null || !treeArc.getPath().intersects((Rectangle2D)rectangle)) continue;
            arrayList.add(treeArc);
        }
        return arrayList;
    }

    public TreeNode getNodeAt(int n, int n2) {
        if (this.cache == null) {
            return null;
        }
        int n3 = Math.max(this.metrics.wIndis, this.metrics.wFams);
        int n4 = Math.max(this.metrics.hIndis, this.metrics.hFams);
        Rectangle rectangle = new Rectangle(n - n3 / 2, n2 - n4 / 2, n3, n4);
        for (TreeNode treeNode : this.cache.get(rectangle)) {
            Shape shape = treeNode.getShape();
            if (shape == null || !shape.getBounds2D().contains(n - treeNode.pos.x, n2 - treeNode.pos.y)) continue;
            return treeNode;
        }
        return null;
    }

    public Object getContentAt(int n, int n2) {
        TreeNode treeNode = this.getNodeAt(n, n2);
        return treeNode != null ? treeNode.getContent() : null;
    }

    public Entity getEntityAt(int n, int n2) {
        Object object = this.getContentAt(n, n2);
        return object instanceof Entity ? (Entity)object : null;
    }

    public TreeNode getNode(Entity entity) {
        return this.entities2nodes.get(entity);
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void addBookmark(Bookmark bookmark) {
        this.bookmarks.addFirst(bookmark);
        if (this.bookmarks.size() > 16) {
            this.bookmarks.removeLast();
        }
    }

    public List<Bookmark> getBookmarks() {
        return Collections.unmodifiableList(this.bookmarks);
    }

    public void setBookmarks(List<Bookmark> list) {
        this.bookmarks.clear();
        this.bookmarks.addAll(list);
    }

    public Collection<String> getHideAncestorsIDs() {
        return this.hideAncestors;
    }

    public void setHideAncestorsIDs(Collection<String> collection) {
        this.hideAncestors.clear();
        this.hideAncestors.addAll(collection);
    }

    public Collection<String> getHideDescendantsIDs() {
        return this.hideDescendants;
    }

    public void setHideDescendantsIDs(Collection<String> collection) {
        this.hideDescendants.clear();
        this.hideDescendants.addAll(collection);
    }

    private Collection<String> getIds(Collection<Entity> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Entity entity : collection) {
            arrayList.add(entity.getId());
        }
        return arrayList;
    }

    boolean isHideDescendants(Indi indi) {
        return this.hideDescendants.contains(indi.getId());
    }

    boolean isHideAncestors(Indi indi) {
        return this.hideAncestors.contains(indi.getId());
    }

    Fam getFamily(Indi indi, Fam[] famArray, boolean bl) {
        if (famArray.length > 0) {
            Fam fam = this.indi2fam.get(indi);
            if (fam == null) {
                fam = famArray[0];
            }
            for (int i = 0; i < famArray.length; ++i) {
                if (famArray[i] != fam) continue;
                return famArray[(i + (bl ? 1 : 0)) % famArray.length];
            }
            this.indi2fam.remove(indi);
        }
        return famArray[0];
    }

    TreeNode add(TreeNode treeNode) {
        Object object = treeNode.getContent();
        if (object instanceof Entity) {
            this.entities2nodes.put((Entity)object, treeNode);
        }
        this.nodes.add(treeNode);
        return treeNode;
    }

    TreeArc add(TreeArc treeArc) {
        this.arcs.add(treeArc);
        return treeArc;
    }

    Set getEntities() {
        return this.entities2nodes.keySet();
    }

    private void update() {
        this.arcs.clear();
        this.nodes.clear();
        this.entities2nodes.clear();
        this.bounds.setFrame(0.0, 0.0, 0.0, 0.0);
        if (this.root == null) {
            this.fireStructureChanged();
            return;
        }
        try {
            boolean bl = this.isFamilies || this.root instanceof Fam;
            Parser object = Parser.getInstance(false, bl, this, this.metrics);
            this.bounds.add(this.layout(object.parse(this.root), true));
            this.bounds.add(this.layout(object.align(Parser.getInstance(true, bl, this, this.metrics).parse(this.root)), false));
        }
        catch (LayoutException layoutException) {
            layoutException.printStackTrace();
            this.root = null;
            this.update();
            return;
        }
        this.cache = new GridCache(this.bounds, 3 * this.metrics.calcMax());
        for (TreeNode treeNode : this.nodes) {
            if (treeNode.shape == null) continue;
            this.cache.put((Object)treeNode, treeNode.shape.getBounds(), treeNode.pos);
        }
        this.fireStructureChanged();
    }

    private Rectangle layout(TreeNode treeNode, boolean bl) throws LayoutException {
        double d = 0.0;
        if (!bl) {
            d += 180.0;
        }
        if (!this.isVertical) {
            d -= 90.0;
        }
        TreeLayout treeLayout = new TreeLayout();
        treeLayout.setBendArcs(this.isBendArcs);
        treeLayout.setDebug(false);
        treeLayout.setIgnoreUnreachables(true);
        treeLayout.setBalanceChildren(false);
        treeLayout.setRoot((Node)treeNode);
        treeLayout.setOrientation(d);
        return treeLayout.layout((Node)treeNode, this.nodes.size()).getBounds();
    }

    private void fireStructureChanged() {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).structureChanged(this);
        }
    }

    private void fireNodesChanged(Collection collection) {
        for (int i = this.listeners.size() - 1; i >= 0; --i) {
            this.listeners.get(i).nodesChanged(this, collection);
        }
    }

    private class Callback
    extends GedcomListenerAdapter
    implements GedcomMetaListener {
        private Set repaint = new HashSet();
        private boolean update = false;
        private Entity added;

        private Callback() {
        }

        public void gedcomWriteLockAcquired(Gedcom gedcom) {
            this.added = null;
            this.repaint.clear();
        }

        public void gedcomWriteLockReleased(Gedcom gedcom) {
            if (Model.this.root == null) {
                if (this.added == null || !gedcom.contains(this.added)) {
                    this.added = gedcom.getFirstEntity("INDI");
                }
                Model.this.root = this.added;
                Model.this.update();
                return;
            }
            if (this.update) {
                Model.this.update();
                return;
            }
            if (!this.repaint.isEmpty()) {
                Model.this.fireNodesChanged(this.repaint);
            }
        }

        public void gedcomEntityAdded(Gedcom gedcom, Entity entity) {
            if ((entity instanceof Fam || entity instanceof Indi) && (!(this.added instanceof Indi) || entity instanceof Indi)) {
                this.added = entity;
            }
        }

        public void gedcomEntityDeleted(Gedcom gedcom, Entity entity) {
            if (entity == Model.this.root) {
                Model.this.root = null;
            }
            ListIterator listIterator = Model.this.bookmarks.listIterator();
            while (listIterator.hasNext()) {
                Bookmark bookmark = (Bookmark)listIterator.next();
                if (entity != bookmark.getEntity()) continue;
                listIterator.remove();
            }
            Model.this.indi2fam.keySet().remove(entity);
        }

        public void gedcomPropertyAdded(Gedcom gedcom, Property property, int n, Property property2) {
            this.gedcomPropertyChanged(gedcom, property2);
        }

        public void gedcomPropertyChanged(Gedcom gedcom, Property property) {
            TreeNode treeNode;
            if (property instanceof PropertyXRef) {
                this.update = true;
            }
            if ("PEDI".equals(property.getTag())) {
                this.update = true;
            }
            if ((treeNode = Model.this.getNode(property.getEntity())) != null) {
                Model.this.fireNodesChanged(Collections.singletonList(treeNode));
            }
        }

        public void gedcomPropertyDeleted(Gedcom gedcom, Property property, int n, Property property2) {
            if (property2 instanceof PropertyXRef) {
                this.update = true;
            }
            if (Model.this.root != null) {
                this.repaint.add(Model.this.getNode(property.getEntity()));
            }
        }
    }

    class FoldUnfold
    implements Runnable {
        private Indi indi;
        private Set<String> set;

        protected FoldUnfold(Indi indi, boolean bl) {
            this.indi = indi;
            this.set = bl ? Model.this.hideAncestors : Model.this.hideDescendants;
        }

        public void run() {
            if (!this.set.remove(this.indi.getId())) {
                this.set.add(this.indi.getId());
            }
            Model.this.update();
        }
    }

    class NextFamily
    implements Runnable {
        private Indi indi;
        private Fam fam;

        protected NextFamily(Indi indi, Fam[] famArray) {
            this.indi = indi;
            this.fam = Model.this.getFamily(this.indi, famArray, true);
        }

        public void run() {
            Model.this.indi2fam.put(this.indi, this.fam);
            Model.this.update();
        }
    }
}

