/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Indi;
import genj.tree.Model;
import genj.tree.TreeArc;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import gj.awt.geom.Path;
import gj.layout.tree.Branch;
import gj.layout.tree.Orientation;
import gj.model.Node;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

abstract class Parser {
    protected Model model;
    protected TreeMetrics metrics;
    protected Path shapeMarrs;
    protected Path shapeIndis;
    protected Path shapeFams;
    protected Path shapePlus;
    protected Path shapeMinus;
    protected Path shapeNext;
    protected int[] padIndis;
    protected int[] padMinusPlus;
    private static final int MAX_GENERATION = 20;

    public static Parser getInstance(boolean bl, boolean bl2, Model model, TreeMetrics treeMetrics) {
        if (bl) {
            if (bl2) {
                return new AncestorsWithFams(model, treeMetrics);
            }
            return new AncestorsNoFams(model, treeMetrics);
        }
        if (bl2) {
            return new DescendantsWithFams(model, treeMetrics);
        }
        return new DescendantsNoFams(model, treeMetrics);
    }

    protected Parser(Model model, TreeMetrics treeMetrics) {
        this.model = model;
        this.metrics = treeMetrics;
        this.initEntityShapes();
        this.initFoldUnfoldShapes();
        this.initMarrShapes();
    }

    public final TreeNode parse(Entity entity) {
        return entity instanceof Indi ? this.parse((Indi)entity) : this.parse((Fam)entity);
    }

    public TreeNode align(TreeNode treeNode) {
        return treeNode;
    }

    protected abstract TreeNode parse(Indi var1);

    protected abstract TreeNode parse(Fam var1);

    private void initMarrShapes() {
        this.shapeMarrs = new Path();
        if (!this.model.isMarrSymbols()) {
            this.shapeMarrs.append((Shape)new Rectangle2D.Double());
            return;
        }
        int n = Math.min(this.metrics.wIndis / 4, this.metrics.hIndis / 4);
        Ellipse2D.Float float_ = new Ellipse2D.Float((float)(-n) * 0.3f, (float)(-n) * 0.3f, (float)n * 0.6f, (float)n * 0.6f);
        float f = this.model.isVertical() ? (float)n * 0.2f : (float)n * 0.0f;
        float f2 = this.model.isVertical() ? (float)n * 0.0f : (float)n * 0.2f;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-f, -f2);
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(f, f2);
        this.shapeMarrs.append(float_.getPathIterator(affineTransform));
        this.shapeMarrs.append(float_.getPathIterator(affineTransform2));
        Rectangle2D rectangle2D = this.shapeMarrs.getBounds2D();
        if (this.model.isVertical()) {
            rectangle2D.setRect(rectangle2D.getMinX(), -this.metrics.hIndis / 2 - this.metrics.pad / 2, rectangle2D.getWidth(), this.metrics.hIndis + this.metrics.pad);
        } else {
            rectangle2D.setRect(-this.metrics.wIndis / 2 - this.metrics.pad / 2, rectangle2D.getMinY(), this.metrics.wIndis + this.metrics.pad, rectangle2D.getHeight());
        }
        this.shapeMarrs.setBounds2D(rectangle2D);
    }

    private void initEntityShapes() {
        this.padIndis = new int[]{this.metrics.pad / 2, this.metrics.pad / 2, this.metrics.pad / 2, this.metrics.pad / 2};
        this.shapeIndis = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wIndis / 2, -this.metrics.hIndis / 2, this.metrics.wIndis, this.metrics.hIndis));
        this.shapeFams = new Path().append((Shape)new Rectangle2D.Double(-this.metrics.wFams / 2, -this.metrics.hFams / 2, this.metrics.wFams, this.metrics.hFams));
    }

    private void initFoldUnfoldShapes() {
        this.padMinusPlus = new int[]{-this.padIndis[3], this.padIndis[1], this.padIndis[2], this.padIndis[3]};
        double d = 3.0;
        this.shapePlus = new Path();
        this.shapePlus.moveTo((Point2D)new Point2D.Double(0.0, -d * 0.3));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(0.0, d * 0.3));
        this.shapePlus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapePlus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapePlus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
        this.shapeMinus = new Path();
        this.shapeMinus.moveTo((Point2D)new Point2D.Double(-d * 0.3, 0.0));
        this.shapeMinus.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapeMinus.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
        this.shapeNext = new Path();
        this.shapeNext.moveTo((Point2D)new Point2D.Double(-d * 0.3, -d * 0.3));
        this.shapeNext.lineTo((Point2D)new Point2D.Double(d * 0.3, 0.0));
        this.shapeNext.lineTo((Point2D)new Point2D.Double(-d * 0.3, d * 0.3));
        this.shapeNext.append((Shape)new Rectangle2D.Double(-d / 2.0, -d / 2.0, d, d));
    }

    protected TreeNode insertPlusMinus(Indi indi, TreeNode treeNode, boolean bl, boolean bl2) {
        if (!this.model.isFoldSymbols()) {
            return treeNode;
        }
        Model model = this.model;
        model.getClass();
        TreeNode treeNode2 = this.model.add(new TreeNode(model.new Model.FoldUnfold(indi, bl), (Shape)(bl2 ? this.shapePlus : this.shapeMinus), this.padMinusPlus));
        this.model.add(new TreeArc(treeNode, treeNode2, false));
        return treeNode2;
    }

    private static class DescendantsWithFams
    extends Parser {
        private TreeNode origin;
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int[] padNext;
        private int offsetHusband;

        protected DescendantsWithFams(Model model, TreeMetrics treeMetrics) {
            super(model, treeMetrics);
            this.padFams = new int[]{-((int)((double)treeMetrics.pad * 0.4)), this.padIndis[1], this.padIndis[2], this.padIndis[3]};
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], 0};
            this.padNext = new int[]{this.padIndis[0], -this.padIndis[1], 0, 0};
            this.offsetHusband = model.isVertical() ? -(treeMetrics.wIndis + this.shapeMarrs.getBounds().width) / 2 : -(treeMetrics.hIndis + this.shapeMarrs.getBounds().height) / 2;
        }

        public TreeNode align(TreeNode treeNode) {
            treeNode.getPosition().setLocation(this.origin.getPosition());
            return treeNode;
        }

        protected TreeNode parse(Indi indi) {
            TreeNode treeNode = this.model.add(new TreeNode(null, null, null));
            this.origin = this.parse(indi, treeNode, 0);
            return treeNode;
        }

        protected TreeNode parse(Fam fam) {
            TreeNode treeNode = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padIndis));
            Indi[] indiArray = fam.getChildren();
            for (int i = 0; i < indiArray.length; ++i) {
                this.parse(indiArray[i], treeNode, 0);
            }
            this.origin = treeNode;
            return treeNode;
        }

        private TreeNode parse(Indi indi, TreeNode treeNode, int n) {
            TreeNode treeNode2;
            Fam[] famArray = indi.getFamiliesWhereSpouse();
            if (famArray.length == 0) {
                TreeNode treeNode3 = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
                this.model.add(new TreeArc(treeNode, treeNode3, treeNode.getShape() != null));
                return treeNode3;
            }
            Fam fam = this.model.getFamily(indi, famArray, false);
            TreeNode treeNode4 = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padHusband){

                public int getLongitude(Node node, Branch[] branchArray, Orientation orientation) {
                    return super.getLongitude(node, branchArray, orientation) + DescendantsWithFams.this.offsetHusband;
                }
            });
            this.model.add(new TreeArc(treeNode, treeNode4, treeNode.getShape() != null));
            TreeNode treeNode5 = this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, null));
            this.model.add(new TreeArc(treeNode, treeNode5, false));
            TreeNode treeNode6 = this.model.add(new TreeNode(fam.getOtherSpouse(indi), (Shape)this.shapeIndis, this.padWife));
            this.model.add(new TreeArc(treeNode, treeNode6, false));
            if (famArray.length > 1 && this.model.isFoldSymbols()) {
                Model model = this.model;
                model.getClass();
                treeNode2 = this.model.add(new TreeNode(model.new Model.NextFamily(indi, famArray), (Shape)this.shapeNext, this.padNext));
                this.model.add(new TreeArc(treeNode, treeNode2, false));
            }
            treeNode2 = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            this.model.add(new TreeArc(treeNode4, treeNode2, false));
            Indi[] indiArray = fam.getChildren();
            for (int i = 0; i < indiArray.length; ++i) {
                if (i == 0) {
                    if (n > 20 || this.model.isHideDescendants(indi)) {
                        this.insertPlusMinus(indi, treeNode2, false, true);
                        break;
                    }
                    treeNode2 = this.insertPlusMinus(indi, treeNode2, false, false);
                }
                this.parse(indiArray[i], treeNode2, n + 1);
            }
            return treeNode4;
        }
    }

    private static class DescendantsNoFams
    extends Parser {
        protected DescendantsNoFams(Model model, TreeMetrics treeMetrics) {
            super(model, treeMetrics);
        }

        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int n) {
            TreeNode treeNode = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam[] famArray = indi.getFamiliesWhereSpouse();
            TreeNode treeNode2 = treeNode;
            ArrayList<Indi> arrayList = new ArrayList<Indi>(famArray.length);
            block0: for (int i = 0; i < famArray.length; ++i) {
                Indi[] indiArray = famArray[i].getChildren();
                for (int j = 0; j < indiArray.length; ++j) {
                    if (arrayList.contains(indiArray[j])) continue;
                    arrayList.add(indiArray[j]);
                    if (treeNode.getArcs().isEmpty()) {
                        if (n > 20 || this.model.isHideDescendants(indi)) {
                            this.insertPlusMinus(indi, treeNode, false, true);
                            continue block0;
                        }
                        treeNode2 = this.insertPlusMinus(indi, treeNode, false, false);
                    }
                    this.model.add(new TreeArc(treeNode2, this.parse(indiArray[j], n + 1), true));
                }
            }
            return treeNode;
        }

        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }
    }

    private static class AncestorsWithFams
    extends Parser {
        private int[] padFams;
        private int[] padHusband;
        private int[] padWife;
        private int offsetSpouse;

        protected AncestorsWithFams(Model model, TreeMetrics treeMetrics) {
            super(model, treeMetrics);
            this.padFams = new int[]{this.padIndis[0], this.padIndis[1], this.padIndis[2], -((int)((double)treeMetrics.pad * 0.4))};
            this.padHusband = new int[]{this.padIndis[0], this.padIndis[1], 0, this.padIndis[3]};
            this.padWife = new int[]{this.padIndis[0], 0, this.padIndis[2], this.padIndis[3]};
            this.offsetSpouse = (model.isVertical() ? treeMetrics.wIndis : treeMetrics.hIndis) / 2;
        }

        protected TreeNode parse(Fam fam) {
            return this.parse(fam, 0);
        }

        private TreeNode parse(Fam fam, int n) {
            TreeNode treeNode = this.model.add(new TreeNode(fam, (Shape)this.shapeFams, this.padFams));
            Indi indi = fam.getWife();
            Indi indi2 = fam.getHusband();
            TreeNode treeNode2 = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padHusband));
            this.model.add(new TreeArc(treeNode, this.parse(indi, treeNode2, this.hasParents(indi2) ? -this.offsetSpouse : 0, n + 1), false));
            TreeNode treeNode3 = this.model.add(new TreeNode(null, (Shape)this.shapeMarrs, null));
            this.model.add(new TreeArc(treeNode, treeNode3, false));
            TreeNode treeNode4 = this.model.add(new TreeNode(indi2, (Shape)this.shapeIndis, this.padWife));
            this.model.add(new TreeArc(treeNode, this.parse(indi2, treeNode4, this.hasParents(indi) ? this.offsetSpouse : 0, n + 1), false));
            return treeNode;
        }

        protected TreeNode parse(Indi indi) {
            return this.parse(indi, this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis)), 0, 0);
        }

        private TreeNode parse(Indi indi, TreeNode treeNode, int n, int n2) {
            if (indi == null) {
                return treeNode;
            }
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam != null) {
                if (n2 > 20 || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, treeNode, true, true);
                } else {
                    TreeNode treeNode2 = this.insertPlusMinus(indi, treeNode, true, false);
                    this.model.add(new TreeArc(treeNode2, this.parse(fam, n2), true));
                    treeNode2.align = n;
                }
            }
            return treeNode;
        }

        private boolean hasParents(Indi indi) {
            if (indi == null) {
                return false;
            }
            if (this.model.isHideAncestors(indi)) {
                return false;
            }
            return indi.getFamiliesWhereChild() != null;
        }
    }

    private static class AncestorsNoFams
    extends Parser {
        protected AncestorsNoFams(Model model, TreeMetrics treeMetrics) {
            super(model, treeMetrics);
        }

        protected TreeNode parse(Fam fam) {
            throw new IllegalArgumentException();
        }

        protected TreeNode parse(Indi indi) {
            return this.parse(indi, 0);
        }

        private TreeNode parse(Indi indi, int n) {
            TreeNode treeNode = this.model.add(new TreeNode(indi, (Shape)this.shapeIndis, this.padIndis));
            Fam fam = indi.getFamilyWhereBiologicalChild();
            if (fam != null) {
                if (n > 20 || this.model.isHideAncestors(indi)) {
                    this.insertPlusMinus(indi, treeNode, true, true);
                } else {
                    TreeNode treeNode2 = this.insertPlusMinus(indi, treeNode, true, false);
                    Indi indi2 = fam.getWife();
                    Indi indi3 = fam.getHusband();
                    if (indi2 != null) {
                        this.model.add(new TreeArc(treeNode2, this.parse(indi2, n + 1), true));
                    }
                    if (indi3 != null) {
                        this.model.add(new TreeArc(treeNode2, this.parse(indi3, n + 1), true));
                    }
                }
            }
            return treeNode;
        }
    }
}

