/*
 * Decompiled with CFR 0.152.
 */
package genj.tree;

import genj.common.SelectEntityWidget;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.print.PrintAction;
import genj.print.PrintRenderer;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRenderer;
import genj.renderer.ChooseBlueprintAction;
import genj.renderer.DPI;
import genj.renderer.Options;
import genj.renderer.RenderSelectionHintKey;
import genj.tree.Bookmark;
import genj.tree.ContentRenderer;
import genj.tree.Images;
import genj.tree.Model;
import genj.tree.ModelListener;
import genj.tree.TreeMetrics;
import genj.tree.TreeNode;
import genj.tree.TreeViewPrinter;
import genj.tree.TreeViewSettings;
import genj.util.Registry;
import genj.util.Resources;
import genj.util.swing.Action2;
import genj.util.swing.ButtonHelper;
import genj.util.swing.DialogHelper;
import genj.util.swing.ImageIcon;
import genj.util.swing.PopupWidget;
import genj.util.swing.ScrollPaneWidget;
import genj.util.swing.SliderWidget;
import genj.util.swing.UnitGraphics;
import genj.util.swing.ViewPortAdapter;
import genj.util.swing.ViewPortOverview;
import genj.view.ActionProvider;
import genj.view.ContextProvider;
import genj.view.ScreenshotAction;
import genj.view.SelectionSink;
import genj.view.SettingsAction;
import genj.view.ToolBar;
import genj.view.View;
import genj.view.ViewContext;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeView
extends View
implements ContextProvider,
ActionProvider {
    protected static final ImageIcon BOOKMARK_ICON = new ImageIcon(TreeView.class, "images/Bookmark");
    protected static final Registry REGISTRY = Registry.get(TreeView.class);
    protected static final Resources RESOURCES = Resources.get(TreeView.class);
    protected static final String TITLE = RESOURCES.getString("title");
    private final Point2D DPMM;
    private Model model;
    private Content content;
    private Overview overview;
    private ContentRenderer contentRenderer;
    private double zoom = 1.0;
    private SliderWidget sliderZoom;
    private boolean isAntialiasing = false;
    private Map<String, Color> colors = new HashMap<String, Color>();
    private Map<String, String> tag2blueprint = new HashMap<String, String>();
    private Map<String, BlueprintRenderer> tag2renderer = new HashMap<String, BlueprintRenderer>();
    private Font contentFont = new Font("SansSerif", 0, 10);
    private Point2D.Double center = new Point2D.Double(0.0, 0.0);
    private Context context = new Context();
    private boolean ignoreContextChange = false;

    public TreeView() {
        Object object;
        DPI dPI = Options.getInstance().getDPI();
        this.DPMM = new Point2D.Float((float)dPI.horizontal() / 2.54f / 10.0f, (float)dPI.vertical() / 2.54f / 10.0f);
        this.colors.put("background", Color.WHITE);
        this.colors.put("indis", Color.BLACK);
        this.colors.put("fams", Color.DARK_GRAY);
        this.colors.put("arcs", Color.BLUE);
        this.colors.put("selects", Color.RED);
        this.colors = REGISTRY.get("color", this.colors);
        this.contentFont = REGISTRY.get("font", this.contentFont);
        for (int i = 0; i < Gedcom.ENTITIES.length; ++i) {
            object = Gedcom.ENTITIES[i];
            this.tag2blueprint.put((String)object, REGISTRY.get("blueprint." + (String)object, ""));
        }
        this.model = new Model();
        this.model.setVertical(REGISTRY.get("vertical", true));
        this.model.setFamilies(REGISTRY.get("families", true));
        this.model.setBendArcs(REGISTRY.get("bend", true));
        this.model.setMarrSymbols(REGISTRY.get("marrs", true));
        TreeMetrics treeMetrics = this.model.getMetrics();
        this.model.setMetrics(new TreeMetrics(REGISTRY.get("windis", treeMetrics.wIndis), REGISTRY.get("hindis", treeMetrics.hIndis), REGISTRY.get("wfams", treeMetrics.wFams), REGISTRY.get("hfams", treeMetrics.hFams), REGISTRY.get("pad", treeMetrics.pad)));
        this.isAntialiasing = REGISTRY.get("antial", false);
        this.model.setHideAncestorsIDs(REGISTRY.get("hide.ancestors", new ArrayList<String>()));
        this.model.setHideDescendantsIDs(REGISTRY.get("hide.descendants", new ArrayList<String>()));
        this.contentRenderer = new ContentRenderer();
        this.content = new Content();
        object = new ScrollPaneWidget(new ViewPortAdapter(this.content));
        this.overview = new Overview((JScrollPane)object);
        this.overview.setVisible(REGISTRY.get("overview", true));
        this.overview.setSize(REGISTRY.get("overview", new Dimension(64, 64)));
        this.zoom = Math.max(0.1, Math.min(1.0, (double)REGISTRY.get("zoom", 1.0f)));
        this.add(this.overview);
        this.add((Component)object);
    }

    @Override
    public void removeNotify() {
        REGISTRY.put("overview", this.overview.isVisible());
        REGISTRY.put("overview", this.overview.getSize());
        REGISTRY.put("zoom", (float)this.zoom);
        REGISTRY.put("vertical", this.model.isVertical());
        REGISTRY.put("families", this.model.isFamilies());
        REGISTRY.put("bend", this.model.isBendArcs());
        REGISTRY.put("marrs", this.model.isMarrSymbols());
        TreeMetrics treeMetrics = this.model.getMetrics();
        REGISTRY.put("windis", treeMetrics.wIndis);
        REGISTRY.put("hindis", treeMetrics.hIndis);
        REGISTRY.put("wfams", treeMetrics.wFams);
        REGISTRY.put("hfams", treeMetrics.hFams);
        REGISTRY.put("pad", treeMetrics.pad);
        REGISTRY.put("antial", this.isAntialiasing);
        REGISTRY.put("font", this.contentFont);
        REGISTRY.put("color", this.colors);
        for (String string : this.tag2blueprint.keySet()) {
            REGISTRY.put("blueprint." + string, this.getBlueprint(string).getName());
        }
        if (this.model.getRoot() != null) {
            REGISTRY.put("root", this.model.getRoot().getId());
        }
        REGISTRY.put("hide.ancestors", this.model.getHideAncestorsIDs());
        REGISTRY.put("hide.descendants", this.model.getHideDescendantsIDs());
        super.removeNotify();
    }

    @Override
    public ViewContext getContext() {
        return this.content.getContext();
    }

    @Override
    public void doLayout() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this.overview) continue;
            componentArray[i].setBounds(0, 0, n, n2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(480, 480);
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        return !this.overview.isVisible();
    }

    public boolean isAntialising() {
        return this.isAntialiasing;
    }

    public void setAntialiasing(boolean bl) {
        if (this.isAntialiasing == bl) {
            return;
        }
        this.isAntialiasing = bl;
        this.repaint();
    }

    public Font getContentFont() {
        return this.contentFont;
    }

    public void setContentFont(Font font) {
        if (font == null || this.contentFont.equals(font)) {
            return;
        }
        this.contentFont = font;
        this.repaint();
    }

    public void setColors(Map<String, Color> map) {
        for (String string : this.colors.keySet()) {
            Color color = map.get(string);
            if (color == null) continue;
            this.colors.put(string, color);
        }
        this.repaint();
    }

    public Map<String, Color> getColors() {
        return Collections.unmodifiableMap(this.colors);
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public void setContext(Context context, boolean bl) {
        if (this.ignoreContextChange) {
            return;
        }
        this.context = new Context(context.getGedcom(), context.getEntities());
        if (bl || this.context.getGedcom() == null) {
            this.setRoot(this.context.getEntity());
            return;
        }
        if (this.context.getEntity() == null) {
            return;
        }
        if (!this.show(this.context.getEntity())) {
            this.setRoot(this.context.getEntity());
        }
    }

    boolean show(Entity entity) {
        if (!(entity instanceof Indi) && !(entity instanceof Fam)) {
            return true;
        }
        TreeNode treeNode = this.model.getNode(entity);
        if (treeNode == null) {
            return false;
        }
        this.scrollTo(treeNode.pos);
        this.content.repaint();
        this.overview.repaint();
        return true;
    }

    private void scrollTo(Point point) {
        this.center.setLocation(point);
        Rectangle rectangle = this.model.getBounds();
        Dimension dimension = this.getSize();
        this.content.scrollRectToVisible(new Rectangle((int)((point.getX() - rectangle.getMinX()) * (this.DPMM.getX() * this.zoom)) - dimension.width / 2, (int)((point.getY() - rectangle.getMinY()) * (this.DPMM.getY() * this.zoom)) - dimension.height / 2, dimension.width, dimension.height));
    }

    private void scrollToCurrent() {
        Entity entity = this.context.getEntity();
        if (entity == null) {
            return;
        }
        TreeNode treeNode = this.model.getNode(entity);
        if (treeNode == null) {
            return;
        }
        this.scrollTo(treeNode.pos);
    }

    private void setZoom(double d) {
        this.zoom = Math.max(0.1, Math.min(1.0, d));
        this.content.invalidate();
        this.validate();
        this.scrollToCurrent();
        this.repaint();
    }

    @Override
    public void populate(ToolBar toolBar) {
        this.sliderZoom = new SliderWidget(1, 100, (int)(this.zoom * 100.0));
        this.sliderZoom.addChangeListener(new ZoomGlue());
        this.sliderZoom.setAlignmentX(0.0f);
        this.sliderZoom.setOpaque(false);
        this.sliderZoom.setFocusable(false);
        toolBar.add(this.sliderZoom);
        ButtonHelper buttonHelper = new ButtonHelper();
        toolBar.add(buttonHelper.create(new ActionOverview(), null, this.overview.isVisible()));
        toolBar.addSeparator();
        toolBar.add(buttonHelper.create(new ActionOrientation(), Images.imgVert, this.model.isVertical()));
        toolBar.add(buttonHelper.create(new ActionFamsAndSpouses(), Images.imgDoFams, this.model.isFamilies()));
        toolBar.add(buttonHelper.create(new ActionFoldSymbols(), null, this.model.isFoldSymbols()));
        toolBar.addSeparator();
        PopupWidget popupWidget = new PopupWidget("", BOOKMARK_ICON){

            public void showPopup() {
                this.removeItems();
                for (Bookmark bookmark : TreeView.this.model.getBookmarks()) {
                    this.addItem(new ActionGoto(bookmark));
                }
                super.showPopup();
            }
        };
        popupWidget.setToolTipText(RESOURCES.getString("bookmark.tip"));
        popupWidget.setOpaque(false);
        toolBar.add(popupWidget);
        toolBar.add(new Settings());
        toolBar.add(new ScreenshotAction(this.content));
        toolBar.add(new Print());
    }

    @Override
    public void createActions(Context context, ActionProvider.Purpose purpose, Action2.Group group) {
        Entity entity;
        if (context instanceof TreeContext) {
            return;
        }
        if (purpose == ActionProvider.Purpose.CONTEXT && context.getEntities().size() == 1 && ((entity = context.getEntity()) instanceof Indi || entity instanceof Fam)) {
            group.add(new ActionRoot(entity, true));
            group.add(new ActionBookmark(entity, false));
        }
    }

    public void setRoot(Entity entity) {
        Gedcom gedcom;
        Entity entity2 = this.model.getRoot();
        if (entity2 != null) {
            gedcom = entity2.getGedcom();
            REGISTRY.put(gedcom.getName() + ".bookmarks", this.model.getBookmarks());
        }
        if (entity == null || entity instanceof Indi || entity instanceof Fam) {
            this.model.setRoot(entity);
        }
        if (entity != null) {
            gedcom = entity.getGedcom();
            ArrayList<Bookmark> arrayList = new ArrayList<Bookmark>();
            for (String string : REGISTRY.get(gedcom.getName() + ".bookmarks", new String[0])) {
                try {
                    arrayList.add(new Bookmark(gedcom, string));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.model.setBookmarks(arrayList);
        }
    }

    private Point view2model(Point point) {
        Rectangle rectangle = this.model.getBounds();
        return new Point((int)Math.rint((double)point.x / (this.DPMM.getX() * this.zoom) + rectangle.getMinX()), (int)Math.rint((double)point.y / (this.DPMM.getY() * this.zoom) + rectangle.getMinY()));
    }

    Blueprint getBlueprint(String string) {
        return BlueprintManager.getInstance().getBlueprint(string, this.tag2blueprint.get(string));
    }

    private BlueprintRenderer getEntityRenderer(String string) {
        BlueprintRenderer blueprintRenderer = this.tag2renderer.get(string);
        if (blueprintRenderer == null) {
            blueprintRenderer = new BlueprintRenderer(this.getBlueprint(string));
            this.tag2renderer.put(string, blueprintRenderer);
        }
        return blueprintRenderer;
    }

    private class Print
    extends PrintAction {
        public boolean yes;

        protected Print() {
            super(TITLE);
        }

        protected PrintRenderer getRenderer() {
            return new TreeViewPrinter(TreeView.this);
        }
    }

    private class TreeContext
    extends ViewContext {
        public TreeContext(Context context) {
            super(context);
        }
    }

    private class Settings
    extends SettingsAction {
        private Settings() {
        }

        protected TreeViewSettings getEditor() {
            return new TreeViewSettings(TreeView.this);
        }
    }

    private class ActionBookmark
    extends Action2 {
        private Entity entity;

        private ActionBookmark(Entity entity, boolean bl) {
            this.entity = entity;
            this.setImage(BOOKMARK_ICON);
            if (bl) {
                this.setText(RESOURCES, "bookmark.add");
            } else {
                this.setText(RESOURCES.getString("bookmark.in", TITLE));
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = "";
            if (this.entity instanceof Indi) {
                string = ((Indi)this.entity).getName();
            }
            if (this.entity instanceof Fam) {
                Indi indi = ((Fam)this.entity).getHusband();
                Indi indi2 = ((Fam)this.entity).getWife();
                if (indi != null && indi2 != null) {
                    string = indi.getName() + " & " + indi2.getName();
                }
            }
            if ((string = DialogHelper.openDialog(TITLE, 3, RESOURCES.getString("bookmark.name"), string, (Object)TreeView.this)) == null) {
                return;
            }
            TreeView.this.model.addBookmark(new Bookmark(string, this.entity));
        }
    }

    private class ActionGoto
    extends Action2 {
        private Bookmark bookmark;

        private ActionGoto(Bookmark bookmark) {
            this.bookmark = bookmark;
            this.setText(bookmark.getName());
            this.setImage(Gedcom.getEntityImage(bookmark.getEntity().getTag()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectionSink.Dispatcher.fireSelection(TreeView.this, new Context(this.bookmark.getEntity()), false);
        }
    }

    private class ActionChooseRoot
    extends Action2 {
        private ActionChooseRoot() {
            this.setText(RESOURCES, "select.root");
            this.setImage(Images.imgView);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SelectEntityWidget selectEntityWidget = new SelectEntityWidget(TreeView.this.context.getGedcom(), "INDI", null);
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add("North", selectEntityWidget);
            int n = DialogHelper.openDialog(this.getText(), 3, jPanel, (Action[])Action2.okCancel(), (Object)TreeView.this);
            if (n == 0) {
                TreeView.this.setRoot(selectEntityWidget.getSelection());
            }
        }
    }

    private class ActionFoldSymbols
    extends Action2 {
        private ActionFoldSymbols() {
            super.setImage(Images.imgFoldSymbols);
            super.setTip(RESOURCES, "foldsymbols.tip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeView.this.model.setFoldSymbols(!TreeView.this.model.isFoldSymbols());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionFamsAndSpouses
    extends Action2 {
        private ActionFamsAndSpouses() {
            super.setImage(Images.imgDontFams);
            super.setTip(RESOURCES, "families.tip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeView.this.model.setFamilies(!TreeView.this.model.isFamilies());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionOrientation
    extends Action2 {
        private ActionOrientation() {
            super.setImage(Images.imgHori);
            super.setTip(RESOURCES, "orientation.tip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeView.this.model.setVertical(!TreeView.this.model.isVertical());
            TreeView.this.scrollToCurrent();
        }
    }

    private class ActionRoot
    extends Action2 {
        private Entity root;

        private ActionRoot(Entity entity, boolean bl) {
            this.root = entity;
            this.setText(RESOURCES.getString(bl ? "root.in" : "root", TITLE));
            this.setImage(Images.imgView);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeView.this.setRoot(this.root);
        }
    }

    private class ActionOverview
    extends Action2 {
        private ActionOverview() {
            this.setImage(Images.imgOverview);
            this.setTip(RESOURCES, "overview.tip");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TreeView.this.overview.setVisible(!TreeView.this.overview.isVisible());
        }
    }

    private class ZoomGlue
    implements ChangeListener {
        private ZoomGlue() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            TreeView.this.setZoom((double)TreeView.this.sliderZoom.getValue() * 0.01);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Content
    extends JComponent
    implements ModelListener,
    MouseWheelListener,
    MouseListener,
    ContextProvider {
        private Content() {
            this.addMouseListener(this);
            this.addMouseWheelListener(this);
            new Up().install(this, "U", 0);
        }

        @Override
        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
        }

        @Override
        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (mouseWheelEvent.isControlDown()) {
                TreeView.this.sliderZoom.setValue(TreeView.this.sliderZoom.getValue() - mouseWheelEvent.getWheelRotation() * 10);
                return;
            }
            JViewport jViewport = (JViewport)this.getParent().getParent();
            Rectangle rectangle = jViewport.getVisibleRect();
            if (mouseWheelEvent.isShiftDown()) {
                rectangle.x += mouseWheelEvent.getWheelRotation() * 16;
            } else {
                rectangle.y += mouseWheelEvent.getWheelRotation() * 16;
            }
            jViewport.scrollRectToVisible(rectangle);
        }

        @Override
        public ViewContext getContext() {
            TreeContext treeContext = new TreeContext(TreeView.this.context);
            Entity entity = TreeView.this.context.getEntity();
            if (entity instanceof Indi) {
                treeContext.addAction(new ActionBookmark((Indi)TreeView.this.context.getEntity(), true));
                treeContext.addAction(new ActionRoot((Indi)TreeView.this.context.getEntity(), false));
            }
            if (entity != null) {
                treeContext.addAction(new ChooseBlueprintAction(entity, TreeView.this.getBlueprint(entity.getTag())){

                    protected void commit(Entity entity, Blueprint blueprint) {
                        TreeView.this.tag2blueprint.put(entity.getTag(), blueprint.getName());
                        TreeView.this.tag2renderer.remove(entity.getTag());
                        Content.this.repaint();
                    }
                });
            }
            treeContext.addAction(new ActionChooseRoot());
            return treeContext;
        }

        @Override
        public void structureChanged(Model model) {
            this.invalidate();
            TreeView.this.validate();
            this.repaint();
            TreeView.this.scrollToCurrent();
        }

        @Override
        public void nodesChanged(Model model, Collection<TreeNode> collection) {
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            Rectangle rectangle = TreeView.this.model.getBounds();
            double d = ((RectangularShape)rectangle).getWidth() * (TreeView.this.DPMM.getX() * TreeView.this.zoom);
            double d2 = ((RectangularShape)rectangle).getHeight() * (TreeView.this.DPMM.getY() * TreeView.this.zoom);
            return new Dimension((int)d, (int)d2);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.setColor((Color)TreeView.this.colors.get("background"));
            Rectangle rectangle = graphics.getClipBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            UnitGraphics unitGraphics = new UnitGraphics(graphics, TreeView.this.DPMM.getX() * TreeView.this.zoom, TreeView.this.DPMM.getY() * TreeView.this.zoom);
            unitGraphics.setAntialiasing(TreeView.this.isAntialiasing);
            Boolean bl = (Boolean)((Graphics2D)graphics).getRenderingHint(RenderSelectionHintKey.KEY);
            if (bl == null) {
                bl = true;
            }
            ((TreeView)TreeView.this).contentRenderer.font = TreeView.this.contentFont;
            ((TreeView)TreeView.this).contentRenderer.cIndiShape = (Color)TreeView.this.colors.get("indis");
            ((TreeView)TreeView.this).contentRenderer.cFamShape = (Color)TreeView.this.colors.get("fams");
            ((TreeView)TreeView.this).contentRenderer.cArcs = (Color)TreeView.this.colors.get("arcs");
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = (Color)TreeView.this.colors.get("selects");
            ((TreeView)TreeView.this).contentRenderer.selected = bl != false ? TreeView.this.context.getEntities() : new ArrayList();
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = TreeView.this.getEntityRenderer("INDI");
            ((TreeView)TreeView.this).contentRenderer.famRenderer = TreeView.this.getEntityRenderer("FAM");
            TreeView.this.contentRenderer.render(unitGraphics, TreeView.this.model);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.requestFocusInWindow();
            Point point = TreeView.this.view2model(mouseEvent.getPoint());
            Object object = TreeView.this.model.getContentAt(point.x, point.y);
            if (object == null) {
                this.repaint();
                TreeView.this.overview.repaint();
                return;
            }
            if (object instanceof Entity) {
                Entity entity = (Entity)object;
                if ((mouseEvent.getModifiers() & 0x80) != 0) {
                    ArrayList<? extends Entity> arrayList = new ArrayList<Entity>(TreeView.this.context.getEntities());
                    if (arrayList.contains(entity)) {
                        arrayList.remove(entity);
                    } else {
                        arrayList.add(entity);
                    }
                } else {
                    TreeView.this.context = new Context(entity);
                }
                this.repaint();
                TreeView.this.overview.repaint();
                try {
                    TreeView.this.ignoreContextChange = true;
                    SelectionSink.Dispatcher.fireSelection(mouseEvent, TreeView.this.context);
                }
                finally {
                    TreeView.this.ignoreContextChange = false;
                }
                return;
            }
            if (object instanceof Runnable) {
                ((Runnable)object).run();
                return;
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private class Up
        extends Action2 {
            private Up() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("up");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Overview
    extends ViewPortOverview
    implements ModelListener {
        private Overview(JScrollPane jScrollPane) {
            super(jScrollPane.getViewport());
            super.setSize(new Dimension(TreeView.this.getWidth() / 4, TreeView.this.getHeight() / 4));
        }

        @Override
        public void addNotify() {
            super.addNotify();
            TreeView.this.model.addListener(this);
        }

        @Override
        public void removeNotify() {
            TreeView.this.model.removeListener(this);
            super.removeNotify();
        }

        @Override
        public void setSize(int n, int n2) {
            n = Math.max(32, n);
            n2 = Math.max(32, n2);
            super.setSize(n, n2);
        }

        @Override
        protected void renderContent(Graphics graphics, double d, double d2) {
            graphics.setColor(Color.WHITE);
            Rectangle rectangle = graphics.getClipBounds();
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            UnitGraphics unitGraphics = new UnitGraphics(graphics, TreeView.this.DPMM.getX() * d * TreeView.this.zoom, TreeView.this.DPMM.getY() * d2 * TreeView.this.zoom);
            ((TreeView)TreeView.this).contentRenderer.cIndiShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cFamShape = Color.BLACK;
            ((TreeView)TreeView.this).contentRenderer.cArcs = Color.LIGHT_GRAY;
            ((TreeView)TreeView.this).contentRenderer.cSelectedShape = Color.RED;
            ((TreeView)TreeView.this).contentRenderer.selected = TreeView.this.context.getEntities();
            ((TreeView)TreeView.this).contentRenderer.indiRenderer = null;
            ((TreeView)TreeView.this).contentRenderer.famRenderer = null;
            TreeView.this.contentRenderer.render(unitGraphics, TreeView.this.model);
            unitGraphics.popTransformation();
        }

        @Override
        public void nodesChanged(Model model, Collection<TreeNode> collection) {
            this.repaint();
        }

        @Override
        public void structureChanged(Model model) {
            this.repaint();
        }
    }
}

