/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class Base64 {
    public static byte decode(char c) throws IllegalArgumentException {
        if (c >= 'A' && c <= 'Z') {
            return (byte)(c - 65);
        }
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 26);
        }
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48 + 52);
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        throw new IllegalArgumentException("Illegal Base64 byte (" + c + ")");
    }

    public static byte[] decode(String string) throws IllegalArgumentException {
        if (string.length() % 4 != 0 || string.length() == 0) {
            throw new IllegalArgumentException("Illegal Base64 String");
        }
        int n = 0;
        int n2 = string.length() - 1;
        while (string.charAt(n2) == '=') {
            ++n;
            --n2;
        }
        n2 = string.length() * 3 / 4 - n;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < string.length(); i += 4) {
            int n4 = (Base64.decode(string.charAt(i + 0)) << 18) + (Base64.decode(string.charAt(i + 1)) << 12) + (Base64.decode(string.charAt(i + 2)) << 6) + Base64.decode(string.charAt(i + 3));
            for (int j = 0; j < 3 && n3 + j < byArray.length; ++j) {
                byArray[n3 + j] = (byte)(n4 >> 8 * (2 - j) & 0xFF);
            }
            n3 += 3;
        }
        return byArray;
    }

    public static String encode(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer((byArray.length + 1) * 4 / 3);
        for (int i = 0; i < byArray.length; i += 3) {
            stringBuffer.append(Base64.encodeBlock(byArray, i));
        }
        return stringBuffer.toString();
    }

    public static char encode(int n) {
        if (n >= 0 && n <= 25) {
            return (char)(65 + n);
        }
        if (n >= 26 && n <= 51) {
            return (char)(97 + (n - 26));
        }
        if (n >= 52 && n <= 61) {
            return (char)(48 + (n - 52));
        }
        if (n == 62) {
            return '+';
        }
        if (n == 63) {
            return '/';
        }
        return '?';
    }

    private static char[] encodeBlock(byte[] byArray, int n) {
        int n2;
        int n3 = 0;
        int n4 = byArray.length - n - 1;
        int n5 = n4 >= 2 ? 2 : n4;
        for (int i = 0; i <= n5; ++i) {
            n2 = byArray[n + i];
            n3 += (n2 < 0 ? n2 + 256 : n2) << 8 * (2 - i);
        }
        char[] cArray = new char[4];
        for (n2 = 0; n2 < 4; ++n2) {
            int n6 = n3 >>> 6 * (3 - n2) & 0x3F;
            cArray[n2] = Base64.encode(n6);
        }
        if (n4 < 1) {
            cArray[2] = 61;
        }
        if (n4 < 2) {
            cArray[3] = 61;
        }
        return cArray;
    }
}

