/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ChangeSupport
implements DocumentListener,
ChangeListener,
ActionListener {
    private List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private Object source;
    private boolean hasChanged = false;
    private boolean mute = false;

    public ChangeSupport(Object object) {
        this.source = object;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public void setChanged(boolean bl) {
        this.hasChanged = bl;
        if (bl) {
            this.fireChangeEvent();
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listeners.isEmpty()) {
            this.hasChanged = false;
        }
        this.listeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(changeListener);
    }

    public void removeAllChangeListeners() {
        this.listeners.clear();
    }

    public void fireChangeEvent() {
        this.fireChangeEvent(this.source);
    }

    public final void fireChangeEvent(Object object) {
        this.fireChangeEvent(new ChangeEvent(object));
    }

    public void fireChangeEvent(ChangeEvent changeEvent) {
        this.hasChanged = true;
        if (!this.mute) {
            for (ChangeListener changeListener : this.listeners) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent(changeEvent);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.fireChangeEvent();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.fireChangeEvent();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.fireChangeEvent(actionEvent.getSource());
    }

    public void mute() {
        this.mute = true;
    }

    public void unmute() {
        this.mute = false;
    }
}

