/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SafeProxy {
    public static <T> T unwrap(T t) {
        try {
            return (T)((SafeHandler)Proxy.getInvocationHandler(t)).impl;
        }
        catch (Throwable throwable) {
            throw new IllegalArgumentException("not wrapped");
        }
    }

    public static <T> T harden(T t) {
        return SafeProxy.harden(t, Logger.getAnonymousLogger());
    }

    public static <T> List<T> harden(List<T> list, Logger logger) {
        ListIterator<T> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(SafeProxy.harden(listIterator.next(), logger));
        }
        return list;
    }

    public static <T> T harden(T t, Logger logger) {
        if (logger == null || t == null) {
            throw new IllegalArgumentException("implementation|logger==null");
        }
        ArrayList arrayList = new ArrayList();
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            for (Class<?> clazz2 : clazz.getInterfaces()) {
                if (!Modifier.isPublic(clazz2.getModifiers()) || arrayList.contains(clazz2)) continue;
                arrayList.add(clazz2);
            }
        }
        return (T)Proxy.newProxyInstance(t.getClass().getClassLoader(), arrayList.toArray(new Class[arrayList.size()]), new SafeHandler(t, logger));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SafeHandler<T>
    implements InvocationHandler {
        private T impl;
        private Logger logger;

        private SafeHandler(T t, Logger logger) {
            this.impl = t;
            this.logger = logger;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Throwable throwable;
            if ("equals".equals(method.getName()) && objectArray.length == 1) {
                try {
                    return this.impl.equals(((SafeHandler)Proxy.getInvocationHandler((Object)objectArray[0])).impl);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return false;
                }
            }
            try {
                return method.invoke(this.impl, objectArray);
            }
            catch (InvocationTargetException invocationTargetException) {
                throwable = invocationTargetException.getCause();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
            }
            this.logger.log(Level.WARNING, "Implementation " + this.impl.getClass().getName() + "." + method.getName() + " threw exception " + throwable.getClass().getName() + "(" + throwable.getMessage() + ")", throwable);
            return null;
        }
    }
}

