/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.ImageIcon;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;

public class ButtonHelper {
    private Class buttonType = JButton.class;
    private Insets insets = null;
    private JComponent container = null;
    private ButtonGroup group = null;
    private int fontSize = -1;

    public ButtonHelper setButtonType(Class clazz) {
        this.buttonType = clazz;
        return this;
    }

    public ButtonHelper setInsets(Insets insets) {
        this.insets = insets;
        return this;
    }

    public ButtonHelper setInsets(int n) {
        this.insets = new Insets(n, n, n, n);
        return this;
    }

    public ButtonHelper setContainer(JComponent jComponent) {
        this.container = jComponent;
        return this;
    }

    public ButtonHelper setFontSize(int n) {
        this.fontSize = n;
        return this;
    }

    public ButtonGroup createGroup() {
        this.group = new ButtonGroup();
        return this.group;
    }

    public AbstractButton create(Action action, ImageIcon imageIcon, boolean bl) {
        JToggleButton jToggleButton = (JToggleButton)this.create(action, JToggleButton.class);
        jToggleButton.setSelectedIcon(imageIcon);
        jToggleButton.setSelected(bl);
        return jToggleButton;
    }

    public AbstractButton create(Action action) {
        return this.create(action, this.buttonType);
    }

    private AbstractButton create(Action action, Class clazz) {
        AbstractButton abstractButton;
        if (this.container instanceof JToolBar) {
            action.putValue("MnemonicKey", null);
        }
        if ((abstractButton = this.createButton(clazz)) instanceof JButton) {
            abstractButton.setVerticalTextPosition(3);
            abstractButton.setHorizontalTextPosition(0);
        }
        abstractButton.setAction(action);
        if (this.insets != null) {
            abstractButton.setMargin(this.insets);
        }
        if (this.fontSize > 0) {
            Font font = abstractButton.getFont();
            abstractButton.setFont(new Font(font.getName(), font.getStyle(), this.fontSize));
        }
        if (this.group != null) {
            this.group.add(abstractButton);
        }
        if (this.container != null) {
            this.container.add(abstractButton);
            if (this.container instanceof JToolBar) {
                abstractButton.setMaximumSize(new Dimension(128, 128));
            }
        }
        return abstractButton;
    }

    private AbstractButton createButton(Class clazz) {
        try {
            return (AbstractButton)clazz.newInstance();
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("Couldn't create AbstractButton for " + this.buttonType);
        }
    }
}

