/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;

public class LinkWidget
extends JLabel {
    private boolean hover = false;
    private Action2 action;
    private Color normal;

    public LinkWidget(Action2 action2) {
        this(action2.getText(), action2.getImage());
        this.setToolTipText(action2.getTip());
        this.action = action2;
    }

    public LinkWidget(String string, Icon icon) {
        super(string, icon, 2);
        this.addMouseListener(new Callback());
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public LinkWidget(ImageIcon imageIcon) {
        this(null, imageIcon);
    }

    public LinkWidget() {
        this(null, null);
    }

    protected void fireActionPerformed() {
        if (this.action != null) {
            this.action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.hover) {
            return;
        }
        graphics.setColor(this.getForeground());
        graphics.drawLine(1, this.getHeight() - 1, this.getWidth() - 1 - 1, this.getHeight() - 1);
    }

    private class Callback
    extends MouseAdapter {
        private Callback() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            LinkWidget.this.fireActionPerformed();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            LinkWidget.this.hover = false;
            LinkWidget.this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            LinkWidget.this.hover = true;
            LinkWidget.this.repaint();
        }
    }
}

