/*
 * Decompiled with CFR 0.152.
 */
package genj.util.swing;

import genj.util.MnemonicAndText;
import genj.util.swing.Action2;
import genj.view.ActionProvider;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuHelper {
    private Stack<JComponent> menus = new Stack();

    public MenuHelper popMenu() {
        this.menus.pop();
        return this;
    }

    public MenuHelper pushMenu(JComponent jComponent) {
        if (!this.menus.isEmpty()) {
            this.menus.peek().add(jComponent);
        }
        this.menus.push(jComponent);
        return this;
    }

    public JMenu createMenu(Action2.Group group) {
        JMenu jMenu = new JMenu(group);
        this.pushMenu(jMenu);
        for (Action2 action2 : group) {
            this.createItem(action2);
        }
        return jMenu;
    }

    public JMenu createMenu(String string) {
        return this.createMenu(string, null);
    }

    public JMenu createMenu(String string, Icon icon) {
        JMenu jMenu = new JMenu();
        if (string != null && string.length() > 0) {
            MnemonicAndText mnemonicAndText = new MnemonicAndText(string);
            jMenu.setText(mnemonicAndText.getText());
            jMenu.setMnemonic(mnemonicAndText.getMnemonic());
        }
        if (icon != null) {
            jMenu.setIcon(icon);
        }
        this.pushMenu(jMenu);
        return jMenu;
    }

    public JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.pushMenu(jPopupMenu);
        return jPopupMenu;
    }

    public void createItems(Iterable<Action2> iterable) {
        if (iterable == null) {
            return;
        }
        boolean bl = true;
        for (Action2 action2 : iterable) {
            if (bl) {
                this.createSeparator();
                bl = false;
            }
            this.createItem(action2);
        }
    }

    public final JMenuItem createItem(Action action) {
        if (action instanceof Action2.Group) {
            Action2.Group group = (Action2.Group)action;
            if (group.size() == 0) {
                return null;
            }
            JMenu jMenu = new JMenu(action);
            if (action instanceof Action2) {
                jMenu.setMnemonic(((Action2)action).getMnemonic());
            }
            this.pushMenu(jMenu);
            this.createItems(group);
            this.popMenu();
            return jMenu;
        }
        if (action instanceof ActionProvider.SeparatorAction) {
            this.createSeparator();
            return null;
        }
        JMenuItem jMenuItem = action.getValue("SwingSelectedKey") != null ? new JCheckBoxMenuItem() : new JMenuItem();
        this.set(action, jMenuItem);
        if (action instanceof Action2) {
            jMenuItem.setMnemonic(((Action2)action).getMnemonic());
        }
        this.menus.peek().add(jMenuItem);
        return jMenuItem;
    }

    protected void set(Action action, JMenuItem jMenuItem) {
        jMenuItem.setAction(action);
    }

    public MenuHelper createSeparator() {
        JComponent jComponent;
        int n;
        JComponent jComponent2 = this.menus.peek();
        if (jComponent2 instanceof JMenu && (n = ((JMenu)(jComponent = (JMenu)jComponent2)).getMenuComponentCount()) > 0 && ((JMenu)jComponent).getMenuComponent(n - 1).getClass() != JPopupMenu.Separator.class) {
            ((JMenu)jComponent).addSeparator();
        }
        if (jComponent2 instanceof JPopupMenu && (n = (jComponent = (JPopupMenu)jComponent2).getComponentCount()) > 0 && jComponent.getComponent(n - 1).getClass() != JPopupMenu.Separator.class) {
            ((JPopupMenu)jComponent).addSeparator();
        }
        return this;
    }
}

