/*
 * Decompiled with CFR 0.152.
 */
package genj.view;

import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.util.swing.Action2;
import genj.util.swing.ImageIcon;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewContext
extends Context
implements Comparable<ViewContext> {
    private List<Action2> actions = new ArrayList<Action2>();
    private ImageIcon img = null;
    private String txt = null;

    public ViewContext(String string, Context context) {
        super(context);
        this.setText(string);
    }

    public ViewContext(String string, ImageIcon imageIcon, Context context) {
        super(context);
        this.setText(string);
        this.setImage(imageIcon);
    }

    public ViewContext(Context context) {
        super(context);
    }

    public ViewContext(Gedcom gedcom, List<Entity> list, List<Property> list2) {
        super(gedcom, list, list2);
    }

    public ViewContext(Gedcom gedcom) {
        super(gedcom);
    }

    public ViewContext(Property property) {
        super(property);
    }

    public ViewContext(Entity entity) {
        super(entity);
    }

    public ViewContext addAction(Action2 action2) {
        this.actions.add(action2);
        return this;
    }

    public ViewContext addActions(Action2.Group group) {
        this.actions.add(group);
        return this;
    }

    public List<Action2> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    public String getText() {
        if (this.txt != null) {
            return this.txt;
        }
        List<? extends Property> list = this.getProperties();
        List<? extends Entity> list2 = this.getEntities();
        if (list.size() == 1) {
            StringBuffer stringBuffer = new StringBuffer();
            Property property = list.get(0);
            stringBuffer.append(property.getPropertyName());
            while (!(property.getParent() instanceof Entity)) {
                if (!((property = property.getParent()) instanceof PropertyEvent)) continue;
                stringBuffer.append("|");
                stringBuffer.append(((PropertyEvent)property).getPropertyDisplayValue("DATE"));
                break;
            }
            stringBuffer.append("|");
            stringBuffer.append(property.getEntity());
            this.txt = stringBuffer.toString();
        } else {
            this.txt = !list.isEmpty() ? Property.getPropertyNames(list, 5) : (list2.size() == 1 ? list2.get(0).toString() : (!list2.isEmpty() ? Entity.getPropertyNames(list2, 5) : this.getGedcom().getName()));
        }
        return this.txt;
    }

    public ViewContext setText(String string) {
        this.txt = string;
        return this;
    }

    public ImageIcon getImage() {
        if (this.img != null) {
            return this.img;
        }
        this.img = this.getProperties().size() == 1 ? this.getProperties().get(0).getImage(false) : (this.getEntities().size() == 1 ? this.getEntities().get(0).getImage(false) : Gedcom.getImage());
        return this.img;
    }

    public ViewContext setImage(ImageIcon imageIcon) {
        this.img = imageIcon;
        return this;
    }

    @Override
    public int compareTo(ViewContext viewContext) {
        if (this.txt == null) {
            return -1;
        }
        if (viewContext.txt == null) {
            return 1;
        }
        return this.txt.compareTo(viewContext.txt);
    }
}

