/*
 * Decompiled with CFR 0.152.
 */
package launcher;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import launcher.ipc.CallHandler;
import launcher.ipc.Client;
import launcher.ipc.Server;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Launcher {
    private static final Logger LOG = Logger.getLogger("launcher");
    private static Manifest manifest;
    private static Method main;
    public static final String MANIFEST = "META-INF/MANIFEST.MF";
    public static final String LAUNCH_CLASSPATH = "Launch-Classpath";
    public static final String LAUNCH_CLASS = "Launch-Class";
    public static final String LAUNCH_PORT = "Launch-Port";
    public static final String LAUNCH_SPLASH = "Launch-Splash";
    private static final Pattern PATTERN_KEY;

    public static void main(String[] stringArray) {
        try {
            Launcher.cd(Launcher.class);
            String[] stringArray2 = Launcher.getLaunchClasspath();
            Launcher.exportClasspath(stringArray2);
            ClassLoader classLoader = Launcher.getClassLoader(stringArray2);
            Thread.currentThread().setContextClassLoader(classLoader);
            Launcher.showSplash();
            Launcher.callMain(stringArray, classLoader);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
        }
        Launcher.hideSplash();
    }

    private static void hideSplash() {
        Splash splash = Splash.instance;
        if (splash != null) {
            splash.dispose();
        }
    }

    private static void showSplash() {
        String string = Launcher.getManifest().getMainAttributes().getValue(LAUNCH_SPLASH);
        if (string == null) {
            return;
        }
        try {
            new Splash(Toolkit.getDefaultToolkit().createImage(Launcher.class.getResource(string)));
        }
        catch (Throwable throwable) {
            System.err.println("Can't read splash image " + string);
            throwable.printStackTrace(System.err);
            return;
        }
    }

    private static void callMain(String[] stringArray, ClassLoader classLoader) throws Exception {
        if (main == null) {
            Class<?> clazz = classLoader.loadClass(Launcher.getLaunchClass());
            main = clazz.getMethod("main", String[].class);
        }
        main.invoke(null, new Object[]{stringArray});
    }

    private static boolean setupIPC(String[] stringArray, final ClassLoader classLoader) {
        final String string = Launcher.getLaunchClass();
        int n = Launcher.getLaunchPort();
        if (n > 0) {
            int n2 = -1;
            try {
                n2 = Preferences.userNodeForPackage(Launcher.class).getInt(string, 0);
                if (n2 > 0 && "OK".equals(new Client().send(n2, Launcher.encode(stringArray)))) {
                    LOG.log(Level.FINE, "sent launch to server on port " + n2);
                    return false;
                }
            }
            catch (Throwable throwable) {
                LOG.log(Level.FINE, "couldn't send launch to server on port " + n2);
            }
            try {
                CallHandler callHandler = new CallHandler(){

                    public String handleCall(String string) {
                        try {
                            Launcher.callMain(Launcher.decode(string), classLoader);
                        }
                        catch (Throwable throwable) {
                            return "ERR";
                        }
                        return "OK";
                    }
                };
                for (int i = 0; i < 10; ++i) {
                    try {
                        new Server(n, callHandler);
                        break;
                    }
                    catch (BindException bindException) {
                        LOG.log(Level.FINE, "couldn't bind server to port " + n);
                        ++n;
                        continue;
                    }
                }
                Preferences.userNodeForPackage(Launcher.class).putInt(string, n);
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    public void run() {
                        Preferences.userNodeForPackage(Launcher.class).putInt(string, 0);
                    }
                }));
            }
            catch (Throwable throwable) {
                LOG.log(Level.WARNING, "cannot become launch server", throwable);
            }
        }
        return true;
    }

    private static String[] decode(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private static String encode(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    private static boolean cd(Class<?> clazz) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)Launcher.getClassURL(clazz).openConnection();
            URL uRL = jarURLConnection.getJarFileURL();
            File file = new File(URLDecoder.decode(uRL.getPath(), "UTF-8"));
            File file2 = file.getParentFile();
            LOG.info(System.getProperty("user.dir"));
            System.setProperty("user.dir", file2.getAbsolutePath());
            LOG.info(System.getProperty("user.dir"));
            return true;
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "couldn't cd into directory with jar containing " + clazz, exception);
            return false;
        }
    }

    private static URL getClassURL(Class<?> clazz) {
        String string = "/" + clazz.getName().replace('.', '/') + ".class";
        return clazz.getResource(string);
    }

    private static int getLaunchPort() {
        try {
            return Integer.parseInt(System.getProperty("launch.port"));
        }
        catch (Throwable throwable) {
            try {
                return Integer.parseInt(Launcher.getManifest().getMainAttributes().getValue(LAUNCH_PORT));
            }
            catch (Throwable throwable2) {
                return 0;
            }
        }
    }

    private static String getLaunchClass() {
        String string = System.getProperty("launch.class");
        if (string == null) {
            string = Launcher.getManifest().getMainAttributes().getValue(LAUNCH_CLASS);
        }
        if (string == null || string.length() == 0) {
            throw new Error("No Launch-Class defined in META-INF/MANIFEST.MF");
        }
        return string;
    }

    private static ClassLoader getClassLoader(String[] stringArray) throws MalformedURLException {
        URL[] uRLArray = new URL[stringArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = new File(stringArray[i]).toURI().toURL();
        }
        return new URLClassLoader(uRLArray);
    }

    private static void exportClasspath(String[] stringArray) {
        String string = System.getProperty("path.separator");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i]);
        }
        System.setProperty("java.class.path", stringBuffer.toString());
    }

    private static String[] getLaunchClasspath() throws MalformedURLException {
        String string = Launcher.expandSystemProperties(Launcher.getManifest().getMainAttributes().getValue(LAUNCH_CLASSPATH));
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            File file = new File(string2).getAbsoluteFile();
            if (!file.exists()) continue;
            Launcher.buildClasspath(file, arrayList);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static void buildClasspath(File file, List<String> list) throws MalformedURLException {
        if (!file.isDirectory() && file.getName().endsWith(".jar")) {
            list.add(file.getAbsolutePath());
            return;
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                Launcher.buildClasspath(fileArray[i], list);
            }
        }
    }

    private static Manifest getManifest() {
        if (manifest != null) {
            return manifest;
        }
        try {
            Stack<URL> stack = new Stack<URL>();
            Object object = Launcher.class.getClassLoader().getResources(MANIFEST);
            while (object.hasMoreElements()) {
                stack.add(object.nextElement());
            }
            while (!stack.isEmpty()) {
                object = (URL)stack.pop();
                InputStream inputStream = ((URL)object).openStream();
                Manifest manifest = new Manifest(inputStream);
                inputStream.close();
                if (manifest.getMainAttributes().getValue(LAUNCH_CLASS) == null) continue;
                Launcher.manifest = manifest;
                return Launcher.manifest;
            }
        }
        catch (Throwable throwable) {
            LOG.log(Level.SEVERE, "error while loading manifest", throwable);
        }
        LOG.warning("no manifest found");
        manifest = new Manifest();
        return manifest;
    }

    private static String expandSystemProperties(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = PATTERN_KEY.matcher(string);
        int n = 0;
        while (matcher.find()) {
            String string2 = string.substring(n, matcher.start());
            String string3 = string.substring(matcher.start() + 2, matcher.end() - 1);
            stringBuffer.append(string2);
            stringBuffer.append(System.getProperty(string3));
            n = matcher.end();
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    static {
        PATTERN_KEY = Pattern.compile("\\$\\{[\\.\\w]*\\}");
    }

    private static class Splash
    extends Window
    implements PropertyChangeListener {
        private static Splash instance;
        private Image image;

        private Splash(Image image) {
            super(new Frame());
            instance = this;
            this.image = image;
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setSize(new Dimension(image.getWidth(null), image.getHeight(null)));
            this.setLocationRelativeTo(null);
            this.setVisible(true);
        }

        public synchronized void dispose() {
            if (instance == null) {
                return;
            }
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this);
            super.dispose();
            instance = null;
        }

        public void setVisible(boolean bl) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener(this);
            super.setVisible(bl);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("activeWindow".equals(propertyChangeEvent.getPropertyName()) && propertyChangeEvent.getNewValue() != this) {
                this.dispose();
            }
        }

        public void paint(Graphics graphics) {
            graphics.drawImage(this.image, 0, 0, this);
        }
    }
}

