/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.control;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.xml.parsers.ParserConfigurationException;
import jgpstrackedit.data.Database;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.gpsies.GPSiesComDialog;
import jgpstrackedit.gpsies.GPSiesSaveDlg;
import jgpstrackedit.map.FourUMapsTileManager;
import jgpstrackedit.map.GoogleMapHybridTileManager;
import jgpstrackedit.map.GoogleMapSatelliteTileManager;
import jgpstrackedit.map.GoogleMapTerrainTileManager;
import jgpstrackedit.map.GoogleMapTileManager;
import jgpstrackedit.map.HikeBikeTileManager;
import jgpstrackedit.map.MapQuestHybrideTileManager;
import jgpstrackedit.map.MapQuestSatTileManager;
import jgpstrackedit.map.MapQuestTileManager;
import jgpstrackedit.map.OCMTileManager;
import jgpstrackedit.map.OSMTileManager;
import jgpstrackedit.map.TileManager;
import jgpstrackedit.map.elevation.ElevationAPI;
import jgpstrackedit.map.elevation.ElevationException;
import jgpstrackedit.map.util.MapExtract;
import jgpstrackedit.map.util.MapExtractManager;
import jgpstrackedit.routing.MapQuestRouting;
import jgpstrackedit.trackfile.TrackFileException;
import jgpstrackedit.trackfile.TrackFileManager;
import jgpstrackedit.trackfile.asc.ASC;
import jgpstrackedit.trackfile.gpxroute.GPXRoute;
import jgpstrackedit.trackfile.gpxtrack.GPXTrack;
import jgpstrackedit.trackfile.kml.KML;
import jgpstrackedit.trackfile.tcx.TCX;
import jgpstrackedit.util.Browser;
import jgpstrackedit.util.DirectoryFilter;
import jgpstrackedit.util.Parser;
import jgpstrackedit.view.DlgCompressOptions;
import jgpstrackedit.view.DlgSelectMapExtract;
import jgpstrackedit.view.JGPSTrackEdit;
import jgpstrackedit.view.Transform;
import org.xml.sax.SAXException;

public class UIController
implements Runnable {
    private Database db;
    private JGPSTrackEdit form;
    private JFileChooser fileSaveChooser;
    private JFileChooser fileOpenChooser;
    private static JFileChooser imageSaveChooser = null;
    private File dirFile = null;
    private boolean googleMapEnabled = false;
    private boolean googleElevationAPIEnabled = false;
    private static UIController instance = null;

    private UIController(Database db, JGPSTrackEdit form) {
        this.db = db;
        this.form = form;
        TrackFileManager.addTrackFile(new GPXRoute());
        TrackFileManager.addTrackFile(new GPXTrack());
        TrackFileManager.addTrackFile(new KML());
        TrackFileManager.addTrackFile(new TCX());
        TrackFileManager.addTrackFile(new ASC());
        this.fileOpenChooser = new JFileChooser();
        this.fileSaveChooser = new JFileChooser();
        for (FileNameExtensionFilter filter : TrackFileManager.getFileNameExtensionFilters()) {
            this.fileSaveChooser.addChoosableFileFilter(filter);
        }
    }

    public static UIController newUIController(Database db, JGPSTrackEdit form) {
        if (instance == null) {
            instance = new UIController(db, form);
        }
        return instance;
    }

    public static UIController getUIController() {
        return instance;
    }

    public static JFileChooser getJFileChooser() {
        if (imageSaveChooser == null) {
            imageSaveChooser = new JFileChooser();
            imageSaveChooser.addChoosableFileFilter(new FileNameExtensionFilter("Image", "png"));
        }
        return imageSaveChooser;
    }

    protected void openTrack(File file) {
        this.form.setStateMessage("Reading file " + file.getAbsolutePath());
        try {
            Track track = TrackFileManager.openTrack(file);
            track.setTrackFileName(file.getAbsolutePath());
            track.setModified(false);
            this.db.addTrack(track);
            this.db.getTrackTableModel().setSelectedTrack(track);
            this.form.getTracksTable().addRowSelectionInterval(this.db.getTrackNumber() - 1, this.db.getTrackNumber() - 1);
            this.form.setSelectedTrack(track);
            this.form.setStateMessage(TrackFileManager.getLastMessage());
            this.zoomSelectedTrack();
            this.form.repaint();
        }
        catch (TrackFileException e) {
            e.printStackTrace();
        }
    }

    public void openTrack() {
        int returnVal = this.fileOpenChooser.showOpenDialog(this.form);
        if (returnVal == 0) {
            File file = this.fileOpenChooser.getSelectedFile();
            this.openTrack(file);
        }
    }

    public void openDirectory() {
        JFileChooser dirOpenChooser = new JFileChooser();
        dirOpenChooser.addChoosableFileFilter(new DirectoryFilter());
        dirOpenChooser.setFileSelectionMode(1);
        int returnVal = dirOpenChooser.showOpenDialog(this.form);
        if (returnVal == 0) {
            this.dirFile = dirOpenChooser.getSelectedFile();
            new Thread(this).start();
        }
    }

    protected void openDirectoryTrackFiles() {
        File[] trackFiles = this.dirFile.listFiles();
        int i = 0;
        while (i < trackFiles.length) {
            if (trackFiles[i].isFile()) {
                this.openTrack(trackFiles[i]);
            }
            ++i;
        }
    }

    public void openTrack(String urlString) {
        this.form.setStateMessage("Loading GPSies track... ");
        Track track = null;
        try {
            URL url = new URL(urlString);
            KML kml = new KML();
            track = kml.openTrack(url);
            track.setModified(false);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.db.addTrack(track);
        this.db.getTrackTableModel().setSelectedTrack(track);
        this.form.getTracksTable().addRowSelectionInterval(this.db.getTrackNumber() - 1, this.db.getTrackNumber() - 1);
        this.form.setSelectedTrack(track);
        this.form.setStateMessage("GPSies track " + track.getName() + " loaded.");
        this.zoomSelectedTrack();
        this.form.repaint();
    }

    public void reverseTrack() {
        int[] selectedRows = this.form.getTracksTable().getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            this.db.reverseTrack(selectedRows[i]);
            this.form.setStateMessage("Track " + this.db.getTracks().get(selectedRows[i]).getName() + " reversed");
            ++i;
        }
    }

    public void delete() {
        int[] selectedRows = this.form.getTracksTable().getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            String name = this.db.getTracks().get(selectedRows[i]).getName();
            this.db.removeTrack(selectedRows[i]);
            this.form.setStateMessage("Track " + name + " deleted.");
            ++i;
        }
    }

    public void saveSelected() {
        if (this.form.getTracksTable().getSelectedRowCount() == 1) {
            Track saveTrack = this.db.getTracks().get(this.form.getTracksTable().getSelectedRow());
            File file = new File(saveTrack.getTrackFileName());
            try {
                TrackFileManager.saveTrack(saveTrack, file, saveTrack.getTrackFileType());
                saveTrack.setModified(false);
            }
            catch (TrackFileException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.form, "Error while saving track: " + e.getMessage(), "Error", 0);
            }
        }
    }

    public void save() {
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        if (selectedTrack.getTrackFileName() == null || selectedTrack.getTrackFileName().equals("")) {
            this.saveAs();
        } else {
            File file = new File(selectedTrack.getTrackFileName());
            try {
                TrackFileManager.saveTrack(selectedTrack, file, selectedTrack.getTrackFileType());
                selectedTrack.setModified(false);
            }
            catch (TrackFileException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this.form, "Error while saving track " + selectedTrack.getTrackFileName() + ": " + e.getMessage(), "Error", 0);
            }
        }
    }

    public void saveAs() {
        if (this.form.getTracksTable().getSelectedRowCount() == 1) {
            Track saveTrack = this.db.getTracks().get(this.form.getTracksTable().getSelectedRow());
            int returnVal = this.fileSaveChooser.showSaveDialog(this.form);
            if (returnVal == 0) {
                try {
                    TrackFileManager.saveTrack(saveTrack, this.fileSaveChooser.getSelectedFile(), this.fileSaveChooser.getFileFilter().getDescription());
                    saveTrack.setModified(false);
                }
                catch (TrackFileException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(this.form, "Error while saving track: " + e.getMessage(), "Error", 0);
                }
            }
        }
    }

    public void moveNorth() {
        this.form.getTracksPanel().moveNorth();
    }

    public void moveSouth() {
        this.form.getTracksPanel().moveSouth();
    }

    public void moveWest() {
        this.form.getTracksPanel().moveWest();
    }

    public void moveEast() {
        this.form.getTracksPanel().moveEast();
    }

    public void move(double deltaX, double deltaY) {
        this.form.getTracksPanel().move(deltaX, deltaY);
    }

    public void zoomIn() {
        this.form.getTracksPanel().zoomIn();
    }

    public void zoomOut() {
        this.form.getTracksPanel().zoomOut();
    }

    public void zoomSelectedTrack() {
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        this.form.getTracksPanel().zoom(selectedTrack.getLeftUpperBoundary(), selectedTrack.getRightLowerBoundary());
    }

    public void deleteSelectedPoint() {
        this.form.getTracksView().getSelectedTrackView().deleteSelectedPoint();
    }

    public void insertAdjacentPoints() {
        this.form.getTracksView().getSelectedTrackView().insertAdjacentPoints();
    }

    protected void splitNrPoints(Track track, String trackName, int numberPoints) {
        int numberTrackPoints = track.getNumberPoints();
        String c = "a";
        Track firstTrack = track;
        int nr = 0;
        while (nr < numberTrackPoints - numberPoints - 1) {
            Track secondTrack = firstTrack.split(firstTrack.getPoint(numberPoints), String.valueOf(trackName) + c);
            c = String.valueOf(c) + "a";
            this.db.addTrack(secondTrack);
            firstTrack = secondTrack;
            nr += numberPoints;
        }
    }

    public void split(int splitOption, Track track, String trackName, int numberTracks, int numberPoints, double splitLength) {
        switch (splitOption) {
            case 0: {
                break;
            }
            case 1: {
                Track secondTrack = track.split(this.form.getSelectedPoint(), trackName);
                this.db.addTrack(secondTrack);
                break;
            }
            case 2: {
                this.splitNrPoints(track, trackName, track.getNumberPoints() / numberTracks);
                break;
            }
            case 3: {
                this.splitNrPoints(track, trackName, numberPoints);
                break;
            }
            case 4: {
                this.splitLength(track, trackName, splitLength);
            }
        }
    }

    protected void splitLength(Track track, String trackName, double splitLength) {
        String c = "a";
        Track firstTrack = track;
        while (firstTrack.getLength() > splitLength) {
            Track secondTrack = firstTrack.split(firstTrack.getPoint(splitLength), String.valueOf(trackName) + c);
            c = String.valueOf(c) + "a";
            this.db.addTrack(secondTrack);
            firstTrack = secondTrack;
        }
    }

    public void merge(int mergeOption, Track track, Track mergeTrack, String trackName) {
        switch (mergeOption) {
            case 0: {
                break;
            }
            case 1: {
                track.add(mergeTrack, false);
                track.setName(trackName);
                this.db.removeTrack(mergeTrack);
                break;
            }
            case 2: {
                track.add(mergeTrack, true);
                track.setName(trackName);
                this.db.removeTrack(mergeTrack);
            }
        }
    }

    public void setSelectedPointPosition(int screenX, int screenY) {
        this.form.getTracksView().getSelectedTrackView().setSelectedPointPosition(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY));
    }

    public void appendPoint(int screenX, int screenY) {
        this.form.getTracksView().getSelectedTrackView().getTrack().add(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY));
    }

    public void appendRoutingPoint(int screenX, int screenY) {
        this.form.getTracksPanel().setCursor(Cursor.getPredefinedCursor(3));
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        MapQuestRouting mapQuestRouting = new MapQuestRouting();
        ArrayList<Point> points = mapQuestRouting.loadRoute(selectedTrack.getLastPoint(), new Point(Transform.mapLongitude(screenX), Transform.mapLatitude(screenY)));
        this.form.getTracksPanel().setCursor(Cursor.getPredefinedCursor(1));
        if (points != null) {
            this.form.getAppendUnDo().add(points);
            selectedTrack.add(points);
        } else {
            JOptionPane.showMessageDialog(null, "The route couldn't be obtained from the MapQuest server. Check your internet connection or the MapQuest server is down.", "Internet Access Error", 0);
        }
    }

    public void undoAppend() {
        this.form.getAppendUnDo().unDo();
    }

    public void tileManagerNone() {
        TileManager tileManager = TileManager.getCurrentTileManager();
        if (tileManager != null) {
            tileManager.close();
            TileManager.setCurrentTileManager(null);
        }
    }

    public void tileManagerOSM_Mapnik() {
        System.out.println("Command: OpenStreetMap");
        this.initTileManager(new OSMTileManager());
    }

    public void tileManagerOCM() {
        this.initTileManager(new OCMTileManager());
    }

    protected void initTileManager(TileManager tileManager) {
        TileManager currentTileManager = TileManager.getCurrentTileManager();
        if (currentTileManager != null) {
            boolean showTiles = currentTileManager.isShowTiles();
            currentTileManager.close();
            tileManager.addMapObserver(this.form.getTracksPanel());
            tileManager.open();
            TileManager.setCurrentTileManager(tileManager);
            tileManager.setShowTiles(showTiles);
        } else {
            tileManager.addMapObserver(this.form.getTracksPanel());
            tileManager.open();
            TileManager.setCurrentTileManager(tileManager);
            this.form.getTracksView().setView(Transform.getUpperLeftBoundary(), Transform.getLowerRightBoundary());
        }
        this.form.getTracksPanel().repaint();
    }

    public void tileManagerGoogleMap() {
        if (this.isGoogleMapEnabled()) {
            this.initTileManager(new GoogleMapTileManager());
        }
    }

    public void tileManagerGoogleMapSatellite() {
        if (this.isGoogleMapEnabled()) {
            this.initTileManager(new GoogleMapSatelliteTileManager());
        }
    }

    public void tileManagerGoogleMapHybrid() {
        if (this.isGoogleMapEnabled()) {
            this.initTileManager(new GoogleMapHybridTileManager());
        }
    }

    public void tileManagerGoogleMapTerrain() {
        if (this.isGoogleMapEnabled()) {
            this.initTileManager(new GoogleMapTerrainTileManager());
        }
    }

    public void tileManagerHikeBikeMap() {
        this.initTileManager(new HikeBikeTileManager());
    }

    public void tileManager4UMap() {
        this.initTileManager(new FourUMapsTileManager());
    }

    public void tileManagerMapQuest() {
        this.initTileManager(new MapQuestTileManager());
    }

    public void tileManagerMapQuestSat() {
        this.initTileManager(new MapQuestSatTileManager());
    }

    public void tileManagerMapQuestHybride() {
        this.initTileManager(new MapQuestHybrideTileManager());
    }

    public void updateElevation() {
        if (this.isGoogleElevationAPIEnabled()) {
            int[] selectedRows = this.form.getTracksTable().getSelectedRows();
            ElevationAPI elevationAPI = new ElevationAPI();
            int i = 0;
            while (i < selectedRows.length) {
                block4: {
                    try {
                        elevationAPI.updateElevation(this.db.getTrack(selectedRows[i]));
                    }
                    catch (ElevationException e) {
                        e.printStackTrace();
                        if (!e.getMessage().equals("OVER_QUERY_LIMIT")) break block4;
                        JOptionPane.showMessageDialog(this.form, "The Google-API query limit was reached. Try another day to update elevations!", "Google-API-Error", 0);
                    }
                }
                this.form.setStateMessage("Elevation of track " + this.db.getTracks().get(i).getName() + " updated");
                ++i;
            }
        }
    }

    public Track newTrack() {
        String trackName = JOptionPane.showInputDialog("Name of new track:");
        if (trackName == null) {
            return null;
        }
        Track track = new Track();
        track.setName(trackName);
        track.setTrackFileName(trackName);
        track.setTrackFileType("Garmin GPX Track");
        return track;
    }

    public void correctSelectedTrack() {
        String epsilon = JOptionPane.showInputDialog("Correction epsilon perimeter in km:");
        if (epsilon == null) {
            return;
        }
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        selectedTrack.correct(Parser.parseDouble(epsilon));
        this.form.setStateMessage("Track " + selectedTrack.getName() + " corrected");
        this.zoomSelectedTrack();
    }

    public void openGPSies() {
        try {
            GPSiesComDialog dialog = new GPSiesComDialog(this);
            dialog.setModal(true);
            dialog.setDefaultCloseOperation(2);
            dialog.setVisible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean isGoogleMapEnabled() {
        String GOOGLEMAPQUESTION = "You are trying to use google maps. Google has established usage conditions.\n It is your sole responsibility to confirm wether using google map is allowed by google's license policy.\nSee https://developers.google.com/maps/documentation/staticmaps/\nClick on the OK-button only if you have the right to use google maps!";
        if (!this.googleMapEnabled) {
            this.googleMapEnabled = JOptionPane.showConfirmDialog(this.form, GOOGLEMAPQUESTION, "Warning", 2) == 0;
        }
        return this.googleMapEnabled;
    }

    protected boolean isGoogleElevationAPIEnabled() {
        String GOOGLEAPIQUESTION = "The update elevations function is based on Google Elevation API. Google has established usage conditions.\n It is your sole responsibility to confirm wether using Google Elevation API is allowed by google's license policy.\nSee https://developers.google.com/maps/documentation/elevation/\nClick on the OK-button only if you have the right to use Google Elevation API!";
        if (!this.googleElevationAPIEnabled) {
            this.googleElevationAPIEnabled = JOptionPane.showConfirmDialog(this.form, GOOGLEAPIQUESTION, "Warning", 2) == 0;
        }
        return this.googleElevationAPIEnabled;
    }

    public void userManual() {
        Browser.openURL("https://sourceforge.net/p/jgpstrackedit/wiki/Home/");
    }

    public void updatePage() {
        Browser.openURL("http://sourceforge.net/projects/jgpstrackedit/files/binaries/");
    }

    public void shortCut(Point start, Point end) {
        System.out.println("UIControlleR: shortCut (" + start + "," + end + ")");
        if (start != null && end != null) {
            this.db.getTrackTableModel().getSelectedTrack().remove(start, end);
        }
    }

    @Override
    public void run() {
        this.openDirectoryTrackFiles();
    }

    public void correctZeroPoints() {
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        selectedTrack.correct();
        selectedTrack.correctDoublePoints();
        this.form.setStateMessage("Track " + selectedTrack.getName() + " corrected");
        this.zoomSelectedTrack();
    }

    public void compress() {
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        DlgCompressOptions dialog = new DlgCompressOptions(selectedTrack.getName());
        dialog.setDefaultCloseOperation(2);
        dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        dialog.setVisible(true);
        if (dialog.copyToNewTrack() && dialog.getOption() != DlgCompressOptions.CompressionOption.Cancel) {
            selectedTrack = selectedTrack.clone();
            selectedTrack.setName(dialog.getTrackName());
            selectedTrack.setColor(Color.RED);
            this.db.addTrack(selectedTrack);
            this.db.getTrackTableModel().setSelectedTrack(selectedTrack);
            this.form.getTracksTable().addRowSelectionInterval(this.db.getTrackNumber() - 1, this.db.getTrackNumber() - 1);
            this.form.setSelectedTrack(selectedTrack);
        }
        switch (dialog.getOption()) {
            case Cancel: {
                break;
            }
            case RemoveInterval: {
                selectedTrack.compress(dialog.getRemoveInterval());
                this.form.setStateMessage("Track " + selectedTrack.getName() + " compressed.");
                break;
            }
            case MaxDistance: {
                selectedTrack.compress(dialog.getMaxDistance());
                this.form.setStateMessage("Track " + selectedTrack.getName() + " compressed.");
                break;
            }
            case Interdistance: {
                selectedTrack.compress(dialog.getInterdistance(), 0);
                this.form.setStateMessage("Track " + selectedTrack.getName() + " compressed.");
                break;
            }
            case DouglasPeucker: {
                selectedTrack.compressDouglasPeucker(dialog.getDouglasPeuckerDistance());
                this.form.setStateMessage("Track " + selectedTrack.getName() + " compressed.");
            }
        }
    }

    public void zoomSelectedPoint() {
        Point zoomPoint = this.form.getTracksView().getSelectedTrackView().getSelectedPoint();
        if (zoomPoint != null) {
            this.form.getTracksPanel().zoom(zoomPoint);
        }
    }

    public void selectPreviousPoint(boolean zoom) {
        Point selectedPoint = this.form.getTracksView().getSelectedTrackView().getSelectedPoint();
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        if (selectedTrack != null && selectedPoint != null) {
            selectedPoint = selectedTrack.previousPoint(selectedPoint);
            this.selectPoint(selectedTrack, selectedPoint, zoom);
        }
    }

    public void selectNextPoint(boolean zoom) {
        Point selectedPoint = this.form.getTracksView().getSelectedTrackView().getSelectedPoint();
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        if (selectedTrack != null && selectedPoint != null) {
            selectedPoint = selectedTrack.nextPoint(selectedPoint);
            this.selectPoint(selectedTrack, selectedPoint, zoom);
        }
    }

    public void selectPoint(Track track, Point point, boolean zoom) {
        this.form.getTracksView().getSelectedTrackView().setSelectedPoint(point);
        this.form.getAltitudeProfilePanel().setSelectedPoint(point);
        int selectedPointIndex = track.indexOf(point);
        this.form.getPointsTable().setRowSelectionInterval(selectedPointIndex, selectedPointIndex);
        if (zoom) {
            this.zoomSelectedPoint();
        }
    }

    public void saveMapExtract() {
        String mapExtractName = JOptionPane.showInputDialog("Name of new map extract:");
        if (mapExtractName == null) {
            return;
        }
        MapExtractManager.add(mapExtractName, Transform.getZoomLevel(), Transform.getUpperLeftBoundary());
    }

    public void zoomMapExtract() {
        MapExtract mapExtract;
        DlgSelectMapExtract dlg = new DlgSelectMapExtract(MapExtractManager.mapExtractNames());
        dlg.setVisible(true);
        String mapExtractName = dlg.getSelectedMapExtractName();
        if (mapExtractName != null && (mapExtract = MapExtractManager.get(dlg.getSelectedMapExtractName())) != null) {
            this.form.getTracksPanel().zoom(mapExtract);
        }
    }

    public void saveGPSies() {
        Track selectedTrack = this.db.getTrackTableModel().getSelectedTrack();
        GPSiesSaveDlg dialog = new GPSiesSaveDlg(selectedTrack);
        dialog.setModal(true);
        dialog.setDefaultCloseOperation(2);
        dialog.setVisible(true);
    }

    public void saveMapViewAsImage() {
        JFileChooser chooser = UIController.getJFileChooser();
        int returnVal = chooser.showSaveDialog(this.form);
        if (returnVal == 0) {
            try {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                if (!fileName.endsWith(".png")) {
                    fileName = String.valueOf(fileName) + ".png";
                }
                ImageIO.write((RenderedImage)this.form.getTracksPanel().getImage(), "png", new File(fileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void saveAltitudeProfileasImage() {
        JFileChooser chooser = UIController.getJFileChooser();
        int returnVal = chooser.showSaveDialog(this.form);
        if (returnVal == 0) {
            try {
                String fileName = chooser.getSelectedFile().getAbsolutePath();
                if (!fileName.endsWith(".png")) {
                    fileName = String.valueOf(fileName) + ".png";
                }
                ImageIO.write((RenderedImage)this.form.getAltitudeProfilePanel().getImage(), "png", new File(fileName));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

