/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import jgpstrackedit.data.DBObserver;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.data.util.TrackTableModel;
import jgpstrackedit.international.International;

public class Database
extends AbstractTableModel
implements TrackObserver {
    private ArrayList<Track> tracks = new ArrayList();
    private Track boundary = new Track();
    private ArrayList<DBObserver> dbObservers = new ArrayList();
    private TrackTableModel trackTableModel = new TrackTableModel();

    public TrackTableModel getTrackTableModel() {
        return this.trackTableModel;
    }

    public ArrayList<Track> getTracks() {
        return this.tracks;
    }

    public Track getTrack(int index) {
        return this.tracks.get(index);
    }

    public int getTrack(Track track) {
        return this.tracks.indexOf(track);
    }

    public Track getTrack(Point point) {
        Track nearestTrack = null;
        double minDistance = 10000.0;
        for (Track track : this.tracks) {
            Point nP;
            if (!track.isInBoundary(point) || (nP = track.nearestPoint(point)) == null) continue;
            if (nearestTrack == null) {
                nearestTrack = track;
                minDistance = nP.distance(point);
                continue;
            }
            double dist = nP.distance(point);
            if (!(dist < minDistance)) continue;
            nearestTrack = track;
            minDistance = nP.distance(point);
        }
        return nearestTrack;
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
        track.addTrackObserver(this);
        this.boundary.add(track.getLeftUpperBoundary());
        this.boundary.add(track.getRightLowerBoundary());
        this.notifyDBObservers();
        this.fireTableDataChanged();
    }

    public void removeTrack(Track track) {
        this.tracks.remove(track);
        this.notifyDBObservers();
    }

    public void removeTrack(int index) {
        this.tracks.remove(index);
        this.notifyDBObservers();
    }

    public boolean isModified() {
        for (Track track : this.tracks) {
            if (!track.isModified()) continue;
            return true;
        }
        return false;
    }

    public int getTrackNumber() {
        return this.tracks.size();
    }

    public Point getLeftUpperBoundary() {
        return this.boundary.getLeftUpperBoundary();
    }

    public Point getRightLowerBoundary() {
        return this.boundary.getRightLowerBoundary();
    }

    public void addDBObserver(DBObserver observer) {
        this.dbObservers.add(observer);
    }

    public void removeDBObserver(DBObserver observer) {
        this.dbObservers.remove(observer);
    }

    protected void notifyDBObservers() {
        for (DBObserver observer : this.dbObservers) {
            observer.dbModified();
        }
    }

    public void reverseTrack(int index) {
        this.tracks.get(index).reverse();
    }

    @Override
    public int getRowCount() {
        return this.tracks.size();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.tracks.get(rowIndex).getName();
            }
            case 1: {
                return this.tracks.get(rowIndex).getColor();
            }
            case 2: {
                return this.tracks.get(rowIndex).getLength();
            }
            case 3: {
                return this.tracks.get(rowIndex).isModified();
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return International.getText("tracktbl.Track");
            }
            case 1: {
                return International.getText("tracktbl.Color");
            }
            case 2: {
                return International.getText("tracktbl.Length");
            }
            case 3: {
                return International.getText("tracktbl.Modified");
            }
        }
        return "Unknown";
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Color.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Boolean.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        switch (column) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.tracks.get(rowIndex).setName((String)aValue);
                break;
            }
            case 1: {
                this.tracks.get(rowIndex).setColor((Color)aValue);
            }
        }
        this.notifyDBObservers();
    }

    @Override
    public void trackModified(Track track) {
        this.notifyDBObservers();
        this.fireTableDataChanged();
    }
}

