/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.data.util;

import javax.swing.table.AbstractTableModel;
import jgpstrackedit.data.Track;
import jgpstrackedit.data.TrackObserver;
import jgpstrackedit.international.International;

public class TrackTableModel
extends AbstractTableModel
implements TrackObserver {
    private Track currentTrack = null;

    public Track getSelectedTrack() {
        return this.currentTrack;
    }

    public void setSelectedTrack(Track currentTrack) {
        if (this.currentTrack != null) {
            this.currentTrack.removeTrackObserver(this);
        }
        this.currentTrack = currentTrack;
        this.currentTrack.addTrackObserver(this);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        if (this.currentTrack != null) {
            return this.currentTrack.getNumberPoints();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return row;
            }
            case 1: {
                return this.currentTrack.getPoint(row).getLatitudeAsString();
            }
            case 2: {
                return this.currentTrack.getPoint(row).getLongitudeAsString();
            }
            case 3: {
                return this.currentTrack.getPoint(row).getElevationAsString();
            }
            case 4: {
                return this.currentTrack.getPoint(row).getTime();
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int arg0) {
        switch (arg0) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
        }
        return Object.class;
    }

    @Override
    public String getColumnName(int arg0) {
        switch (arg0) {
            case 0: {
                return International.getText("pointtbl.Index");
            }
            case 1: {
                return International.getText("pointtbl.Latitude");
            }
            case 2: {
                return International.getText("pointtbl.Longitude");
            }
            case 3: {
                return International.getText("pointtbl.Elevation");
            }
            case 4: {
                return International.getText("pointtbl.Timestamp");
            }
        }
        return "Unknown";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                this.currentTrack.getPoint(rowIndex).setLatitude((String)aValue);
            }
            case 2: {
                this.currentTrack.getPoint(rowIndex).setLongitude((String)aValue);
            }
            case 3: {
                this.currentTrack.getPoint(rowIndex).setElevation((String)aValue);
            }
            case 4: {
                this.currentTrack.getPoint(rowIndex).setTime((String)aValue);
            }
        }
    }

    @Override
    public void trackModified(Track track) {
        this.fireTableDataChanged();
    }
}

