/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.gpsies;

import java.io.IOException;
import java.net.URL;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jgpstrackedit.gpsies.GPSiesResultHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class GPSiesResultParser
implements ContentHandler {
    private GPSiesResultHandler handler;
    private Stack context;
    private StringBuffer buffer;
    private EntityResolver resolver;

    public GPSiesResultParser(GPSiesResultHandler handler, EntityResolver resolver) {
        this.handler = handler;
        this.resolver = resolver;
        this.buffer = new StringBuffer(111);
        this.context = new Stack();
    }

    @Override
    public final void setDocumentLocator(Locator locator) {
    }

    @Override
    public final void startDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
    }

    @Override
    public final void startElement(String ns, String name, String qname, Attributes attrs) throws SAXException {
        this.dispatch(true);
        this.context.push(new Object[]{qname, new AttributesImpl(attrs)});
        if ("meta".equals(qname)) {
            this.handler.start_meta(attrs);
        } else if ("track".equals(qname)) {
            this.handler.start_track(attrs);
        } else if ("tracks".equals(qname)) {
            this.handler.start_tracks(attrs);
        } else if ("gpsies".equals(qname)) {
            this.handler.start_gpsies(attrs);
        }
    }

    @Override
    public final void endElement(String ns, String name, String qname) throws SAXException {
        this.dispatch(false);
        this.context.pop();
        if ("meta".equals(qname)) {
            this.handler.end_meta();
        } else if ("track".equals(qname)) {
            this.handler.end_track();
        } else if ("tracks".equals(qname)) {
            this.handler.end_tracks();
        } else if ("gpsies".equals(qname)) {
            this.handler.end_gpsies();
        }
    }

    @Override
    public final void characters(char[] chars, int start, int len) throws SAXException {
        this.buffer.append(chars, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] chars, int start, int len) throws SAXException {
    }

    @Override
    public final void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public final void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public final void skippedEntity(String name) throws SAXException {
    }

    private void dispatch(boolean fireOnlyIfMixed) throws SAXException {
        if (fireOnlyIfMixed && this.buffer.length() == 0) {
            return;
        }
        Object[] ctx = (Object[])this.context.peek();
        String here = (String)ctx[0];
        Attributes attrs = (Attributes)ctx[1];
        if ("startPointLon".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_startPointLon(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("startPointLat".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_startPointLat(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("endPointLat".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_endPointLat(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("resultPage".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_resultPage(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("changedDate".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_changedDate(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("title".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_title(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("username".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_username(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("description".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_description(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("endPointCountry".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_endPointCountry(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("filetype".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_filetype(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("altitudeMaxHeightM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_altitudeMaxHeightM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("createdDate".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_createdDate(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("endPointLon".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_endPointLon(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("limit".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_limit(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("altitudeDifferenceM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_altitudeDifferenceM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("totalDescentM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_totalDescentM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("totalAscentM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_totalAscentM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("altitudeMinHeightM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_altitudeMinHeightM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("requestUrl".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_requestUrl(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("countTrackpoints".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_countTrackpoints(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("fileId".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_fileId(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("startPointCountry".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_startPointCountry(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("trackProperty".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_trackProperty(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("downloadLink".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_downloadLink(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("trackLengthM".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_trackLengthM(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("resultSize".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_resultSize(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        } else if ("downloadBaseUrl".equals(here)) {
            if (fireOnlyIfMixed) {
                throw new IllegalStateException("Unexpected characters() event! (Missing DTD?)");
            }
            this.handler.handle_downloadBaseUrl(this.buffer.length() == 0 ? null : this.buffer.toString(), attrs);
        }
        this.buffer.delete(0, this.buffer.length());
    }

    public void parse(InputSource input) throws SAXException, ParserConfigurationException, IOException {
        GPSiesResultParser.parse(input, this);
    }

    public void parse(URL url) throws SAXException, ParserConfigurationException, IOException {
        GPSiesResultParser.parse(new InputSource(url.toExternalForm()), this);
    }

    public static void parse(InputSource input, GPSiesResultHandler handler) throws SAXException, ParserConfigurationException, IOException {
        GPSiesResultParser.parse(input, new GPSiesResultParser(handler, null));
    }

    public static void parse(URL url, GPSiesResultHandler handler) throws SAXException, ParserConfigurationException, IOException {
        GPSiesResultParser.parse(new InputSource(url.toExternalForm()), handler);
    }

    private static void parse(InputSource input, GPSiesResultParser recognizer) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        factory.setNamespaceAware(false);
        XMLReader parser = factory.newSAXParser().getXMLReader();
        parser.setContentHandler(recognizer);
        parser.setErrorHandler(recognizer.getDefaultErrorHandler());
        if (recognizer.resolver != null) {
            parser.setEntityResolver(recognizer.resolver);
        }
        parser.parse(input);
    }

    protected ErrorHandler getDefaultErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) throws SAXException {
                if (GPSiesResultParser.this.context.isEmpty()) {
                    System.err.println("Missing DOCTYPE.");
                }
                throw ex;
            }

            @Override
            public void fatalError(SAXParseException ex) throws SAXException {
                throw ex;
            }

            @Override
            public void warning(SAXParseException ex) throws SAXException {
            }
        };
    }
}

