/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import jgpstrackedit.config.Configuration;
import jgpstrackedit.config.SystemConfig;
import jgpstrackedit.map.tiledownload.TileCopyCommand;
import jgpstrackedit.map.tiledownload.TileDownload;
import jgpstrackedit.map.tilehandler.DiskTileLoader;
import jgpstrackedit.map.tilehandler.QueueObserver;
import jgpstrackedit.map.tilehandler.TileLoadEvent;
import jgpstrackedit.map.tilehandler.TileLoadObserver;
import jgpstrackedit.map.tilehandler.TileSaver;
import jgpstrackedit.map.tilehandler.WebTileLoader;
import jgpstrackedit.map.util.ImageConverter;
import jgpstrackedit.map.util.MapObserver;
import jgpstrackedit.map.util.Tile;
import jgpstrackedit.map.util.TileBoundary;
import jgpstrackedit.map.util.TileLRUList;
import jgpstrackedit.map.util.TileLRUObserver;
import jgpstrackedit.map.util.TileNumber;
import jgpstrackedit.map.util.TileState;
import jgpstrackedit.util.ProgressHandler;
import jgpstrackedit.view.Transform;

public abstract class TileManager
implements Runnable,
TileLoadObserver,
ImageObserver,
TileLRUObserver {
    private int maxZoom = 18;
    private static TileManager currentTileManager = null;
    private boolean showTiles = false;
    private String mapName;
    private String baseURL;
    private boolean ready = false;
    private DiskTileLoader diskTileLoader;
    private WebTileLoader webTileLoader;
    private TileSaver tileSaver;
    private HashMap<TileNumber, Tile> tiles;
    private TileLRUList tileLRU;
    private LinkedList<MapObserver> mapObservers = new LinkedList();
    private Image loadingImage;
    private TileDownload tileDownload = null;
    private int[] scales = new int[]{25000000, 10000000, 5000000, 2500000, 1000000, 500000, 250000, 100000, 50000, 25000, 10000, 5000, 2500, 1000, 500, 250, 100, 50, 25, 10, 5};

    public TileDownload getTileDownload() {
        return this.tileDownload;
    }

    public void setTileDownload(TileDownload tileDownload) {
        this.tileDownload = tileDownload;
    }

    public boolean isShowTiles() {
        return this.showTiles;
    }

    public void setShowTiles(boolean showTiles) {
        this.showTiles = showTiles;
    }

    public int getMaxZoom() {
        return this.maxZoom;
    }

    protected void setMaxZoom(int maxzoom) {
        this.maxZoom = maxzoom;
    }

    public void addMapObserver(MapObserver observer) {
        this.mapObservers.add(observer);
    }

    public void removeMapObserver(MapObserver observer) {
        this.mapObservers.remove(observer);
    }

    protected void notifyMapObservers() {
        for (MapObserver observer : this.mapObservers) {
            observer.mapTilesUpdated();
        }
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public static TileManager getCurrentTileManager() {
        return currentTileManager;
    }

    public static void setCurrentTileManager(TileManager tileManager) {
        currentTileManager = tileManager;
    }

    public void addWebQueueObserver(QueueObserver observer) {
        this.webTileLoader.addQueueObserver(observer);
    }

    public void removeWebQueueObserver(QueueObserver observer) {
        this.webTileLoader.removeQueueObserver(observer);
    }

    public void addTileSaveQueueObserver(QueueObserver observer) {
        this.tileSaver.addQueueObserver(observer);
    }

    public void removeTileSaveQueueObserver(QueueObserver observer) {
        this.tileSaver.removeQueueObserver(observer);
    }

    public void open() {
        this.tiles = new HashMap();
        this.tileLRU = new TileLRUList(Configuration.getIntProperty("MAX_TILES_IN_MEMORY"));
        this.tileLRU.addTileLRUObserver(this);
        this.diskTileLoader = new DiskTileLoader();
        this.diskTileLoader.setBaseDirectory("map" + SystemConfig.dirSeparator() + this.mapName);
        this.diskTileLoader.addTileLoadObserver(this);
        this.diskTileLoader.start();
        this.webTileLoader = new WebTileLoader();
        this.webTileLoader.addTileLoadObserver(this);
        this.webTileLoader.start();
        this.tileSaver = new TileSaver();
        this.tileSaver.setBaseDirectory("map" + SystemConfig.dirSeparator() + this.mapName);
        this.tileSaver.start();
        this.loadingImage = TileManager.createLoadingImage();
        new Thread(this).start();
    }

    public void close() {
        this.tileLRU.removeTileLRUObserver(this);
        this.diskTileLoader.removeTileLoadObserver(this);
        this.diskTileLoader.stop();
        this.webTileLoader.removeTileLoadObserver(this);
        this.webTileLoader.stop();
        this.tileSaver.stop();
    }

    public void paintMap(Graphics2D g2D, double upperLeftX, double upperLeftY, double lowerRightX, double lowerRightY, int screenWidth, int screenHeight) {
        int zoomLevel = Transform.getZoomLevel();
        TileNumber upperLeftTileNumber = TileNumber.getTileNumber(zoomLevel, upperLeftX, upperLeftY);
        TileBoundary upperLeftTileBoundary = TileBoundary.getTileBoundary(upperLeftTileNumber);
        int tilesX = this.calculateNumberHorizontalTiles(zoomLevel, upperLeftX, upperLeftTileBoundary.getWest(), screenWidth);
        int tilesY = this.calculateNumberVerticalTiles(zoomLevel, upperLeftY, upperLeftTileBoundary.getWest(), upperLeftTileBoundary.getNorth(), screenHeight);
        int xOffset = this.pixelXOffset(zoomLevel, upperLeftX, upperLeftTileBoundary.getWest());
        int yOffset = this.pixelYOffset(zoomLevel, upperLeftY, upperLeftTileBoundary.getWest(), upperLeftTileBoundary.getNorth());
        int x = 0;
        while (x < tilesX) {
            int y = 0;
            while (y < tilesY) {
                TileNumber loadingTileNumber = new TileNumber(zoomLevel, upperLeftTileNumber.getX() + x, upperLeftTileNumber.getY() + y);
                Image loadImage = this.getTileImage(loadingTileNumber);
                TileBoundary tb = TileBoundary.getTileBoundary(loadingTileNumber);
                if (zoomLevel > 11) {
                    g2D.drawImage(loadImage, Transform.screenX(tb.getWest()), Transform.screenY(tb.getNorth()), null);
                } else {
                    g2D.drawImage(loadImage, x * 256 - xOffset, y * 256 - yOffset, null);
                }
                if (this.isShowTiles()) {
                    Color saveColor = g2D.getColor();
                    g2D.setColor(Color.BLUE);
                    this.drawTileBorder(g2D, tb);
                    g2D.drawString(loadingTileNumber.toString(), Transform.screenX(tb.getWest()) + 2, Transform.screenY(tb.getNorth()) + 12);
                    g2D.setColor(saveColor);
                }
                ++y;
            }
            ++x;
        }
        if (this.getTileDownload() != null) {
            for (TileNumber tileNumber : this.getTileDownload().getDownloadTiles()) {
                TileBoundary tb = TileBoundary.getTileBoundary(tileNumber);
                Color saveColor = g2D.getColor();
                g2D.setColor(Color.RED);
                this.drawTileBorder(g2D, tb);
                g2D.setColor(saveColor);
            }
        }
    }

    protected void drawTileBorder(Graphics2D g2D, TileBoundary tb) {
        g2D.drawLine(Transform.screenX(tb.getWest()), Transform.screenY(tb.getNorth()), Transform.screenX(tb.getEast()), Transform.screenY(tb.getNorth()));
        g2D.drawLine(Transform.screenX(tb.getEast()), Transform.screenY(tb.getNorth()), Transform.screenX(tb.getEast()), Transform.screenY(tb.getSouth()));
        g2D.drawLine(Transform.screenX(tb.getEast()), Transform.screenY(tb.getSouth()), Transform.screenX(tb.getWest()), Transform.screenY(tb.getSouth()));
        g2D.drawLine(Transform.screenX(tb.getWest()), Transform.screenY(tb.getSouth()), Transform.screenX(tb.getWest()), Transform.screenY(tb.getNorth()));
    }

    public void paintScale(Graphics2D g2D, int x, int y) {
        int zoom = Transform.getZoomLevel();
        int scale = this.scales[Transform.getZoomLevel()];
        Color color = g2D.getColor();
        g2D.setColor(Color.BLACK);
        double resolution = 156543.034 * Math.cos(Transform.getLowerRightBoundary().getLatitude() * Math.PI / 180.0) / Math.pow(2.0, zoom);
        int lengthPixel = (int)((double)scale / resolution);
        g2D.fillRect(x, y, lengthPixel, 2);
        g2D.fillRect(x, y - 10, 2, 10);
        g2D.fillRect(x + lengthPixel - 2, y - 10, 2, 10);
        if (scale >= 1000) {
            g2D.drawString(scale / 1000 + "km", x + 10, y - 2);
        } else {
            g2D.drawString(scale + "m", x + 10, y - 2);
        }
        g2D.setColor(color);
    }

    public static int calculateZoomLevel(double upperLeftX, double upperLeftY, double lowerRightX, double lowerRightY) {
        double viewingWidth = Math.abs(lowerRightX - upperLeftX);
        double worldWidth = 360.0;
        int zoomLevel = TileManager.getCurrentTileManager().getMaxZoom();
        int i = 0;
        while (i <= TileManager.getCurrentTileManager().getMaxZoom() + 1) {
            if (viewingWidth > worldWidth / (double)(1 << i)) {
                zoomLevel = i;
                break;
            }
            ++i;
        }
        return zoomLevel;
    }

    public static int incZoomLevel(int zoomLevel) {
        if (zoomLevel < TileManager.getCurrentTileManager().getMaxZoom()) {
            return zoomLevel + 1;
        }
        return zoomLevel;
    }

    public static int decZoomLevel(int zoomLevel) {
        if (zoomLevel > 0) {
            return zoomLevel - 1;
        }
        return zoomLevel;
    }

    protected int pixelXOffset(int zoomLevel, double x, double tileX) {
        double hiddenLength = Math.abs(x - tileX);
        return (int)(hiddenLength / TileBoundary.scaleX(zoomLevel));
    }

    protected int pixelYOffset(int zoomLevel, double y, double tileX, double tileY) {
        double hiddenLength = tileY - y;
        return (int)(hiddenLength / TileBoundary.scaleY(zoomLevel, tileX, tileY));
    }

    protected int calculateNumberHorizontalTiles(int zoomLevel, double upperLeftX, double tileUpperLeftX, int screenWidth) {
        double minPixel = this.pixelXOffset(zoomLevel, upperLeftX, tileUpperLeftX) + screenWidth;
        int numberTiles = (int)Math.floor(minPixel / 256.0) + 1;
        return numberTiles;
    }

    protected int calculateNumberVerticalTiles(int zoomLevel, double upperLeftY, double tileUpperLeftX, double tileUpperLeftY, int screenHeight) {
        double minPixel = this.pixelYOffset(zoomLevel, upperLeftY, tileUpperLeftX, tileUpperLeftY) + screenHeight;
        int numberTiles = (int)Math.floor(minPixel / 256.0) + 1;
        return numberTiles;
    }

    protected Image getTileImage(TileNumber tileNumber) {
        Image img = this.loadingImage;
        if (!this.ready) {
            return img;
        }
        Tile tile = this.tiles.get(tileNumber);
        if (tile == null) {
            tile = new Tile(tileNumber);
            this.tiles.put(tileNumber, tile);
        }
        this.tileLRU.touch(tileNumber);
        switch (tile.getTileState()) {
            case unknown: {
                tile.setTileState(TileState.loadingFromWeb);
                this.webTileLoader.loadTile(tileNumber);
                break;
            }
            case onDisk: {
                tile.setTileState(TileState.loadingFromDisk);
                this.diskTileLoader.loadTile(tileNumber);
                break;
            }
            case loadingFromWeb: {
                break;
            }
            case loadingFromDisk: {
                break;
            }
            case available: {
                if (tile.getTileImage() != null) {
                    img = tile.getTileImage();
                    break;
                }
                tile.setTileState(TileState.unknown);
            }
        }
        return img;
    }

    protected boolean downloadTileFromWeb(TileNumber tileNumber) {
        boolean result = false;
        Tile tile = this.tiles.get(tileNumber);
        if (tile == null) {
            tile = new Tile(tileNumber);
            this.tiles.put(tileNumber, tile);
        }
        this.tileLRU.touch(tileNumber);
        switch (tile.getTileState()) {
            case unknown: {
                String urlString = this.getTileURL(tileNumber);
                try {
                    URL url = new URL(urlString);
                    Image image = Toolkit.getDefaultToolkit().createImage(url);
                    String dirPath = String.valueOf(this.getBaseDir()) + SystemConfig.dirSeparator() + tileNumber.getZoom() + SystemConfig.dirSeparator() + tileNumber.getX();
                    File dir = new File(dirPath);
                    dir.mkdirs();
                    String fileName = String.valueOf(dirPath) + SystemConfig.dirSeparator() + tileNumber.getY() + ".png";
                    BufferedImage bufferedImage = ImageConverter.toBufferedImage(image);
                    if (bufferedImage != null) {
                        File file = new File(fileName);
                        try {
                            ImageIO.write((RenderedImage)bufferedImage, "png", file);
                            tile.setTileState(TileState.onDisk);
                            result = true;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    System.out.println("TileManager: File not saved due to null-image: " + fileName);
                }
                catch (MalformedURLException e) {
                    System.out.println("TileManager: URL=" + urlString);
                    e.printStackTrace();
                }
                break;
            }
            case onDisk: {
                result = true;
                break;
            }
            case loadingFromWeb: {
                break;
            }
            case loadingFromDisk: {
                result = true;
                break;
            }
            case available: {
                result = true;
            }
        }
        return result;
    }

    public ArrayList<TileNumber> downloadTiles(TreeSet<TileNumber> downloadTiles, String targetDir, String extension, ProgressHandler progressHandler) {
        ArrayList<TileNumber> errorTiles = new ArrayList<TileNumber>();
        int downloadCount = 0;
        for (TileNumber tile : downloadTiles) {
            if (progressHandler != null) {
                progressHandler.stepDone((int)((double)downloadCount * 100.0 / (double)downloadTiles.size()));
                Thread.yield();
            }
            if (this.downloadTileFromWeb(tile)) {
                try {
                    File file = new File(String.valueOf(targetDir) + SystemConfig.dirSeparator() + tile.getZoom() + SystemConfig.dirSeparator() + tile.getX());
                    file.mkdirs();
                    String sourceFile = String.valueOf(this.getBaseDir()) + tile.toFileName() + ".png";
                    String destFile = String.valueOf(targetDir) + tile.toFileName() + ".png" + extension;
                    TileCopyCommand.copy(sourceFile, destFile);
                }
                catch (IOException e) {
                    errorTiles.add(tile);
                    e.printStackTrace();
                }
            } else {
                errorTiles.add(tile);
            }
            Thread.yield();
            ++downloadCount;
        }
        return errorTiles;
    }

    public void initializeTileCacheStructure() {
        this.tiles.clear();
        int i = 0;
        while (i <= this.getMaxZoom()) {
            File file = new File(String.valueOf(this.getBaseDir()) + SystemConfig.dirSeparator() + i);
            file.mkdirs();
            this.initializeZoomLevel(file, i);
            ++i;
        }
    }

    public String getBaseDir() {
        return "map" + SystemConfig.dirSeparator() + this.getMapName();
    }

    protected void initializeZoomLevel(File directory, int zoomLevel) {
        File[] xTilesDir = directory.listFiles();
        int i = 0;
        while (i < xTilesDir.length) {
            this.initializeXLevel(xTilesDir[i], zoomLevel, Integer.parseInt(xTilesDir[i].getName()));
            ++i;
        }
    }

    protected void initializeXLevel(File xLevelDir, int zoomLevel, int x) {
        File[] yTiles = xLevelDir.listFiles();
        int i = 0;
        while (i < yTiles.length) {
            String yTileImageFileName = yTiles[i].getName();
            if (yTileImageFileName.endsWith(".png")) {
                int y = Integer.parseInt(yTileImageFileName.substring(0, yTileImageFileName.length() - 4));
                TileNumber tileNumber = new TileNumber(zoomLevel, x, y);
                Tile tile = new Tile(tileNumber);
                tile.setTileState(TileState.onDisk);
                this.tiles.put(tileNumber, tile);
            }
            ++i;
        }
    }

    @Override
    public void run() {
        this.initializeTileCacheStructure();
        this.ready = true;
        this.notifyMapObservers();
    }

    public static Image createLoadingImage() {
        BufferedImage img = new BufferedImage(256, 256, 1);
        img.createGraphics();
        Graphics2D g = (Graphics2D)img.getGraphics();
        g.setColor(new Color(255, 255, 220));
        g.fillRect(0, 0, 256, 256);
        g.setColor(new Color(240, 240, 30));
        g.drawString("Loading...          Loading...", 1, 60);
        g.drawString("If not loaded properly, choose View.Refresh Map", 1, 100);
        return img;
    }

    @Override
    public void tileLoaded(TileLoadEvent tileLoadEvent) {
        Tile tile = this.tiles.get(tileLoadEvent.getTileNumber());
        if (tile != null) {
            tile.setTileImage(tileLoadEvent.getImageLoaded());
            switch (tile.getTileState()) {
                case unknown: {
                    break;
                }
                case onDisk: {
                    break;
                }
                case loadingFromWeb: {
                    tile.setTileState(TileState.available);
                    this.notifyMapObservers();
                    this.tileSaver.saveImage(tileLoadEvent.getImageLoaded(), tileLoadEvent.getTileNumber());
                    break;
                }
                case loadingFromDisk: {
                    tile.setTileState(TileState.available);
                    this.notifyMapObservers();
                    break;
                }
                case available: {
                    this.notifyMapObservers();
                }
            }
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        boolean error;
        boolean loaded = (infoflags & 0x20) > 0;
        boolean bl = error = (infoflags & 0x40) > 0;
        if (loaded || error) {
            this.notifyMapObservers();
        }
        return !loaded;
    }

    public abstract String getTileURL(TileNumber var1);

    public void reloadTile(double mapLongitude, double mapLatitude) {
        TileNumber reloadTileNumber = TileNumber.getTileNumber(Transform.getZoomLevel(), mapLongitude, mapLatitude);
        Tile reloadTile = this.tiles.get(reloadTileNumber);
        if (reloadTile != null) {
            reloadTile.setTileState(TileState.unknown);
        }
    }

    @Override
    public void freeTile(TileNumber tileNumber) {
        Tile tile = this.tiles.get(tileNumber);
        tile.setTileImage(null);
        switch (tile.getTileState()) {
            case unknown: {
                tile.setTileImage(null);
                break;
            }
            case onDisk: {
                break;
            }
            case loadingFromWeb: {
                tile.setTileState(TileState.unknown);
                break;
            }
            case loadingFromDisk: {
                tile.setTileState(TileState.onDisk);
                break;
            }
            case available: {
                tile.setTileState(TileState.onDisk);
            }
        }
    }
}

