/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.map.elevation;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.map.elevation.ElevationException;
import jgpstrackedit.map.elevation.ElevationHandlerImpl;
import jgpstrackedit.map.elevation.ElevationParser;
import jgpstrackedit.map.elevation.ElevationResponse;
import jgpstrackedit.map.elevation.ElevationResult;
import jgpstrackedit.util.Parser;
import org.xml.sax.SAXException;

public class ElevationAPI {
    private StringBuilder elevationURL;
    private boolean firstPoint;
    private HashMap<String, Point> points;

    public void updateElevation(Track track) throws ElevationException {
        this.initElevationRequest();
        int pointCounter = 0;
        int i = 0;
        while (i < track.getNumberPoints()) {
            this.addPoint(track.getPoint(i));
            if (++pointCounter == 50) {
                pointCounter = 0;
                this.issueElevationRequest();
                this.initElevationRequest();
            }
            ++i;
        }
        if (pointCounter != 0) {
            this.issueElevationRequest();
        }
        track.hasBeenModified();
    }

    protected void initElevationRequest() {
        this.elevationURL = new StringBuilder("http://maps.googleapis.com/maps/api/elevation/xml?locations=");
        this.firstPoint = true;
        this.points = new HashMap();
    }

    protected void addPoint(Point point) {
        if (this.firstPoint) {
            this.firstPoint = false;
        } else {
            this.elevationURL.append('|');
        }
        String location = String.valueOf(Parser.trim_0(point.getLatitudeAsString())) + "," + Parser.trim_0(point.getLongitudeAsString());
        this.elevationURL.append(location);
        this.points.put(location, point);
    }

    protected void issueElevationRequest() throws ElevationException {
        this.elevationURL.append("&sensor=false");
        System.out.println(this.elevationURL.toString());
        try {
            URL url = new URL(this.elevationURL.toString());
            ElevationHandlerImpl handler = new ElevationHandlerImpl();
            ElevationParser parser = new ElevationParser(handler, null);
            parser.parse(url);
            ElevationResponse elevationResponse = handler.getElevationResponse();
            if (!elevationResponse.getState().equals("OK")) {
                throw new ElevationException(elevationResponse.getState());
            }
            for (ElevationResult elevationResult : elevationResponse.getResults()) {
                System.out.println(elevationResult);
                Point point = this.points.get(elevationResult.getLocation());
                if (point == null) {
                    System.out.println("ElevationAPI: no match for " + elevationResult.getLocation());
                    continue;
                }
                point.setElevation(elevationResult.getElevation());
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

