/*
 * Decompiled with CFR 0.152.
 */
package jgpstrackedit.trackfile.gpxtrack;

import jgpstrackedit.data.Point;
import jgpstrackedit.data.Track;
import jgpstrackedit.trackfile.gpxtrack.GPXTrackHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class GPXTrackHandlerImpl
implements GPXTrackHandler {
    public static final boolean DEBUG = false;
    private Track track;
    private Point point;
    private boolean metadataFlag = false;

    @Override
    public void handle_gpsies_totalAscentMeter(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void handle_text(String data, Attributes meta) throws SAXException {
        this.track.setLinkText(data);
    }

    @Override
    public void start_trkpt(Attributes meta) throws SAXException {
        this.point = new Point(meta.getValue("lon"), meta.getValue("lat"));
        this.track.add(this.point);
    }

    @Override
    public void end_trkpt() throws SAXException {
    }

    @Override
    public void start_link(Attributes meta) throws SAXException {
        this.track.setLink(meta.getValue("href"));
    }

    @Override
    public void end_link() throws SAXException {
    }

    @Override
    public void start_trk(Attributes meta) throws SAXException {
    }

    @Override
    public void end_trk() throws SAXException {
    }

    @Override
    public void start_extensions(Attributes meta) throws SAXException {
    }

    @Override
    public void end_extensions() throws SAXException {
    }

    @Override
    public void handle_time(String data, Attributes meta) throws SAXException {
        if (this.metadataFlag) {
            this.track.setTime(data);
        } else if (this.point != null) {
            this.point.setTime(data);
        }
    }

    @Override
    public void start_trkseg(Attributes meta) throws SAXException {
    }

    @Override
    public void end_trkseg() throws SAXException {
    }

    @Override
    public void handle_gpsies_maxHeightMeter(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void handle_name(String data, Attributes meta) throws SAXException {
        if (this.metadataFlag) {
            this.track.setName(data);
        }
    }

    @Override
    public void handle_gpsies_totalDescentMeter(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void handle_gpsies_property(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void handle_gpsies_minHeightMeter(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void start_gpx(Attributes meta) throws SAXException {
        this.track = new Track();
        StringBuilder gpxAttributes = new StringBuilder();
        int i = 0;
        while (i < meta.getLength()) {
            gpxAttributes.append(String.valueOf(meta.getQName(i)) + "=\"" + meta.getValue(i) + "\" ");
            ++i;
        }
        this.track.setGpxAttributes(gpxAttributes.toString());
    }

    @Override
    public void end_gpx() throws SAXException {
        this.track.setValid(true);
    }

    @Override
    public void handle_gpsies_trackLengthMeter(String data, Attributes meta) throws SAXException {
    }

    @Override
    public void handle_ele(String data, Attributes meta) throws SAXException {
        if (this.point != null) {
            this.point.setElevation(data);
        }
    }

    @Override
    public void start_metadata(Attributes meta) throws SAXException {
        this.metadataFlag = true;
    }

    @Override
    public void end_metadata() throws SAXException {
        this.metadataFlag = false;
    }

    public Track getTrack() {
        return this.track;
    }
}

