/*
 * Decompiled with CFR 0.152.
 */
package shared.checklist;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import shared.checklist.JCheckListData;
import shared.checklist.JSeparatorListCellRenderer;

public class JCheckListCellRenderer
extends JCheckBox
implements ListCellRenderer {
    protected static EmptyBorder m_noBorder = new EmptyBorder(1, 1, 1, 1);
    protected static JSeparatorListCellRenderer m_defRenderer = new JSeparatorListCellRenderer();

    public JCheckListCellRenderer() {
        this.setOpaque(true);
        this.setBorder(m_noBorder);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JCheckListData data = (JCheckListData)value;
        assert (data instanceof JCheckListData);
        if (data instanceof JCheckListData && !data.isSeparator()) {
            this.setFont(list.getFont());
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            Border border = cellHasFocus ? UIManager.getBorder("List.focusCellHighlightBorder") : m_noBorder;
            this.setBorder(border);
            this.setText(data.toString());
            this.setSelected(data.isChecked());
            return this;
        }
        return m_defRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
    }
}

