/*
 * Decompiled with CFR 0.152.
 */
package shared.checklist;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.UIManager;
import shared.checklist.JCheckListData;

final class JCheckListListener
extends MouseAdapter
implements KeyListener {
    protected JList m_list;
    protected int m_checkBoxWidth = 0;

    protected void doToggleCheck() {
        int index = this.m_list.getSelectedIndex();
        if (index >= 0) {
            Object obj = this.m_list.getModel().getElementAt(index);
            assert (obj instanceof JCheckListData);
            if (obj instanceof JCheckListData) {
                JCheckListData data;
                data.setChecked(!(data = (JCheckListData)obj).isChecked());
                this.m_list.repaint();
            }
        }
    }

    public JCheckListListener(JList list) {
        this.m_list = list;
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == ' ') {
            this.doToggleCheck();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mouseClicked(MouseEvent ev) {
        if (this.m_checkBoxWidth == 0) {
            this.m_checkBoxWidth = ((Icon)UIManager.get("CheckBox.icon")).getIconWidth() + (Integer)UIManager.get("CheckBox.textIconGap") / 2;
        }
        if (ev.getX() <= this.m_checkBoxWidth) {
            this.doToggleCheck();
        }
    }
}

