/*
 * Decompiled with CFR 0.152.
 */
package shared.checksumhelper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.MessageDigest;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import shared.proglistener.ProgListener;
import shared.proglistener.ProgNotify;

public class JChecksumHelper {
    private static final int BUF_SIZE = 4096;
    private byte[] m_byteArray;

    public byte[] getChecksum() {
        return this.m_byteArray;
    }

    public String getChecksumAsString() {
        int index = 0;
        StringBuilder str = new StringBuilder();
        while (index < this.m_byteArray.length) {
            str.append(String.format("%02x", this.m_byteArray[index++]));
        }
        return str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCalculateMD(File file, ProgListener listener, String algo) {
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(file);
            long size = file.length();
            CRC32 crc32 = null;
            MessageDigest md = null;
            Adler32 adler32 = null;
            if (algo.equalsIgnoreCase("CRC32")) {
                crc32 = new CRC32();
            } else if (algo.equalsIgnoreCase("Adler32")) {
                adler32 = new Adler32();
            } else {
                md = MessageDigest.getInstance(algo);
            }
            byte[] buf = new byte[4096];
            int readed = -1;
            if (listener != null) {
                listener.notify(new ProgNotify(0, 0, new Long(size).toString()));
            }
            long total = size;
            boolean bAbort = false;
            while (size != 0L && (readed = inStream.read(buf)) >= 0) {
                if (crc32 != null) {
                    crc32.update(buf, 0, readed);
                } else if (adler32 != null) {
                    adler32.update(buf, 0, readed);
                } else {
                    md.update(buf, 0, readed);
                }
                assert (size <= (long)readed);
                if (listener == null || !(bAbort = listener.notify(new ProgNotify(1, (int)(1000L - (size -= (long)readed) * 1000L / total), null)))) continue;
            }
            if (bAbort) {
                if (listener != null) {
                    listener.notify(new ProgNotify(-2, 0, null));
                }
            } else {
                this.m_byteArray = crc32 != null ? this.longToByteArray4(crc32.getValue()) : (adler32 != null ? this.longToByteArray4(adler32.getValue()) : md.digest());
                int index = 0;
                StringBuilder str = new StringBuilder();
                String temp = null;
                while (index < this.m_byteArray.length) {
                    temp = String.format("%02x", this.m_byteArray[index++]);
                    str.append(temp);
                }
                if (listener != null) {
                    listener.notify(new ProgNotify(2, 1000, str.toString()));
                }
            }
        }
        catch (FileNotFoundException ex) {
            if (listener != null) {
                listener.notify(new ProgNotify(-1, 0, ex.toString()));
            }
        }
        catch (Exception ex) {
            if (listener != null) {
                listener.notify(new ProgNotify(-1, 0, ex.toString()));
            }
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public byte[] longToByteArray4(long l) {
        byte[] byteArray = new byte[4];
        byteArray[3] = (byte)(l & 0xFFL);
        byteArray[2] = (byte)(l >> 8 & 0xFFL);
        byteArray[1] = (byte)(l >> 16 & 0xFFL);
        byteArray[0] = (byte)(l >> 24 & 0xFFL);
        return byteArray;
    }

    public void calculateChecksum(File file, ProgListener listener, String algo) {
        final File file_ = file;
        final ProgListener listener_ = listener;
        final String algo_ = algo;
        Thread thread = new Thread(){

            public void run() {
                JChecksumHelper.this.doCalculateMD(file_, listener_, algo_);
            }
        };
        thread.start();
    }

    public void calculateChecksum(String fileName, ProgListener listener, String algo) {
        this.calculateChecksum(new File(fileName), listener, algo);
    }
}

