/*
 * Decompiled with CFR 0.152.
 */
package shared.progbar;

import java.awt.Dimension;
import shared.aa.JAAProgressBar;

public class JProgBar
extends JAAProgressBar {
    public JProgBar() {
        this.reset();
    }

    public JProgBar(int orient) {
        super(orient);
        this.reset();
    }

    public JProgBar(int min, int max) {
        super(min, max);
        this.reset();
    }

    public JProgBar(int orient, int min, int max) {
        super(orient, min, max);
        this.reset();
    }

    public void setValue(int val) {
        super.setValue(val);
        this.paintNow();
    }

    public void setString(String str) {
        if (str != null && str.contains("%1")) {
            int min = this.getMinimum();
            int max = this.getMaximum();
            int percent = 0;
            if (max != min) {
                int val = this.getValue();
                percent = (val - min) * 100 / (max - min);
                str = str.replace("%1", percent + "%");
            }
        }
        super.setString(str);
        super.setStringPainted(true);
        this.paintNow();
    }

    public void reset() {
        super.setValue(0);
        super.setStringPainted(false);
        this.paintNow();
    }

    public void paintNow() {
        Dimension dim = this.getSize();
        this.paintImmediately(0, 0, dim.width, dim.width);
    }
}

