/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.exportimport;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.exportimport.ImportException;
import java.io.File;
import java.util.Observable;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLImporter
extends Observable
implements Runnable {
    private int passwordsCount;
    private int tagsCount;
    private File file;
    private String key;
    private int minProgress;
    private int maxProgress;
    private int progress;
    private boolean overWrite;
    private boolean allFieldsAreEncrypted;

    public XMLImporter(File file, String key, boolean overWrite, boolean allFieldsAreEncrypted) {
        this.file = file;
        this.key = key;
        this.minProgress = 0;
        this.maxProgress = 0;
        this.progress = 0;
        this.passwordsCount = 0;
        this.tagsCount = 0;
        this.overWrite = overWrite;
        this.allFieldsAreEncrypted = allFieldsAreEncrypted;
    }

    @Override
    public void run() {
        Domain domain = Domain.getInstance();
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(this.file);
            Element elmRoot = document.getDocumentElement();
            elmRoot.normalize();
            NodeList nodesSpecification = elmRoot.getElementsByTagName("Specifications");
            if (nodesSpecification.getLength() < 1) {
                this.showErrorDialog();
                throw new ImportException("There is no Specifications element.");
            }
            if (nodesSpecification.getLength() > 1) {
                this.showErrorDialog();
                throw new ImportException("There is more than one Specifications element.");
            }
            Element elmSpecifications = (Element)nodesSpecification.item(0);
            NodeList nodesPasswords = elmRoot.getElementsByTagName("Passwords");
            if (nodesPasswords.getLength() < 1) {
                this.showErrorDialog();
                throw new ImportException("There is no Passwords element.");
            }
            if (nodesPasswords.getLength() > 1) {
                this.showErrorDialog();
                throw new ImportException("There is more than one Passwords element.");
            }
            Element elmPasswords = (Element)nodesPasswords.item(0);
            NodeList nodesVersion = elmSpecifications.getElementsByTagName("MyPasswordsVersion");
            if (nodesVersion.getLength() < 1) {
                this.showErrorDialog();
                throw new ImportException("There is no MyPasswordsVersion element.");
            }
            Element elmVersion = (Element)nodesVersion.item(0);
            String strVersion = elmVersion.getTextContent().trim();
            float version = Float.parseFloat(strVersion);
            if (version > domain.getMyPasswordsVersion()) {
                this.showErrorDialog();
                throw new ImportException("The XML file has been created by a newer version of MyPasswords.");
            }
            NodeList nodesPasswordsCount = elmSpecifications.getElementsByTagName("PasswordsCount");
            if (nodesPasswordsCount.getLength() < 1) {
                this.showErrorDialog();
                throw new ImportException("There is no PasswordsCount element.");
            }
            Element elmPasswordsCount = (Element)nodesPasswordsCount.item(0);
            this.passwordsCount = Integer.parseInt(elmPasswordsCount.getTextContent().trim());
            NodeList nodesTagsCount = elmSpecifications.getElementsByTagName("TagsCount");
            if (nodesTagsCount.getLength() < 1) {
                this.showErrorDialog();
                throw new ImportException("There is no TagsCount element.");
            }
            Element elmTagsCount = (Element)nodesTagsCount.item(0);
            this.tagsCount = Integer.parseInt(elmTagsCount.getTextContent().trim());
            this.maxProgress = this.passwordsCount;
            this.setChanged();
            this.notifyObservers("init");
            nodesPasswords = elmPasswords.getElementsByTagName("Password");
            for (int i = 0; i < nodesPasswords.getLength(); ++i) {
                Element elmPassword = (Element)nodesPasswords.item(i);
                if (elmPassword.getChildNodes().getLength() < 2) continue;
                NodeList nodesTemp = elmPassword.getElementsByTagName("Title");
                if (nodesTemp.getLength() < 1) {
                    this.showErrorDialog();
                    throw new ImportException("There is no Title element.");
                }
                Element elmTitle = (Element)nodesTemp.item(0);
                nodesTemp = elmPassword.getElementsByTagName("Description");
                if (nodesTemp.getLength() < 1) {
                    this.showErrorDialog();
                    throw new ImportException("There is no Description element.");
                }
                Element elmDescription = (Element)nodesTemp.item(0);
                nodesTemp = elmPassword.getElementsByTagName("Username");
                if (nodesTemp.getLength() < 1) {
                    this.showErrorDialog();
                    throw new ImportException("There is no Username element.");
                }
                Element elmUsername = (Element)nodesTemp.item(0);
                nodesTemp = elmPassword.getElementsByTagName("Password");
                if (nodesTemp.getLength() < 1) {
                    this.showErrorDialog();
                    throw new ImportException("There is no Password element.");
                }
                Element elmPasswordValue = (Element)nodesTemp.item(0);
                nodesTemp = elmPassword.getElementsByTagName("URL");
                if (nodesTemp.getLength() < 1) {
                    this.showErrorDialog();
                    throw new ImportException("There is no URL element.");
                }
                Element elmURL = (Element)nodesTemp.item(0);
                PasswordEntry passwordEntry = new PasswordEntry(elmTitle.getTextContent().trim());
                if (this.allFieldsAreEncrypted) {
                    passwordEntry.setTitle(this.decrypt(passwordEntry.getTitle()));
                }
                if (passwordEntry.loadByTitle(true) && passwordEntry.getId() > 0) {
                    if (this.overWrite) {
                        if (this.allFieldsAreEncrypted) {
                            passwordEntry.setUrl(this.decrypt(elmURL.getTextContent().trim()));
                            passwordEntry.setDescription(this.decrypt(elmDescription.getTextContent().trim()));
                            passwordEntry.setUsername(this.decrypt(elmUsername.getTextContent().trim()));
                        } else {
                            passwordEntry.setUrl(elmURL.getTextContent().trim());
                            passwordEntry.setDescription(elmDescription.getTextContent().trim());
                            passwordEntry.setUsername(elmUsername.getTextContent().trim());
                        }
                        passwordEntry.setPassword(this.decrypt(elmPasswordValue.getTextContent()));
                        passwordEntry.save();
                    }
                } else {
                    if (this.allFieldsAreEncrypted) {
                        passwordEntry.setUrl(this.decrypt(elmURL.getTextContent().trim()));
                        passwordEntry.setDescription(this.decrypt(elmDescription.getTextContent().trim()));
                        passwordEntry.setUsername(this.decrypt(elmUsername.getTextContent().trim()));
                    } else {
                        passwordEntry.setUrl(elmURL.getTextContent().trim());
                        passwordEntry.setDescription(elmDescription.getTextContent().trim());
                        passwordEntry.setUsername(elmUsername.getTextContent().trim());
                    }
                    passwordEntry.setPassword(this.decrypt(elmPasswordValue.getTextContent()));
                    passwordEntry.save();
                }
                NodeList nodesTags = elmPassword.getElementsByTagName("Tag");
                if (this.overWrite) {
                    passwordEntry.clearTags();
                }
                for (int j = 0; j < nodesTags.getLength(); ++j) {
                    Element elmTag = (Element)nodesTags.item(j);
                    if (this.allFieldsAreEncrypted) {
                        passwordEntry.addTag(this.decrypt(elmTag.getTextContent().trim()));
                        continue;
                    }
                    passwordEntry.addTag(elmTag.getTextContent().trim());
                }
                ++this.progress;
                this.setChanged();
                this.notifyObservers("progress");
            }
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
        }
    }

    private String decrypt(String text) {
        try {
            return Utils.decrypt(this.key, text);
        }
        catch (Exception ex) {
            Logger.log(ex.getMessage());
            return "";
        }
    }

    private void showErrorDialog() {
        JOptionPane.showMessageDialog(null, "Error in import process!\nCheck the log file for more details.", "Error", 0);
    }

    public File getFile() {
        return this.file;
    }

    public String getKey() {
        return this.key;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public int getMinProgress() {
        return this.minProgress;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getProgressPercent() {
        return (int)Math.floor(this.progress * 100 / this.maxProgress);
    }

    public int getPasswordsCount() {
        return this.passwordsCount;
    }

    public int getTagsCount() {
        return this.tagsCount;
    }

    public boolean isOverWrite() {
        return this.overWrite;
    }

    public void setOverWrite(boolean overWrite) {
        this.overWrite = overWrite;
    }
}

