/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class ChangePasswordDialog
extends JDialog {
    private JButton btnCancel;
    private JButton btnOk;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel lblOldPassword;
    private JPanel pnlMain;
    private JPasswordField txtConfirmation;
    private JPasswordField txtOldPassword;
    private JPasswordField txtPassword;

    public ChangePasswordDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.myInitComponents();
        Utils.setCenterOfParent((JFrame)this.getParent(), (JDialog)this);
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.lblOldPassword = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.txtOldPassword = new JPasswordField();
        this.txtPassword = new JPasswordField();
        this.txtConfirmation = new JPasswordField();
        this.btnCancel = new JButton();
        this.btnOk = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Change Password");
        this.setResizable(false);
        this.pnlMain.setBackground(new Color(255, 255, 255));
        this.lblOldPassword.setText("Old password:");
        this.jLabel2.setText("New password:");
        this.jLabel3.setText("Confirmation:");
        this.txtOldPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.txtOldPasswordKeyPressed(evt);
            }
        });
        this.txtPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.txtPasswordKeyPressed(evt);
            }
        });
        this.txtConfirmation.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.txtConfirmationKeyPressed(evt);
            }
        });
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.btnCancelActionPerformed(evt);
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.btnCancelKeyPressed(evt);
            }
        });
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.btnOkActionPerformed(evt);
            }
        });
        this.btnOk.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                ChangePasswordDialog.this.btnOkKeyPressed(evt);
            }
        });
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pnlMainLayout.createSequentialGroup().addComponent(this.btnOk, -2, 80, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btnCancel, -2, 80, -2)).addGroup(pnlMainLayout.createSequentialGroup().addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblOldPassword).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(38, 38, 38).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtConfirmation, -1, 185, Short.MAX_VALUE).addComponent(this.txtPassword, -1, 185, Short.MAX_VALUE).addComponent(this.txtOldPassword, -1, 185, Short.MAX_VALUE)))).addGap(39, 39, 39)));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlMainLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.txtOldPassword, -2, -1, -2).addComponent(this.lblOldPassword)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.txtPassword, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.txtConfirmation, -2, -1, -2)).addGap(18, 18, 18).addGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnCancel).addComponent(this.btnOk)).addContainerGap(25, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void txtOldPasswordKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.btnOkActionPerformed(null);
        } else if (key == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void txtConfirmationKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.btnOkActionPerformed(null);
        } else if (key == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
        System.gc();
    }

    private void btnCancelKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.btnOkActionPerformed(null);
        } else if (key == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        try {
            Domain domain = Domain.getInstance();
            String oldPassword = domain.getSetting("password", null);
            oldPassword = oldPassword != null ? oldPassword : "";
            String enteredOldPassword = new String(this.txtOldPassword.getPassword());
            enteredOldPassword = Utils.SHA256(enteredOldPassword);
            if (oldPassword.length() > 0 && !oldPassword.equals(enteredOldPassword)) {
                JOptionPane.showMessageDialog(this, "Incorrect password!", "Warning", 2);
            } else if (this.txtPassword.getPassword().length >= 8) {
                if (!Arrays.equals(this.txtPassword.getPassword(), this.txtConfirmation.getPassword())) {
                    JOptionPane.showMessageDialog(this, "Confirmation password doesn't match!", "Warning", 2);
                } else if (domain.setHashedSetting("password", new String(this.txtPassword.getPassword()))) {
                    PasswordEntry[] allPasswords = PasswordEntry.getAllPasswordEntries();
                    domain.setPassword(new String(this.txtPassword.getPassword()));
                    for (int i = 0; i < allPasswords.length; ++i) {
                        PasswordEntry passwordEntry = allPasswords[i];
                        passwordEntry.save();
                    }
                    JOptionPane.showMessageDialog(this, "Your password changed successfully.", "Info", 1);
                    this.setVisible(false);
                    this.dispose();
                    System.gc();
                } else {
                    JOptionPane.showMessageDialog(this, "Error occured!", "Error", 0);
                }
            } else {
                JOptionPane.showMessageDialog(this, "Your password should be at least 8 characters long!", "Warning", 2);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            Logger.log("Failed to hash password: " + ex.getMessage());
        }
        catch (Exception ex) {
            Logger.log("Exception: " + ex.getMessage());
        }
    }

    private void btnOkKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.btnOkActionPerformed(null);
        } else if (key == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void txtPasswordKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.btnOkActionPerformed(null);
        } else if (key == 27) {
            this.btnCancelActionPerformed(null);
        }
    }

    private void myInitComponents() {
        Domain domain = Domain.getInstance();
        String currentPassword = domain.getSetting("password", null);
        if (currentPassword == null || currentPassword.length() <= 0) {
            this.lblOldPassword.setVisible(false);
            this.txtOldPassword.setVisible(false);
        }
        this.txtOldPassword.requestFocus();
    }
}

