/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.entity.PasswordEntry;
import com.ehsunbehravesh.mypasswords.entity.PasswordTag;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class PasswordTreeNode
extends DefaultMutableTreeNode {
    private ImageIcon leafIcon;
    private ImageIcon openIcon;
    private ImageIcon closedIcon;

    public PasswordTreeNode() {
        this.findIcon();
    }

    public PasswordTreeNode(Object userObject) {
        super(userObject);
        this.findIcon();
    }

    public PasswordTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        this.findIcon();
    }

    private void findIcon() {
        if (this.userObject instanceof PasswordEntry) {
            this.findPasswordEntryIcon();
        } else if (this.userObject instanceof PasswordTag) {
            this.findPasswordTagIcon(this.userObject);
        }
    }

    private void findPasswordEntryIcon() {
        this.leafIcon = new ImageIcon(ResourceLoader.class.getResource("key.png"));
    }

    private void findPasswordTagIcon(Object userObject) {
        PasswordTag tag = (PasswordTag)userObject;
        String tagTitle = tag.getTitle();
        File file = new File(Utils.getPathOfJar(true).concat("icon").concat(Utils.getFileSeparator().concat(tagTitle).concat(".png")));
        File openFile = new File(Utils.getPathOfJar(true).concat("icon").concat(Utils.getFileSeparator().concat(tagTitle).concat("-open").concat(".png")));
        File closedFile = new File(Utils.getPathOfJar(true).concat("icon").concat(Utils.getFileSeparator().concat(tagTitle).concat("-closed").concat(".png")));
        if (openFile.exists() && closedFile.exists()) {
            this.openIcon = new ImageIcon(openFile.getAbsolutePath());
            this.closedIcon = new ImageIcon(closedFile.getAbsolutePath());
        } else if (file.exists()) {
            this.openIcon = new ImageIcon(file.getAbsolutePath());
            this.closedIcon = new ImageIcon(file.getAbsolutePath());
        } else {
            this.openIcon = new ImageIcon(ResourceLoader.class.getResource("tag.png"));
            this.closedIcon = new ImageIcon(ResourceLoader.class.getResource("tag.png"));
        }
    }

    public ImageIcon getLeafIcon() {
        return this.leafIcon;
    }

    public ImageIcon getOpenIcon() {
        return this.openIcon;
    }

    public ImageIcon getClosedIcon() {
        return this.closedIcon;
    }
}

