/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.Domain;
import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.Utils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;

public class SettingsDialog
extends JDialog {
    private JFrame parent;
    private JFileChooser saveDialog;
    private JButton btnCreatePasswordRecovery;
    private JCheckBox chkCheckUpdate;
    private JCheckBox chkLogFailedLogin;
    private JCheckBox chkTrust;
    private JTabbedPane jtpSettings;
    private JLabel lblDescriptionOfRecovery;
    private JPanel pnlMain;
    private JPanel pnlTab1;
    private JPanel pnlTab2;
    private JPanel pnlTab3;

    public SettingsDialog(JFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        this.createComponents();
        this.myInitComponents();
    }

    private void initComponents() {
        this.pnlMain = new JPanel();
        this.jtpSettings = new JTabbedPane();
        this.pnlTab1 = new JPanel();
        this.chkLogFailedLogin = new JCheckBox();
        this.pnlTab2 = new JPanel();
        this.lblDescriptionOfRecovery = new JLabel();
        this.btnCreatePasswordRecovery = new JButton();
        this.chkTrust = new JCheckBox();
        this.pnlTab3 = new JPanel();
        this.chkCheckUpdate = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("Settings");
        this.setResizable(false);
        this.pnlMain.setBackground(new Color(255, 255, 255));
        this.jtpSettings.setBackground(new Color(255, 255, 255));
        this.jtpSettings.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.jtpSettingsKeyPressed(evt);
            }
        });
        this.pnlTab1.setBackground(new Color(255, 255, 255));
        this.chkLogFailedLogin.setBackground(new Color(255, 255, 255));
        this.chkLogFailedLogin.setText("Log failed logins");
        this.chkLogFailedLogin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.chkLogFailedLoginActionPerformed(evt);
            }
        });
        this.chkLogFailedLogin.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chkLogFailedLoginKeyPressed(evt);
            }
        });
        GroupLayout pnlTab1Layout = new GroupLayout(this.pnlTab1);
        this.pnlTab1.setLayout(pnlTab1Layout);
        pnlTab1Layout.setHorizontalGroup(pnlTab1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTab1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkLogFailedLogin).addContainerGap(386, Short.MAX_VALUE)));
        pnlTab1Layout.setVerticalGroup(pnlTab1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTab1Layout.createSequentialGroup().addContainerGap().addComponent(this.chkLogFailedLogin).addContainerGap(91, Short.MAX_VALUE)));
        this.jtpSettings.addTab("Log", this.pnlTab1);
        this.pnlTab2.setBackground(new Color(255, 255, 255));
        this.lblDescriptionOfRecovery.setText("<html>By creating a <b>Password Recovery File</b>, you can recover your current password. <b>Internet Connection</b> is needed for this function.</html>");
        this.btnCreatePasswordRecovery.setFont(new Font("Tahoma", 1, 11));
        this.btnCreatePasswordRecovery.setText("Create Password Recovery File");
        this.btnCreatePasswordRecovery.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.btnCreatePasswordRecoveryActionPerformed(evt);
            }
        });
        this.btnCreatePasswordRecovery.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.btnCreatePasswordRecoveryKeyPressed(evt);
            }
        });
        this.chkTrust.setBackground(new Color(255, 255, 255));
        this.chkTrust.setText("I trust MyPasswords Server");
        this.chkTrust.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chkTrustKeyPressed(evt);
            }
        });
        GroupLayout pnlTab2Layout = new GroupLayout(this.pnlTab2);
        this.pnlTab2.setLayout(pnlTab2Layout);
        pnlTab2Layout.setHorizontalGroup(pnlTab2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTab2Layout.createSequentialGroup().addContainerGap().addGroup(pnlTab2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblDescriptionOfRecovery, GroupLayout.Alignment.LEADING, -1, 489, Short.MAX_VALUE).addGroup(pnlTab2Layout.createSequentialGroup().addComponent(this.chkTrust).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 89, Short.MAX_VALUE).addComponent(this.btnCreatePasswordRecovery))).addContainerGap()));
        pnlTab2Layout.setVerticalGroup(pnlTab2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pnlTab2Layout.createSequentialGroup().addContainerGap().addComponent(this.lblDescriptionOfRecovery, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 31, Short.MAX_VALUE).addGroup(pnlTab2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btnCreatePasswordRecovery, -2, 36, -2).addComponent(this.chkTrust)).addContainerGap()));
        this.lblDescriptionOfRecovery.getAccessibleContext().setAccessibleName("<html>By creating a <b>Password Recovery File</b>, you can recover your current password. <b>Internet Connection</b> is needed</html>");
        this.jtpSettings.addTab("Password Recovery", this.pnlTab2);
        this.pnlTab3.setBackground(new Color(255, 255, 255));
        this.chkCheckUpdate.setBackground(new Color(255, 255, 255));
        this.chkCheckUpdate.setText("Check for new versions");
        this.chkCheckUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsDialog.this.chkCheckUpdateActionPerformed(evt);
            }
        });
        this.chkCheckUpdate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                SettingsDialog.this.chkCheckUpdateKeyPressed(evt);
            }
        });
        GroupLayout pnlTab3Layout = new GroupLayout(this.pnlTab3);
        this.pnlTab3.setLayout(pnlTab3Layout);
        pnlTab3Layout.setHorizontalGroup(pnlTab3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTab3Layout.createSequentialGroup().addContainerGap().addComponent(this.chkCheckUpdate).addContainerGap(336, Short.MAX_VALUE)));
        pnlTab3Layout.setVerticalGroup(pnlTab3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlTab3Layout.createSequentialGroup().addContainerGap().addComponent(this.chkCheckUpdate).addContainerGap(91, Short.MAX_VALUE)));
        this.jtpSettings.addTab("Update", this.pnlTab3);
        GroupLayout pnlMainLayout = new GroupLayout(this.pnlMain);
        this.pnlMain.setLayout(pnlMainLayout);
        pnlMainLayout.setHorizontalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtpSettings, GroupLayout.Alignment.TRAILING));
        pnlMainLayout.setVerticalGroup(pnlMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jtpSettings));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pnlMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void chkLogFailedLoginActionPerformed(ActionEvent evt) {
        this.chkLogFailedLoginActionPerform(evt);
    }

    private void btnCreatePasswordRecoveryActionPerformed(ActionEvent evt) {
        this.btnCreatePasswordRecoveryActionPerform(evt);
    }

    private void jtpSettingsKeyPressed(KeyEvent evt) {
        this.close();
    }

    private void chkLogFailedLoginKeyPressed(KeyEvent evt) {
        this.close();
    }

    private void chkTrustKeyPressed(KeyEvent evt) {
        this.close();
    }

    private void btnCreatePasswordRecoveryKeyPressed(KeyEvent evt) {
        this.close();
    }

    private void chkCheckUpdateActionPerformed(ActionEvent evt) {
        this.chkCheckUpdateActionPerform(evt);
    }

    private void chkCheckUpdateKeyPressed(KeyEvent evt) {
    }

    private void createComponents() {
        this.saveDialog = new JFileChooser();
    }

    private void myInitComponents() {
        this.setComponentOrientation(this.parent.getComponentOrientation());
        this.setFont(this.parent.getFont());
        Utils.setCenterOfParent(this.parent, (JDialog)this);
        Domain domain = Domain.getInstance();
        String value = domain.getSetting("log_failed_logins", null);
        if (value != null) {
            int intValue = Integer.parseInt(value);
            if (intValue > 1000000) {
                this.chkLogFailedLogin.setSelected(false);
            } else {
                this.chkLogFailedLogin.setSelected(true);
            }
        } else {
            this.chkLogFailedLogin.setSelected(true);
        }
        String checkUpdate = domain.getSetting("check_updates", null);
        if (checkUpdate != null) {
            boolean booleanCheck = Boolean.parseBoolean(checkUpdate);
            this.chkCheckUpdate.setSelected(booleanCheck);
        } else {
            this.chkCheckUpdate.setSelected(true);
        }
    }

    private void chkLogFailedLoginActionPerform(ActionEvent evt) {
        Domain domain = Domain.getInstance();
        if (this.chkLogFailedLogin.isSelected()) {
            domain.setSetting("log_failed_logins", Utils.randomInt(0, 1000000) + "", null);
        } else {
            domain.setSetting("log_failed_logins", Utils.randomInt(1000001, 2000000) + "", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void btnCreatePasswordRecoveryActionPerform(ActionEvent evt) {
        block19: {
            if (!this.chkTrust.isSelected()) {
                JOptionPane.showMessageDialog(this, "You should select trusting the server.", "Trust", 1);
                return;
            }
            int answer = this.saveDialog.showSaveDialog(this);
            boolean canSave = false;
            if (answer != 1) {
                File file = this.saveDialog.getSelectedFile();
                if (file.exists()) {
                    int answer2 = JOptionPane.showConfirmDialog(this, "The file has already existed. Do you want to rewrite it?", "Warning", 0, 2);
                    if (answer2 == 0) {
                        canSave = true;
                    }
                } else {
                    canSave = true;
                }
                if (canSave) {
                    Domain domain = Domain.getInstance();
                    OutputStreamWriter writer = null;
                    try {
                        String recoveryContent = Utils.createRecoveryContent(domain.getPassword());
                        if (recoveryContent != null) {
                            writer = new FileWriter(file);
                            writer.write(recoveryContent);
                            JOptionPane.showMessageDialog(this, "Recovery file has been created successfully!", "Finish", 1);
                            break block19;
                        }
                        throw new Exception("Recovery Content is null!");
                    }
                    catch (Exception ex) {
                        Logger.log(ex.getMessage());
                        JOptionPane.showMessageDialog(this, "Recovery File creation failed!", "Fatal Error", 0);
                    }
                    finally {
                        if (writer != null) {
                            try {
                                writer.close();
                            }
                            catch (IOException ex) {
                                Logger.log(ex.getMessage());
                            }
                        }
                    }
                }
            }
        }
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
        System.gc();
    }

    private void chkCheckUpdateActionPerform(ActionEvent evt) {
        Domain domain = Domain.getInstance();
        domain.setSetting("check_updates", this.chkCheckUpdate.isSelected() + "", null);
    }
}

