/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.io;

import com.ehsunbehravesh.mypasswords.Logger;
import com.ehsunbehravesh.mypasswords.io.FileLoaderMessage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Observable;
import javax.activation.MimetypesFileTypeMap;

public class FileLoader
extends Observable
implements Runnable {
    private int bufferSize;
    private File file;
    private FileInputStream fileInputStream;
    private InputStreamReader inputStreamReader;
    private Byte[] content;
    private String filename;
    private String mimeType;
    private long size;
    private Charset charset;

    public FileLoader(File file, int bufferSize) {
        this.file = file;
        this.bufferSize = bufferSize;
    }

    protected void finalize() throws Throwable {
        if (this.fileInputStream != null) {
            this.fileInputStream.close();
        }
        if (this.inputStreamReader != null) {
            this.inputStreamReader.close();
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.filename = this.file.getName();
            this.size = this.file.length();
            MimetypesFileTypeMap fileTypeMap = new MimetypesFileTypeMap();
            this.mimeType = fileTypeMap.getContentType(this.file);
            this.fileInputStream = new FileInputStream(this.file);
            this.inputStreamReader = new InputStreamReader(this.fileInputStream);
            this.charset = Charset.forName(this.inputStreamReader.getEncoding());
            byte[] buffer = new byte[this.bufferSize];
            ArrayList<Byte> contentOfFile = new ArrayList<Byte>();
            int readBytes = -1;
            while ((readBytes = this.fileInputStream.read(buffer)) != -1) {
                byte[] realData = new byte[readBytes];
                System.arraycopy(buffer, 0, realData, 0, realData.length);
                for (int i = 0; i < realData.length; ++i) {
                    byte b = realData[i];
                    contentOfFile.add(b);
                }
                buffer = new byte[this.bufferSize];
                this.setChanged();
                this.notifyObservers(new FileLoaderMessage(1));
                Thread.sleep(1L);
            }
            this.content = new Byte[contentOfFile.size()];
            this.content = contentOfFile.toArray(this.content);
            this.setChanged();
            this.notifyObservers(new FileLoaderMessage(2, "loading file finished."));
        }
        catch (Exception ex) {
            this.setChanged();
            this.notifyObservers(new FileLoaderMessage(3, "Error in reading file! " + ex.getMessage()));
            Logger.log(ex.getMessage());
        }
        finally {
            if (this.fileInputStream != null) {
                try {
                    this.fileInputStream.close();
                }
                catch (IOException ex) {
                    Logger.log(ex.getMessage());
                }
            }
            if (this.inputStreamReader != null) {
                try {
                    this.inputStreamReader.close();
                }
                catch (IOException ex) {
                    Logger.log(ex.getMessage());
                }
            }
        }
    }

    public Byte[] getContent() {
        return this.content;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getSize() {
        return this.size;
    }
}

