/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.data;

import de.saring.util.data.IdObject;
import de.saring.util.data.IdObjectListChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class IdObjectList<T extends IdObject>
implements Iterable<T>,
Serializable {
    private List<T> lIdObjects = new ArrayList<T>();
    private List<IdObjectListChangeListener> listChangelisteners = new ArrayList<IdObjectListChangeListener>();

    public T getByID(int id) {
        for (IdObject t : this.lIdObjects) {
            if (t.getId() != id) continue;
            return (T)t;
        }
        return null;
    }

    public T getAt(int index) {
        return (T)((IdObject)this.lIdObjects.get(index));
    }

    public int indexOf(T t) {
        return this.lIdObjects.indexOf(t);
    }

    public void set(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Must not be null!");
        }
        if (((IdObject)t).getId() <= 0) {
            throw new IllegalArgumentException("ID must be a positive integer > 0!");
        }
        try {
            int i = 0;
            while (i < this.lIdObjects.size()) {
                IdObject temp = (IdObject)this.lIdObjects.get(i);
                if (((IdObject)t).getId() == temp.getId()) {
                    this.lIdObjects.set(i, t);
                    return;
                }
                ++i;
            }
            this.lIdObjects.add(t);
        }
        finally {
            this.notifyAllListChangelisteners();
        }
    }

    public boolean removeByID(int id) {
        T t = this.getByID(id);
        if (t != null) {
            boolean removed = this.lIdObjects.remove(t);
            if (removed) {
                this.notifyAllListChangelisteners();
            }
            return removed;
        }
        return false;
    }

    public int getNewID() {
        HashSet<Integer> hsIDs = new HashSet<Integer>();
        for (IdObject t : this.lIdObjects) {
            hsIDs.add(t.getId());
        }
        int newID = 1;
        while (hsIDs.contains(newID)) {
            ++newID;
        }
        return newID;
    }

    public int size() {
        return this.lIdObjects.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.lIdObjects.iterator();
    }

    protected List<T> getIDObjects() {
        return this.lIdObjects;
    }

    public void addListChangeListener(IdObjectListChangeListener listener) {
        this.listChangelisteners.add(listener);
    }

    protected void notifyAllListChangelisteners() {
        for (IdObjectListChangeListener listener : this.listChangelisteners) {
            listener.listChanged();
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(this.getClass().getName()) + ":\n");
        if (this.lIdObjects != null) {
            for (IdObject t : this.lIdObjects) {
                sBuilder.append(t);
            }
        }
        return sBuilder.toString();
    }
}

