/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.unitcalc;

public class ConvertUtils {
    private static final double SEMICIRCLE_2_DEGREES = 180.0 / Math.pow(2.0, 31.0);

    public static double convertMiles2Kilometer(double miles) {
        return miles * 1.609344;
    }

    public static int convertMiles2Kilometer(int miles) {
        return (int)Math.round(ConvertUtils.convertMiles2Kilometer((double)miles));
    }

    public static double convertKilometer2Miles(double kilometers, boolean fRound) {
        double dResult = kilometers / 1.609344;
        if (fRound) {
            long lValue = Math.round(1000.0 * dResult);
            return (double)lValue / 1000.0;
        }
        return dResult;
    }

    public static int convertKilometer2Miles(int kilometers) {
        return (int)Math.round(ConvertUtils.convertKilometer2Miles(kilometers, false));
    }

    public static int convertFeet2Meter(int feet) {
        return Math.round((float)feet * 0.30479f);
    }

    public static int convertMeter2Feet(int meters) {
        return Math.round((float)meters / 0.30479f);
    }

    public static float convertMeterPerSecond2KilometerPerHour(float meterPerSecond) {
        return meterPerSecond * 3.6f;
    }

    public static short convertFahrenheit2Celsius(short fahrenheit) {
        return (short)Math.round((float)(fahrenheit - 32) * 0.555f);
    }

    public static short convertCelsius2Fahrenheit(short celsius) {
        return (short)(Math.round((float)celsius / 0.555f) + 32);
    }

    public static double convertKilogram2Lbs(double kilogram) {
        return kilogram * 2.2046;
    }

    public static double convertLbs2Kilogram(double pounds) {
        return pounds / 2.2046;
    }

    public static double convertSemicircle2Degree(int semicircles) {
        return (double)semicircles * SEMICIRCLE_2_DEGREES;
    }
}

